//////////////////////////////////////////////////////////////////////////
// FILE:         vd_diaglog_main_prj.cpp
// PROJECT:      GEN2(Next GEN,MY13)
// SW-COMPONENT: DiagLog
//----------------------------------------------------------------------
//
// DESCRIPTION: DiagLog MainPrj class - Project Depending settings
//              Protocol, Plugins ...
//              
//----------------------------------------------------------------------
// COPYRIGHT:    (c) 2012 Robert Bosch GmbH, Hildesheim
// HISTORY:      
// Date      | Author                       | Modification
// 31.07.12  | BSOT Plischke                | Initial version
//////////////////////////////////////////////////////////////////////////
// first include diaglog settings
#include <common/framework/vd_diaglog_settings.h>

#ifndef VD_DIAGLOG_INCLUDEGUARD_vd_diaglog_main
   #include "common/framework/vd_diaglog_main.h"
#endif

#ifndef VD_DIAGLOG_INCLUDEGUARD_vd_diaglog_system_variables
   #include <common/framework/vd_diaglog_system_variables.h>
#endif  

#ifndef VD_DIAGLOG_INCLUDEGUARD_vd_diaglog_trace
   #include <common/framework/vd_diaglog_trace.h>  
#endif   

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_DIAGLOG_INFO
#include "trcGenProj/Header/vd_diaglog_main_prj.cpp.trc.h"
#endif

#ifndef VD_DIAGLOG_INCLUDEGUARD_vd_diaglog_plugin_includes
   /* --Includes. */
   #include <project/plugin/vd_diaglog_plugin_includes.h>
#endif

DiaglogStub* vdDiagLog_tclAppPrj::m_poDiaglogStub = NULL;

vdDiagLog_tclApp* vdDiagLog_tclAppPrj::theServerPrj(DiaglogStub* poDiaglogStub)
{
   m_poDiaglogStub = poDiaglogStub;
   return vdDiagLog_tclApp::theServer();
}

vdDiagLog_tclAppPrj::vdDiagLog_tclAppPrj():
   m_poCanIF(NULL),
   m_poNotificationPlugin(NULL),
   m_poReportDtcDM1TriggerPlugIn(NULL),
   m_poDtcCfgChk(NULL)
{
}

vdDiagLog_tclAppPrj::~vdDiagLog_tclAppPrj()
{
   m_poCanIF = NULL;
   m_poNotificationPlugin = NULL;
   m_poReportDtcDM1TriggerPlugIn = NULL;
   m_poDtcCfgChk = NULL;
}

///////////////////////////////////////////////////////////////////////////////////
// 
// FUNCTION: tVoid vdDiagLog_tclAppPrj::bCreatePrjSpecificConfiguration()
// 
// DESCRIPTION: create of project dependend Objects
//
// PARAMETER: none  
//
// RETURNVALUE: none
// 
///////////////////////////////////////////////////////////////////////////////////
//
//lint -e1764 // Info 1762: prioX: Member function 'vdDiagLog_tclAppPrj::bCreatePrjSpecificConfiguration(vdDiagLog_tclApp *)' could be made const
//lint -e1762 // Info 1762: prioX: Member function 'vdDiagLog_tclAppPrj::bCreatePrjSpecificConfiguration(vdDiagLog_tclApp *)' could be made const
bool vdDiagLog_tclAppPrj::bCreatePrjSpecificConfiguration(vdDiagLog_tclApp* /*poMain*/)
{
   bool bReturn = true;

   ETG_TRACE_USR1_THR(( "---  vdDiagLog_tclAppPrj::bCreateProdSpecificConfiguration => Create vdl_nsReportMemoryFactoryT"));
   _BP_TRY_BEGIN
   {
      m_poCanIF = new vdl_tclCanIf();
      m_poNotificationPlugin = new vdl_tclNotificationPlugin();	  
      m_poReportDtcDM1TriggerPlugIn = new vd_diaglog_CMCDm1Manager;
	     
	  
		/* DTC Configuration Feature Implementation */
		m_poDtcCfgChk = getInstanceOfDTCCfgChecker();
	  
		if(m_poDtcCfgChk)
		{
			ETG_TRACE_USR1_THR(( "---  vdDiagLog_tclAppPrj::bCreateProdSpecificConfiguration => setup DTC Config Repository"));
			if ( m_poDtcCfgChk->setup() != DIA_SUCCESS )
			{
				ETG_TRACE_USR1_THR(( "---  vdDiagLog_tclAppPrj::bCreateProdSpecificConfiguration => setup failed"));
			}
		}
   }
   _BP_CATCH_ALL
   {
      NORMAL_M_ASSERT_ALWAYS();
   }
   _BP_CATCH_END

   // if couldn't create
   if(NULL == m_poCanIF)
   {
      // we need a protocol, without we can't work
      ETG_TRACE_ERR_THR(( "!!!  vdDiagLog_tclAppPrj::bCreateProdSpecificConfiguration => m_poReportDtcTriggerPlugIn = NULL"));
      NORMAL_M_ASSERT_ALWAYS();
      bReturn = false;
   }

   // dummy configuration, e.g. in GM set by EOL
   vdl_tclGlobalSystemVariables::vSetSystemConf(0x01);

   return bReturn;
}
//lint +e1764 
//lint -e1762 


///////////////////////////////////////////////////////////////////////////////////
// 
// FUNCTION: tVoid vdDiagLog_tclAppPrj::vDestroyPrjSpecificConfiguration()
// 
// DESCRIPTION: destroy of project dependend Objects
//
// PARAMETER: none  
//
// RETURNVALUE: none
// 
///////////////////////////////////////////////////////////////////////////////////
//

//lint -e1764 // Info 1762: prioX: Member function 'vdDiagLog_tclAppPrj::vDestroyPrjSpecificConfiguration(void)' could be made const
//lint -e1762 // Info 1762: prioX: Member function 'vdDiagLog_tclAppPrj::vDestroyPrjSpecificConfiguration(void)' could be made const
tVoid vdDiagLog_tclAppPrj::vDestroyPrjSpecificConfiguration()
{
   delete m_poCanIF;
   m_poCanIF = NULL;

   delete m_poNotificationPlugin;
   m_poNotificationPlugin = NULL;
   delete m_poReportDtcDM1TriggerPlugIn;
   m_poReportDtcDM1TriggerPlugIn = NULL;
   
   delete m_poDtcCfgChk;
   m_poDtcCfgChk = NULL;
   
}
//lint +e1764 
//lint -e1762 
