//////////////////////////////////////////////////////////////////////////
// FILE:         vd_diaglog_configuration.h
// PROJECT:      GEN2(Next GEN,MY13)
// SW-COMPONENT: DiagLog
//----------------------------------------------------------------------
//
// DESCRIPTION: DiagLog Project Depending configurations
//              
//----------------------------------------------------------------------
// COPYRIGHT:    (c) 2012 Robert Bosch GmbH, Hildesheim
// HISTORY:      
// Date      | Author                       | Modification
// 08.08.12  | BSOT Plischke                | Initial version
//
//
//////////////////////////////////////////////////////////////////////////
#ifndef VD_DIAGLOG_INCLUDEGUARD_vd_diaglog_configuration
#define VD_DIAGLOG_INCLUDEGUARD_vd_diaglog_configuration

#ifndef VD_DIAGLOG_INCLUDEGUARD_vd_diaglog_typedefs_basic
   #include <common/framework/vd_diaglog_typedefs_basic.h>
#endif

/********************/
/***   SETTINGS   ***/
/********************/

/* AGEING COUNTER */
const vdl_teDiaglogAgeingAlgorithm           AGEING_ALGORITHM        = DIAGLOG_AGEING_ALGORITHM_SINGLE;                    // relearn DTC only if all are PASSED
const vdl_teDiaglogAgeingBlockMode           AGEING_BLOCKMODE        = DIAGLOG_AGEING_BLOCKING_NONE;                       // DTC control should not block ageing         
const vdl_teDiaglogAgeingCycle               AGEING_CYCLE_GLOBAL     = DIAGLOG_AGEING_CYCLE_ON_IGNITION_CYCLE_END;         // only requiered for DIAGLOG_AGEING_ALGORITHM_GLOBAL


/* OCCURENCE COUNTER */
const vdl_teDiaglogOccurenceCounterAlgorithm    OCCURENCE_COUNTER_ALGORITHM = DIAGLOG_OCCURENCE_COUNTER_ON_EACH_FAILED;

// Snapshot Data + Extended Data
#define DIAGLOG_USE_SNAPSHOT_DATA
#define DIAGLOG_MAX_EXTENDED_RECORDS_SUPPORTED 3
#define DIAGLOG_MAX_SNAPSHOT_RECORDS_SUPPORTED 1
// for configuration of trReportRecordData
#define DIAGLOG_MAX_BLOCKDTCLIST  1

#if 0
#define DIAGLOG_STORE_TO_EMTRACE  // DIAGLOG_STORE_TO_EMTRACE: stores each change condition to EM-Trace
#endif

#define MAX_NUMBER_OF_DYNAMIC_DATA           0

/************************************************/
/*** DEFAULTS                                 ***/
/***                                          ***/
/*** (overwriteable)                          ***/
/*** part of vd_diaglog_GlobalSystemVariables ***/
/************************************************/
#define DIAGLOG_GLOBAL_AGEING_DELFAULT          40       // Default Number of Ignitionstates till Ageing 
#define DIAGLOG_SYSTEM_CONF_DEFAULT             0        // Default System Configuration
#define DIAGLOG_BLOCKING_TIME_DEFAULT_CRANK     0        // [ms] => Default Block Time after Crank State left 
#define DIAGLOG_BLOCKING_TIME_DEFAULT_MOST      0        // [ms] => Default Block Time after MostBus Off left 


/************************************************/
/*** DEFAULTS                                 ***/
/***                                          ***/
/*** (not overwriteable)                      ***/
/************************************************/
#define DIAGLOG_BLOCKING_TIME_DEFAULT_VOLTAGE      5000  // [ms] => Time for BlockingMode: DIAGLOG_BLOCKING_MODE_VOLTAGE_TIMER
#define DIAGLOG_BLOCKING_TIME_DEFAULT_STARTUP      3000  // [ms] => Time for BlockingMode: DIAGLOG_BLOCKING_MODE_STARTUP  
#define DIAGLOG_BLOCKING_TIME_DEFAULT_POWER_RUN    5000  // [ms] => Time for BlockingMode: DIAGLOG_BLOCKING_MODE_POWER_RUN_TIMER

#define DIAGLOG_PLUGIN_STEP_TIME                    250  // [ms] => Retrigger Time for PlugIn's 
#define DIAGLOG_STORAGE_STARTUP_TIME              30000  // [ms] => first storage Time (not for SaveNow)
#define DIAGLOG_STORAGE_INTERVAL_TIME             30000  // [ms] => minimun storage Timer interval (not for SaveNow)
#define DIAGLOG_QUALIFICATION_STEP_TIME             100  // [ms] => qualfication step interval


/************************************************/
/*** Blockingmodes                            ***/
/***                                          ***/
/*** U32 Bitfield                             ***/
/************************************************/
#define DIAGLOG_BLOCKING_MODE_NONE                                0x00000000
#define DIAGLOG_BLOCKING_MODE_DIAGNOSIS                           0x00000001 // Blocking if DiagControl is switched to OFF
#define DIAGLOG_BLOCKING_MODE_STARTUP_TIMER                       0x00000002 // Blocking Time after Bootup [DIAGLOG_BLOCKING_TIME_DEFAULT_STARTUP]
#define DIAGLOG_BLOCKING_MODE_VOLTAGE_OUT_OF_RANGE                0x00000004 // Blocking if Voltage is out of range Under-/Overvaltage
#define DIAGLOG_BLOCKING_MODE_VOLTAGE_TIMER                       0x00000008 // Blocking Time after Normal-Voltage reached [DIAGLOG_BLOCKING_TIME_DEFAULT_VOLTAGE]
#define DIAGLOG_BLOCKING_MODE_POWER_NONE                          0x00000010 // Blocking if no PowerSignal available
#define DIAGLOG_BLOCKING_MODE_POWER_OFF                           0x00000020 // Blocking if Power OFF State is reached
#define DIAGLOG_BLOCKING_MODE_POWER_ACC                           0x00000040 // Blocking if Power ACC State is reached
#define DIAGLOG_BLOCKING_MODE_POWER_CRANK                         0x00000080 // Blocking if Power CRANK State is reached
#define DIAGLOG_BLOCKING_MODE_POWER_CRANK_TIMER                   0x00000100 // Blocking after coming out of CRANK-Mode
#define DIAGLOG_BLOCKING_MODE_POWER_RUN_TIMER                     0x00000200 // Blocking during 5s after coming into RUN-Mode [DIAGLOG_BLOCKING_TIME_DEFAULT_POWER_RUN]
#define DIAGLOG_BLOCKING_MODE_HS_COMM_ENABLE_NOT_ACTIVE           0x00000400 // Blocking if High Speed Comm Enable not Active
#define DIAGLOG_BLOCKING_MODE_VN_NOT_ACTIVE                       0x00000800 // Blocking if Virtual Network not Active
#define DIAGLOG_BLOCKING_MODE_NGI_SYS_STATE_SLEEP                 0x00001000 // Blocking if NGI System State is in Sleep 
#define DIAGLOG_BLOCKING_MODE_MOST_BUS_NOT_ACTIVE                 0x00002000 // Blocking if Most Bus is not active
#define DIAGLOG_BLOCKING_MODE_DTC_B101_46_CURRENT                 0x00004000 // DTC_B101_46_CURRENT Bit = 1 (GM)
#define DIAGLOG_BLOCKING_MODE_DTC_B101_47_CURRENT                 0x00008000 // DTC_B101_47_CURRENT Bit = 1 (GM)
#define DIAGLOG_BLOCKING_MODE_MOST_TIMER                          0x00010000 // U0029_TIMER_NOT_ELAPSED (GM)
#define DIAGLOG_BLOCKING_MODE_LOGISTIC_MODE                       0x00020000
#define DIAGLOG_BLOCKING_MODE_IGNITION_OFF                        0x00040000 // blocking if Ignition is off


#define DIAGLOG_BLOCKINGMODES_DEFAULT     (DIAGLOG_BLOCKING_MODE_STARTUP_TIMER | DIAGLOG_BLOCKING_MODE_POWER_NONE)


/************************************************/
/***              variant coding              ***/
/************************************************/
#define DIAGLOG_VARIANT_BASE           0x01
#define DIAGLOG_VARIANT_CONNECTIVITY   0x02
#define DIAGLOG_VARIANT_COLOR          0x04
#define DIAGLOG_VARIANT_NAVIGATION     0x08


#endif // VD_DIAGLOG_INCLUDEGUARD_vd_diaglog_configuration
