//////////////////////////////////////////////////////////////////////////
// FILE:         vd_diaglog_snapshotDataPrj.cpp
// PROJECT:      common
// SW-COMPONENT: DiagLog
//----------------------------------------------------------------------
//
// DESCRIPTION: DiagLog SnapshotData
//              
//----------------------------------------------------------------------
// COPYRIGHT:    (c) 2015 Robert Bosch GmbH, Hildesheim
// HISTORY:      
// Date      | Author                       | Modification
// 23.04.15  | BSOT Plischke                | Initial version
//////////////////////////////////////////////////////////////////////////
// first include diaglog settings
#include <common/framework/vd_diaglog_settings.h>


#ifndef VD_DIAGLOG_INCLUDEGUARD_vd_diaglog_snapshotDataPrj
   #include <project/framework/snapshotData/vd_diaglog_snapshotDataPrj.h>
#endif

#ifndef VD_DIAGLOG_INCLUDEGUARD_vd_diaglog_can_if
   #include <project/plugin/can_if/vd_diaglog_can_if.h>
#endif
#ifndef VD_DIAGLOG_INCLUDEGUARD_vd_diaglog_main
   #include <common/framework/vd_diaglog_main.h>
#endif
#ifndef VD_DIAGLOG_INCLUDEGUARD_vd_diaglog_memory_master
   #include <common/framework/vd_diaglog_memory_master.h>
#endif
#ifndef VD_DIAGLOG_INCLUDEGUARD_vd_diaglog_report_record
   #include <common/framework/vd_diaglog_report_record.h>
#endif
using namespace bpstl;
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_DIAGLOG_INFO
#include "trcGenProj/Header/vd_diaglog_snapshotDataPrj.cpp.trc.h"
#endif
bool vdl_tclSnapshotDataPrj::requestSnapShotDataBySnapshotRecord(vdl_tclSnapshotRecord snapshotRecord)
{
   ETG_TRACE_USR3_THR(( "--> vdl_tclSnapshotDataPrj::requestSnapShotDataBySnapshotRecord"));  
   bool bReturn = false;
   tU16 DID = snapshotRecord.m_DID;
   tU32 handle = snapshotRecord.m_Handle;
   ETG_TRACE_USR1_THR(( "--- vdl_tclSnapshotDataPrj::requestSnapShotDataBySnapshotRecord => DID:%04x handle:%08x",DID,handle));  
   switch(DID)
   {
      case 0xF0D0: // mileage
      {
         tU32 mileage = 0;
         if(vdDiagLog_tclApp::m_poInstance != NULL)
         {
            if(vdDiagLog_tclApp::m_poInstance->m_poCanIF != NULL)
            {
               mileage = vdDiagLog_tclApp::m_poInstance->m_poCanIF->getMileage();
            }// if(vdDiagLog_tclApp::m_poInstance->m_poCanIF != NULL)
            else
            {
               NORMAL_M_ASSERT_ALWAYS();
            }// else // if(vdDiagLog_tclApp::m_poInstance->m_poCanIF != NULL)
         }// if(vdDiagLog_tclApp::m_poInstance != NULL)
         else
         {
            NORMAL_M_ASSERT_ALWAYS();
         }// else // if(vdDiagLog_tclApp::m_poInstance != NULL)
         ETG_TRACE_USR1_THR(( "--- vdl_tclSnapshotDataPrj::requestSnapShotDataBySnapshotRecord => mileage:%d km",mileage));  
         vector<tU8> data;
         data.push_back((mileage>>16)&0xFF);
         data.push_back((mileage>>8 )&0xFF);
         data.push_back((mileage    )&0xFF);
         copyDataToSnapShot(handle,data);
         break;
      }
      case 0xF0D1: // occurence counter
      {
         tU32  DTC      = snapshotRecord.m_DTC;
         tU8   memoryId = snapshotRecord.m_memoryID;
         tU8 occurenceCounter = 0;
         if(vdDiagLog_tclApp::m_poInstance != NULL)
         {
            const vdl_tclReportRecord* const pRecord = (vdDiagLog_tclApp::m_poInstance)->m_oMemoryMaster.getMostRecentReportRecordByDTC(memoryId,DTC);
            if(pRecord != NULL)
            {
               occurenceCounter = pRecord->u8GetFailOccurenceCounter();
            }
            else
            {
               ETG_TRACE_ERR_THR(( "!!! vdl_tclSnapshotDataPrj::requestSnapShotDataBySnapshotRecord => pRecord == NULL"));  
            }
         }
         ETG_TRACE_USR1_THR(( "--- vdl_tclSnapshotDataPrj::requestSnapShotDataBySnapshotRecord => occurence counter:%d",occurenceCounter));  
         vector<tU8> data;
         data.push_back(occurenceCounter);
         copyDataToSnapShot(handle,data);
         break;
      }
      default:
      {
         break;
      }
   }// switch(DID)
   ETG_TRACE_USR3_THR(( "<-- vdl_tclSnapshotDataPrj::requestSnapShotDataBySnapshotRecord"));  
   return bReturn;
}
