/*!
 * \file       vd_diaglog_dtcConfig_defs.h
 *
 * \brief      DTC Configuration Definitions, Typedefs; these defines could be config dpendend
 *
 * \details    ...
 *
 * \component  Diaglog
 *
 * \ingroup    DTC Enable/Disable Configuration
 *
 * \author     Arjun Manjunath Sanu (RBEI/ECA2)
 *
 * \date       26.05.2020
 *
 * \copyright  (c) 2020 Robert Bosch Engineering & Business Solutions Ltd.
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */
 
#ifndef __INCLUDED_VD_DIAGLOG_DTC_CONFIGURATION_DEFS__
#define __INCLUDED_VD_DIAGLOG_DTC_CONFIGURATION_DEFS__

#ifndef VD_DIAGLOG_INCLUDEGUARD_vd_diaglog_typedefs_basic
#include <common/framework/vd_diaglog_typedefs_basic.h>
#endif

#ifndef VD_DIAGLOG_INCLUDEGUARD_vd_diaglog_configuration
#include <project/framework/vd_diaglog_configuration.h>
#endif

#define DTC_CMC_VCAN_TIME_OUT										((tU32)0x7F0209)
#define DTC_CMC_VCAN_NO_COMMUNICATION								((tU32)0x7F0213)
#define DTC_CMC_MCAN_TIME_OUT										((tU32)0x710209)
#define DTC_CMC_MCAN_NO_COMMUNICATION								((tU32)0x710213)
#define DTC_CMC_ETHERNET_NO_COMMUNICATION							((tU32)0x7C2013)
#define DTC_CMC_HIGH_VOLTAGE_ERROR									((tU32)0xA80003)
#define DTC_CMC_LOW_VOLTAGE_ERROR									((tU32)0xA80004)
#define DTC_CMC_DISPLAY_OVER_TEMPERATURE							((tU32)0xFFDFEF)
#define DTC_CMC_AMPLIFIER_OVER_TEMPERATURE							((tU32)0x00E0EF)
#define DTC_CMC_MAIN_PROCESSOR_OVER_TEMPERATURE						((tU32)0x02E0EF)
#define DTC_CMC_CO_PROCESSOR_OVER_TEMPERATURE						((tU32)0x03E0EF)
#define DTC_CMC_TUNER_AMFM_INTITIALIZATION_ERROR					((tU32)0x01E0EC)
#define DTC_CMC_TUNER_DAB_INITIALIZATION_ERROR						((tU32)0x04E0EC)
#define DTC_CMC_TUNER_SXM_INITIALIZATION_ERROR						((tU32)0x07E0EC)
#define DTC_CMC_TUNER_HD_RADIO_INITIALIZATION_ERROR					((tU32)0x08E0EC)
#define DTC_CMC_AMPLIFIER_INITIALIZATION_ERROR						((tU32)0x06E0EC)
#define DTC_CMC_BLUETOOTH_INITIALIZATION_ERROR						((tU32)0x05E0EC)
#define DTC_CMC_EXT_MIC_SIG_LINE1_SHORT_TO_BATTERY					((tU32)0x0EE0E3)
#define DTC_CMC_EXT_MIC_SIG_LINE1_OPEN_LOAD_SHORT_TO_GND			((tU32)0x0EE0E6)
#define DTC_CMC_EXT_MIC_SIG_LINE2_SHORT_TO_BATTERY					((tU32)0x0FE0E3)
#define DTC_CMC_EXT_MIC_SIG_LINE2_OPEN_LOAD_SHORT_TO_GND			((tU32)0x0FE0E6)
#define DTC_CMC_FRONT_RT_SPKR_OUTPUT_SHORT_TO_BAT					((tU32)0x13E0E3)
#define DTC_CMC_FRONT_RT_SPKR_OUTPUT_SHORT_LINES					((tU32)0x13E0E4)
#define DTC_CMC_FRONT_RT_SPKR_OUTPUT_OPEN_LOAD						((tU32)0x13E0E5)
#define DTC_CMC_FRONT_RT_SPKR_OUTPUT_SHORT_TO_GND					((tU32)0x13E0E6)
#define DTC_CMC_FRONT_LT_SPKR_OUTPUT_SHORT_TO_BAT					((tU32)0x14E0E3)
#define DTC_CMC_FRONT_LT_SPKR_OUTPUT_SHORT_LINES					((tU32)0x14E0E4)
#define DTC_CMC_FRONT_LT_SPKR_OUTPUT_OPEN_LOAD						((tU32)0x14E0E5)
#define DTC_CMC_FRONT_LT_SPKR_OUTPUT_SHORT_TO_GND					((tU32)0x14E0E6)
#define DTC_CMC_CABIN_OUTPUT_SHORT_TO_BAT							((tU32)0x15E0E3)
#define DTC_CMC_CABIN_OUTPUT_SHORT_LINES							((tU32)0x15E0E4)
#define DTC_CMC_CABIN_OUTPUT_OPEN_LOAD								((tU32)0x15E0E5)
#define DTC_CMC_CABIN_OUTPUT_SHORT_TO_GND							((tU32)0x15E0E6)
#define DTC_CMC_PRIVATE_SPKR_OUTPUT_SHORT_TO_BAT					((tU32)0x16E0E3)
#define DTC_CMC_PRIVATE_SPKR_OUTPUT_SHORT_LINES						((tU32)0x16E0E4)
#define DTC_CMC_PRIVATE_SPKR_OUTPUT_OPEN_LOAD						((tU32)0x16E0E5)
#define DTC_CMC_PRIVATE_SPKR_OUTPUT_SHORT_TO_GND					((tU32)0x16E0E6)
#define DTC_CMC_SWITCHABLE_OUTPUT_VOLTAGE_SW_12V_SHORT_TO_BAT		((tU32)0x12E0E3)
#define DTC_CMC_SWITCHABLE_OUTPUT_VOLTAGE_SW_12V_SHORT_TO_GND		((tU32)0x13E0E6)
#define DTC_CMC_ELECTRICAL_USB_CM_HUB_GENERAL_FAILURE				((tU32)0x10E0EC)
#define DTC_CMC_ECU_FAN_ELECTRONIC_ERROR							((tU32)0x11E0EC)
#define DTC_CMC_HOME_BUTTON_KEY_JAM									((tU32)0x17E0E2)
#define DTC_CMC_HOME_BUTTON_AMBER_LED_ILLUMINATION_ERROR			((tU32)0x26E0E2)

#define DTC_CFG_DATAPOOL_DATA_LENGTH								((tU8)230)

#endif // __INCLUDED_VD_DIAGLOG_DTC_CONFIGURATION_DEFS__
