//////////////////////////////////////////////////////////////////////////
// FILE:         vd_asf_VehicleClientHandler.cpp
// PROJECT:      GEN3
// SW-COMPONENT: DiagLog
//----------------------------------------------------------------------
//
// DESCRIPTION: DiagLog vd_asf_VehicleClientHandler creator class
//
//----------------------------------------------------------------------
// COPYRIGHT:    (c) 2021 Robert Bosch GmbH, Hildesheim
// HISTORY:
// Date      | Author                       | Modification
// 14.03.22  | nik6kor						| Send the CAN signal to Vehicle data
//////////////////////////////////////////////////////////////////////////


// first include diaglog settings
#include <common/framework/vd_diaglog_settings.h>

#ifndef VD_DIAGLOG_INCLUDEGUARD_vd_asf_vehicleClient
    #include "project/framework/asf/vd_asf_VehicleClient.h"
#endif

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_DIAGLOG_INFO
#include "trcGenProj/Header/vd_asf_VehicleClientHandler.cpp.trc.h"
#endif


// first include diaglog settings
#include <common/framework/vd_diaglog_settings.h>

using namespace ::vehicle_main_fi_types;
using namespace ::VEHICLE_MAIN_FI;

#define CAN_CSM_DISTANCE_TOTALIZER_SIGNAL_RESOLUTION (0.125)



#define VEHICLEMAINFIPORT "vehicleMainFiPort"

vd_asf_VehicleClientHandler* vd_asf_VehicleClientHandler::m_povd_asf_VehicleClientHandler = NULL;
/******************************************************************************
*NAME        : vd_asf_VehicleClientHandler
*SYSFL       : NA
*Description : Constructor class for vd_asf_VehicleClientHandler
******************************************************************************/
vd_asf_VehicleClientHandler::vd_asf_VehicleClientHandler() //: m_vehicleProxy(::VEHICLE_MAIN_FIProxy::createProxy("vehicleMainFiPort", *this))
: m_OdometerValue(NULL)
, m_VinValue (NULL)
{

	ETG_TRACE_COMP_THR(("<-- vd_asf_VehicleClientHandler::vd_asf_VehicleClientHandler"));
	m_vehicleProxy = ::VEHICLE_MAIN_FIProxy::createProxy("vehicleMainFiPort", *this);
}


/******************************************************************************
*NAME        : ~vd_asf_VehicleClientHandler
*SYSFL       : NA
*Description : Desctructor Class for vd_asf_VehicleClientHandler
******************************************************************************/
vd_asf_VehicleClientHandler::~vd_asf_VehicleClientHandler()
{
   ETG_TRACE_COMP_THR(("vd_asf_VehicleClientHandler::~vd_asf_VehicleClientHandler"));
   if (m_povd_asf_VehicleClientHandler != NULL)
   {
      delete m_povd_asf_VehicleClientHandler;
      m_povd_asf_VehicleClientHandler = NULL;
   }

}


/******************************************************************************
*NAME        : onAvailable
*SYSFL       : NA
******************************************************************************/
void vd_asf_VehicleClientHandler::onAvailable(const ::boost::shared_ptr< ::asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& stateChange)
{
	ETG_TRACE_COMP_THR(("vd_asf_VehicleClientHandler::onAvailable()"));

   if (m_vehicleProxy)
   {
      ETG_TRACE_USR4(("VehicleClientHandler::registerProperties(): valid proxy"));
      m_vehicleProxy->sendTotalVehDistDiagUpReg(*this);
      m_vehicleProxy->sendVIN_64UpReg(*this);
   }
}


/******************************************************************************
*NAME        : onUnavailable
*SYSFL       : NA
******************************************************************************/
void vd_asf_VehicleClientHandler::onUnavailable(const ::boost::shared_ptr< ::asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& stateChange)
{
	ETG_TRACE_COMP_THR(("vd_asf_VehicleClientHandler::onUnavailable()"));
   if (m_vehicleProxy)
   {
      m_vehicleProxy->sendTotalVehDistDiagRelUpRegAll ();
      m_vehicleProxy->sendVIN_64RelUpRegAll ();

   }
}


/******************************************************************************
*NAME        : registerProperties
*SYSFL       : NA
******************************************************************************/
void vd_asf_VehicleClientHandler::registerProperties(const ::boost::shared_ptr< ::asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& /*stateChange*/)
{

}


/******************************************************************************
*NAME        : deregisterProperties
*SYSFL       : NA
******************************************************************************/
void vd_asf_VehicleClientHandler::deregisterProperties(const ::boost::shared_ptr< ::asf::core::Proxy >& proxy, const ::asf::core::ServiceStateChange& /*stateChange*/)
{

}

bool vd_asf_VehicleClientHandler::vSendDM1DataMessage(tU8* dm1Frame)
{
    tU64 dm1value = 0;
	ETG_TRACE_USR1_THR(("<-- vd_asf_VehicleClientHandler::vSendDM1DataMessage"));
   //vsendDM1DataMessage_Rq(value);
	tU64 dm1SendData =9;
	tU8 byteposition=0;
	tU8 dm2buffer[8] = {0};
	tU8 dmindex=0;
	while( byteposition < 8)
	{
	   ETG_TRACE_COMP_THR(("DM[%d]= %x",byteposition,dm1Frame[byteposition]));//just to check DM1 message content
	   byteposition++;
	   //dm1frame++;
	}
	dm1SendData = dm1Frame[7];
	dm1SendData <<= 8;
	dm1SendData |= dm1Frame[6];
	dm1SendData <<= 8;
	dm1SendData |= dm1Frame[5];
	dm1SendData <<= 8;
	dm1SendData |= dm1Frame[4];
	dm1SendData <<= 8;
	dm1SendData |= dm1Frame[3];
	dm1SendData <<= 8;
	dm1SendData |= dm1Frame[2];
	dm1SendData <<= 8;
	dm1SendData |= dm1Frame[1];
	dm1SendData <<= 8;
	dm1SendData |= dm1Frame[0];
    ETG_TRACE_COMP_THR(("vd_asf_VehicleClientHandler::vSendDM1DataMessage, DM1 data: %x",dm1SendData));


	if (m_vehicleProxy != NULL)
	   {
	      m_vehicleProxy->sendHUS_DM1_StatusStart(*this, dm1SendData);
	   }
	   else
	   {
	      ETG_TRACE_USR4(("VehicleClientHandler:: NULL POINTER"));
	   }

   return true;
}


///////////////////////////////////////////////////////////////////////////////////
//
// FUNCTION: vd_asf_VehicleClientHandler::onHUS_DM1_StatusError()
//
// DESCRIPTION: DM1 interfacce error method
//
// PARAMETER:  none
//
// RETURNVALUE: none
//
///////////////////////////////////////////////////////////////////////////////////
void vd_asf_VehicleClientHandler::onHUS_DM1_StatusError(const ::boost::shared_ptr< VEHICLE_MAIN_FIProxy >& /*proxy*/, const ::boost::shared_ptr< HUS_DM1_StatusError >& /*error*/)
{
   ETG_TRACE_COMP_THR(("VehicleClientHandler:: onHUS_DM1_StatusError"));
}

///////////////////////////////////////////////////////////////////////////////////
//
// FUNCTION: vd_asf_VehicleClientHandler::onHUS_DM1_StatusResult()
//
// DESCRIPTION: DM1 message result method
//
// PARAMETER:  none
//
// RETURNVALUE: none
//
///////////////////////////////////////////////////////////////////////////////////

void vd_asf_VehicleClientHandler::onHUS_DM1_StatusResult(const ::boost::shared_ptr< VEHICLE_MAIN_FIProxy >& /*proxy*/, const ::boost::shared_ptr< HUS_DM1_StatusResult >& /*error*/)
{
	ETG_TRACE_COMP_THR(("VehicleClientHandler:: onHUS_DM1_StatusResult"));
}

///////////////////////////////////////////////////////////////////////////////////
//
// FUNCTION: vd_asf_VehicleClientHandler::onVIN_64Error()
//
// DESCRIPTION: VIN interface error method
//
// PARAMETER:  none
//
// RETURNVALUE: none
//
///////////////////////////////////////////////////////////////////////////////////

void vd_asf_VehicleClientHandler::onVIN_64Error(const ::boost::shared_ptr< VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< VIN_64Error >& error)
{
	ETG_TRACE_COMP_THR(("VehicleClientHandler:: onVIN_EvoError"));
}

///////////////////////////////////////////////////////////////////////////////////
//
// FUNCTION: vd_asf_VehicleClientHandler::onVIN_64Status()
//
// DESCRIPTION: VIN interface call back method
//
// PARAMETER:  none
//
// RETURNVALUE: none
//
///////////////////////////////////////////////////////////////////////////////////

void vd_asf_VehicleClientHandler::onVIN_64Status(const ::boost::shared_ptr< VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< VIN_64Status >& status)
{
	ETG_TRACE_COMP_THR(("VehicleClientHandler:: onVIN_EvoStatus"));
	m_VinValue = status->getVIN_64Value();
	ETG_TRACE_COMP_THR(("getVIN: vin: %d", m_VinValue));
}

///////////////////////////////////////////////////////////////////////////////////
//
// FUNCTION: vd_asf_VehicleClientHandler::onTotalVehDistDiagError()
//
// DESCRIPTION: odometer interface error callback method
//
// PARAMETER:  none
//
// RETURNVALUE: none
//
///////////////////////////////////////////////////////////////////////////////////

void vd_asf_VehicleClientHandler::onTotalVehDistDiagError(const ::boost::shared_ptr< VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< TotalVehDistDiagError >& error)
{
	ETG_TRACE_COMP_THR(("VehicleClientHandler:: onDistanceUnitError"));
}


///////////////////////////////////////////////////////////////////////////////////
//
// FUNCTION: vd_asf_VehicleClientHandler::onTotalVehDistDiagStatus()
//
// DESCRIPTION: odometer call back method
//
// PARAMETER:  none
//
// RETURNVALUE: none
//
///////////////////////////////////////////////////////////////////////////////////

void vd_asf_VehicleClientHandler::onTotalVehDistDiagStatus(const ::boost::shared_ptr< VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< TotalVehDistDiagStatus >& status)
{
	ETG_TRACE_COMP_THR(("VehicleClientHandler:: onDistanceUnitStatus"));

	m_OdometerValue = status->getTotalVehDistDiagValue();
	ETG_TRACE_COMP_THR(("getDistanceUnit: odometer: %d", m_OdometerValue));
}


///////////////////////////////////////////////////////////////////////////////////
//
// FUNCTION: vd_asf_VehicleClientHandler::fetchGetTotalVehDistanceValue()
//
// DESCRIPTION: Odometer fetch method from proxy
//
// PARAMETER:  none
//
// RETURNVALUE: success or failure
//
///////////////////////////////////////////////////////////////////////////////////

bool vd_asf_VehicleClientHandler::fetchGetTotalVehDistanceValue(uint64& value) const
{
   bool isFetched = false;
   if ((NULL != m_vehicleProxy.get()) && (m_vehicleProxy->hasVIN_64()))
   {
      value     = m_vehicleProxy->getVIN_64().getVIN_64Value();
      ETG_TRACE_COMP_THR(("getDistanceUnit: odometer: %d", value));
      isFetched = true;
   }
   return isFetched;
}


///////////////////////////////////////////////////////////////////////////////////
//
// FUNCTION: vd_asf_VehicleClientHandler::getVehicleOdometerValue()
//
// DESCRIPTION: return the current odometer
//
// PARAMETER:  none
//
// RETURNVALUE: odometer (km)
//
///////////////////////////////////////////////////////////////////////////////////
//
tU16 vd_asf_VehicleClientHandler::getVehicleOdometerValue()
{

	ETG_TRACE_COMP_THR(( "--> vd_asf_VehicleClientHandler::getVehicleOdometerValue => getOdometerValue"));

   tU16 u16RetVal=0;

   u16RetVal = tU16 ( (m_OdometerValue)*CAN_CSM_DISTANCE_TOTALIZER_SIGNAL_RESOLUTION );
	      ETG_TRACE_USR3_THR(("getVehicleOdometerValue: odometer: %d", m_OdometerValue));

   return u16RetVal;
}


