//////////////////////////////////////////////////////////////////////////
// FILE:         vd_asf_VehicleClient.cpp
// PROJECT:      GEN3
// SW-COMPONENT: DiagLog
//----------------------------------------------------------------------
//
// DESCRIPTION: DiagLog vd_asf_VehicleClient creator class
//
//----------------------------------------------------------------------
// COPYRIGHT:    (c) 2022 Robert Bosch GmbH, Hildesheim
// HISTORY:
// Date      | Author                       | Modification
// 14.03.22  | nik6kor						| Send the CAN signal to Vehicle data
//////////////////////////////////////////////////////////////////////////


// first include diaglog settings
#include <common/framework/vd_diaglog_settings.h>

#ifndef VD_DIAGLOG_INCLUDEGUARD_vd_asf_vehicleClient
    #include "project/framework/asf/vd_asf_VehicleClient.h"
#endif

#ifndef VD_DIAGLOG_INCLUDEGUARD_vd_asf_vehicleClienthandler
    #include "project/framework/asf/vd_asf_VehicleClientHandler.h"
#endif

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_DIAGLOG_INFO
#include "trcGenProj/Header/vd_asf_VehicleClient.cpp.trc.h"
#endif



// first include diaglog settings
#include <common/framework/vd_diaglog_settings.h>


namespace asf {


/******************************************************************************
*NAME        : vd_asf_VehicleClient
*SYSFL       : NA
*Description : Constructor class for vd_asf_VehicleClient
******************************************************************************/
vd_asf_VehicleClient::vd_asf_VehicleClient()
 : m_po_asf_VehicleClientHandler(NULL)
{

	ETG_TRACE_COMP_THR(("<-- vd_asf_VehicleClient::vd_asf_VehicleClient"));

	m_po_asf_VehicleClientHandler = vd_asf_VehicleClientHandler::getInstance();

}


/******************************************************************************
*NAME        : ~VehicleClientHandler
*SYSFL       : NA
*Description : Desctructor Class for VehicleClientHandler
******************************************************************************/
vd_asf_VehicleClient::~vd_asf_VehicleClient()
{
   ETG_TRACE_COMP_THR(("vd_asf_VehicleClient::~vd_asf_VehicleClient"));
   if (m_po_asf_VehicleClientHandler != NULL)
   {
      delete m_po_asf_VehicleClientHandler;
      m_po_asf_VehicleClientHandler = NULL;
   }
}

}//asf

