//////////////////////////////////////////////////////////////////////////
// FILE:         vd_diaglog_inc_comm.h
// PROJECT:      common
// SW-COMPONENT: DiagLog
//----------------------------------------------------------------------
//
// DESCRIPTION: DiagLog INC Interface
//              
//----------------------------------------------------------------------
// COPYRIGHT:    (c) 2013 Robert Bosch GmbH, Hildesheim
// HISTORY:      
// Date      | Author                       | Modification
// 24.10.13  | BSOT Plischke                | Initial version
//////////////////////////////////////////////////////////////////////////


#ifndef VD_DIAGLOG_INCLUDEGUARD_vd_diaglog_inc_comm
#define VD_DIAGLOG_INCLUDEGUARD_vd_diaglog_inc_comm


#ifdef USE_DGRAM_SERVICE
#include "dgram_service.h"
#endif

class vdDiagLog_tclApp;  //lint !e763

typedef struct
{
   tU32 DemEventId;
   tU32 ItcId;
}trEventItcMap;


class vdl_tclIncCommunication
{
private:
   vdl_tclIncCommunication ( void ); //lint !e1704
public:
   // operation

    // constructor
    vdl_tclIncCommunication ( vdDiagLog_tclApp* poMain );
    virtual ~vdl_tclIncCommunication ( tVoid );

    //! create the SOCKET
    bool create ( tVoid );
    //! close the SOCKET
    bool close ( tVoid );
    //! connect to the driver
    bool connect ( tVoid );
    //! disconnect from the driver
    bool disconnect ( tVoid ) const;

    tVoid SendCompStatus( tVoid ) const;

    static tVoid ThreadFunction(tPVoid);
    static tVoid SendIncResponse (tU8 ResponseId);

    void SendClearRequest () const;
    void SendItcReport ( const tU8 au8MsgBuffer[], tU16 u16Length) const;

   // attributes
    static vdl_tclIncCommunication* mpInstance;
    OSAL_tThreadID m_oThread;
    static int m_nSocketFd;

    bool isCreated(void) const { return ((m_nSocketFd <= 0) ? false:true); }
#ifdef USE_DGRAM_SERVICE
    static sk_dgram *dgram;
#endif
    static unsigned char m_au8RecvBuffer[];
    static unsigned char m_au8SendBuffer[];

private:
   // operation
   static void OnTestResult (tU16 SizeOfData, tU8  u8NumberOfDTCs, const tU8* pData );
   void SendResponse (tU8 ResponseId);

   static tU32 u32ConvertDemEventToItc(tU32 DemEventId);
   static tU32 u32ConvertItcToDemEvent(tU32 ItcId);
   static int iEventToItcMapSize();

   // attributes

   static vdDiagLog_tclApp*          m_poGWMain;
   static const trEventItcMap rEventToItcMap[];




};

#endif /* VD_DIAGLOG_INCLUDEGUARD_vd_diaglog_inc_comm */
