//////////////////////////////////////////////////////////////////////////
// FILE:         vd_diaglog_typedefs_basic.h
// PROJECT:      common
// SW-COMPONENT: DiagLog
//----------------------------------------------------------------------
//
// DESCRIPTION: DiagLog Typdef Definitions, which are config indpendent 
// and could be used by config
//              
//----------------------------------------------------------------------
// COPYRIGHT:    (c) 2012 Robert Bosch GmbH, Hildesheim
// HISTORY:      
// Date      | Author                       | Modification
// 08.08.12  | BSOT Plischke               | Initial version
//
//////////////////////////////////////////////////////////////////////////
#ifndef VD_DIAGLOG_INCLUDEGUARD_vd_diaglog_typedefs_basic
#define VD_DIAGLOG_INCLUDEGUARD_vd_diaglog_typedefs_basic


#define SYSTEM_S_IMPORT_INTERFACE_VECTOR
#define SYSTEM_S_IMPORT_INTERFACE_MAP
#define SYSTEM_S_IMPORT_INTERFACE_LIST
#define SYSTEM_S_IMPORT_INTERFACE_SET
#define SYSTEM_S_IMPORT_INTERFACE_ALGORITHM
#define SYSTEM_S_IMPORT_INTERFACE_FUNCTIONAL
#define SYSTEM_S_IMPORT_INTERFACE_UTILITY
#include "stl_pif.h"



#ifndef VD_DIAGLOG_INCLUDEGUARD_vd_diaglog_typedefs_prj
   #include <project/framework/vd_diaglog_typedefs_prj.h>  
#endif


// ##### DEFINES ######

// Define for intentionally unused parameters
#define DIA_PARAMETER_INTENTIONALLY_UNUSED(x) (void)(x)

//Defines for TestFrequency
#define DIAGLOG_TEST_FREQ_CONTINUOUSLY       0x01
#define DIAGLOG_TEST_FREQ_AT_STARTUP         0x02
#define DIAGLOG_TEST_FREQ_AFTER_DOWNLOAD     0x04
#define DIAGLOG_TEST_FREQ_AFTER_CPID_FE      0x08
#define DIAGLOG_TEST_FREQ_AFTER_DTC_CLEARING 0x10

// defines for retigger Messages
#define DIAGLOG_RETRIGGER_ID_CCA       0x01000000  
#define DIAGLOG_RETRIGGER_ID_V850      0x02000000  
#define DIAGLOG_RETRIGGER_ID_PLUGIN    0x04000000  
#define DIAGLOG_RETRIGGER_ALWAYS       0xFF000000


#define DIAGLOG_CLEAR_ALL_DTC                0xFFFFFF

// fix Blocking Mode defines
#define DIAGLOG_BLOCKING_MODE_NONE         0x00000000 // not Blocked
#define DIAGLOG_BLOCKING_MODE_DIAGNOSIS    0x00000001 // Blocking if DiagControl is switched to OFF
#define DIAGLOG_BLOCKING_MODE_DTC_LIST     0x80000000 // Block by other DTC, not allowed to set this one in config also the other Flags a re in this case not valid, it also returns the DTC in the lowest 3 Bytes


// ##### TYPES ######

// internal Status structure
typedef union
{
   struct
   {
      tU32 m_bIsFailedInPreviousIgnCycle:1;     // 00000001 status FLAG - Failed in previous cycle
      tU32 m_bIsPassedInCurrentIgnCycle:1;      // 00000002 status FLAG - Passed in current cycle
      tU32 m_bIsFailedInCurrentIgnCycle:1;      // 00000004 status FLAG - Failed in current cycle
      tU32 m_bIsActive:1;                       // 00000008 status FLAG - DTC currently failed
      tU32 m_bIsHistory:1;                      // 00000010 status FLAG - DTC verfied/confirmed
      tU32 m_bIsCalibrationDTCEnabled:1;        // 00000020 status FLAG - is logging enabled via EOL?
      tU32 m_bIsFailedSinceDTCCleared:1;        // 00000040 status FLAG - Failed once since last clear command
      tU32 m_bIsNotPassedSinceDTCCleared:1;     // 00000080 status FLAG - not passed since last clear command
      tU32 m_bIsPassedSinceCurrentPowerUp:1;    // 00000100 status FLAG - Passed once this Powercycle
      tU32 m_bIsNotPassedSinceCurrentPowerUp:1; // 00000200 status FLAG - no Passed received this Powercycle
      tU32 m_bIsFailedInCurrentPowerCycle:1;    // 00000400 status FLAG - Failed once this Powercycle
      tU32 m_bIsNotCompleteThisOperationCycle:1;// 00000800 status FLAG - no Passed or Failed this Operation Cycle
      tU32 m_bIsNotCompleteSinceLastClear:1;    // 00001000 status FLAG - no Passed or Failed since last clear command
      tU32 m_bIsPassedSinceDTCCleared:1;        // 00002000 status FLAG - Passed once since last clear command
      tU32 m_bIsDTCControlEnabled:1;            // 00004000 status FLAG - is logging enabled via Control? // NOT USED
      tU32 m_bIsDTCReadByCalibrationEnabled:1;  // 00008000 status FLAG - is read enable by calibration, this one will be fully unsed, but not read out
   }sStatus;
   tU32 u32Status;
}tuRecordStatus;

// command options
enum vdl_teDiaglogOptions
{
   OPTION_NONE          = 0,
   OPTION_DTC_EQUAL     = 1,
   OPTION_ITC_EQUAL     = 2
};

// vdl_teDiaglogReportMsg: trigger by FI
enum vdl_teDiaglogReportMsg
{
   DIAGLOG_REPORT_PASSED = 0,             // test of DTC passed
   DIAGLOG_REPORT_FAILED = 1,             // test of DTC failed
   DIAGLOG_REPORT_NORESULT = 2,           // test condtion of DCT not fullfilled
   DIAGLOG_REPORT_DISABLE = 3,            // persist disabling of one special DTC
   DIAGLOG_REPORT_ENABLE = 4,             // persist enabling of one special DTC
   DIAGLOG_REPORT_NONE = 0xff             // default, witout any change
};

// vdl_teDiaglogControlMsg: trigger by fi
enum vdl_teDiaglogControlMsg
{
   DIAGLOG_CONTROL_CALIB_DISABLE = 0,                    // change Record => m_bIsCalibrationDTCEnabled
   DIAGLOG_CONTROL_CALIB_ENABLE = 1,                     // change Record => m_bIsCalibrationDTCEnabled
   DIAGLOG_CONTROL_CTRL_LOGGING_TEMP_DISABLE = 2,        // change Blockingmode => DIAGLOG_BLOCKING_MODE_DIAGNOSIS
   DIAGLOG_CONTROL_CTRL_LOGGING_TEMP_ENABLE = 3,         // change Blockingmode => DIAGLOG_BLOCKING_MODE_DIAGNOSIS
   DIAGLOG_CONTROL_CTRL_LOGGING_PERSIST_DISABLE = 4,     // change Record => m_bIsDTCControlEnabled
   DIAGLOG_CONTROL_CTRL_LOGGING_PERSIST_ENABLE = 5,      // change Record => m_bIsDTCControlEnabled
   DIAGLOG_CONTROL_READ_DISABLE_BLOCKING_DISABLE = 6,    // Ignore the setting done by calibration (m_bIsDTCReadByCalibrationEnabled): change global var => m_bIgnoreCalibration
   DIAGLOG_CONTROL_READ_DISABLE_BLOCKING_ENABLE = 7,     // Reset the setting done by calibration  (m_bIsDTCReadByCalibrationEnabled): change global var => m_bIgnoreCalibration
   DIAGLOG_CONTROL_READ_DISABLE = 8,                     // DTC will be handeled, but forbidden to read out (m_bIsDTCReadByCalibrationEnabled = false)
   DIAGLOG_CONTROL_READ_ENABLE = 9,                      // DTC will be handeled, and allowed to read out (m_bIsDTCReadByCalibrationEnabled = true)
   DIAGLOG_CONTROL_UNUSED = 0xff                         // default, witout any change

};

enum vdl_teDiaglogEventStep
{
   EVENT_ON_INIT,                      // 00
   EVENT_OPERATION_CYCLE_START,        // 01
   EVENT_OPERATION_CYCLE_END,          // 02
   EVENT_IGNITION_CYCLE_START,         // 03
   EVENT_IGNITION_CYCLE_END,           // 04
   EVENT_CLEAR,                        // 05
   EVENT_SET_TO_DEFAULT,               // 06
   EVENT_FAIL_QUALIFIED,               // 07
   EVENT_PASS_QUALIFIED,               // 08
   EVENT_AGEING_COMPLETED,             // 09
   EVENT_BLOCKING_MODE_UPDATE,         // 10
   EVENT_CLEAR_BY_MASK                 // 11
};


enum vdl_teDiaglogReportProtocol
{
   DIAGLOG_REPORT_UDS,
   DIAGLOG_REPORT_GMLAN
};

enum vdl_teDiaglogAgeingAlgorithm
{
   DIAGLOG_AGEING_ALGORITHM_NONE,                     // no ageing defined
   DIAGLOG_AGEING_ALGORITHM_SINGLE,                   // each DTC will be relearned after DTC PASSED // <<<UDS STANDARD>>>
   DIAGLOG_AGEING_ALGORITHM_GLOBAL                    // onyl if all DTC are passed, relearn will start
};

enum vdl_teDiaglogAgeingCycle
{
   DIAGLOG_AGEING_CYCLE_UNUSED,                       // no ageing defined
   DIAGLOG_AGEING_CYCLE_ON_IGNITION_CYCLE_START,      
   DIAGLOG_AGEING_CYCLE_ON_IGNITION_CYCLE_END,
   DIAGLOG_AGEING_CYCLE_ON_OPERATION_CYCLE_START,
   DIAGLOG_AGEING_CYCLE_ON_OPERATION_CYCLE_END,
   DIAGLOG_AGEING_CYCLE_ON_ACC_CYCLE_START,
   DIAGLOG_AGEING_CYCLE_ON_ACC_CYCLE_END,
   DIAGLOG_AGEING_CYCLE_ON_EXTERNAL_EVENT             // on external event counter 
};

enum vdl_teDiaglogAgeingBlockMode
{
   DIAGLOG_AGEING_BLOCKING_NONE,                      // ageing always allowed
   DIAGLOG_AGEING_BLOCKING_BY_BLOCKINGMODE_DIAG       // ageing blocked if control DTC=OFF
};

enum vdl_teDiaglogOccurenceCounterAlgorithm
{
   DIAGLOG_OCCURENCE_COUNTER_ON_EACH_FAILED,                                     // counting on each change from PASSED->FAILED
   DIAGLOG_OCCURENCE_COUNTER_ON_EACH_FAILED_ONCE_A_OPERATION_CYCLE,              // counting on each change from PASSED->FAILED, but only once an Operation cycle // <<<UDS STANDARD>>>
   DIAGLOG_OCCURENCE_COUNTER_ON_EACH_CONFIRMED_FAILED,                           // counting on each change from PASSED->FAILED (Qualified)
   DIAGLOG_OCCURENCE_COUNTER_ON_EACH_CONFIRMED_FAILED_ONCE_A_OPERATION_CYCLE     // counting on each change from PASSED->FAILED (Qualified), but only once an Operation cycle
};


// command options
enum vdl_teDiaglogSystemEvent
{
   DIAGLOG_EVENT_IGNITION_CYCLE_START = 0,
   DIAGLOG_EVENT_IGNITION_CYCLE_END,
   DIAGLOG_EVENT_OPERATION_CYCLE_START,
   DIAGLOG_EVENT_OPERATION_CYCLE_END,
   DIAGLOG_EVENT_ACC_CYCLE_START,
   DIAGLOG_EVENT_ACC_CYCLE_END,
   DIAGLOG_EVENT_CRANK_CYCLE_START,
   DIAGLOG_EVENT_CRANK_CYCLE_END
};


#define DIAGLOG_FREEZE_FRAME_DATA_TYPE_SNAPSHOTDATA 0x01000000
#define DIAGLOG_FREEZE_FRAME_DATA_TYPE_EXTENDEDDATA 0x02000000
#define DIAGLOG_FREEZE_FRAME_DATA_TYPE_DID_MASK     0x0000FFFF
#define DIAGLOG_FREEZE_FRAME_DATA_TYPE_MASK         0xFF000000

enum vdl_teDiaglogSnapShotTrigger
{
   DIAGLOG_SSD_TRIGGER_BY_FAIL = 0,
   DIAGLOG_SSD_TRIGGER_BY_READ,
};

typedef union
{
   struct
   {
      tU8 m_bDTCSupportedByCalibration:1;       // TRUE if "DTC supported by claibration"
      tU8 m_bCurrentDTC:1;                      // TRUE if "DTC is current
      tU8 m_bTestNotPassedSinceDTCCleared:1;    // TRUE if "Test not passed since DTC cleared"
      tU8 m_bTestFailedSinceDTCCleared:1;       // TRUE if "test failed since DTC have been cleared"
      tU8 m_bHistoryDTC:1;                      // TRUE if "DTC is history"
      tU8 m_bTestNotPassedSinceCurrentPowerUp:1;// TRUE if "Test not pass since Power Up"
      tU8 m_bCurrentDTCSincePowerUp:1;          // TRUE if "DTC becomes current this Power Cycle"
      tU8 m_bWarningIndicatorRequested:1;       // TRUE if "Warning indicator requested to be ON"
   }sStatus;
   tU8 u8Status;
}tuGMLanStatus;

typedef union
{
   struct
   {
      tU8 m_bTestFailed:1;                      // TRUE if "DTC is current"
      tU8 m_bTestFailedThisOperationCycle:1;    // TRUE if "DTC is/was current in this operationcycle"
      tU8 m_bPendingDTC:1;                      // same as m_bConfirmedDTC
      tU8 m_bConfirmedDTC:1;                    // TRUE if "DTC is history"
      tU8 m_bTestNotCompleteSinceLastClear:1;   // TRUE if "Test not passed/failed since DTC cleared"
      tU8 m_bTestFailedSinceLastClear:1;        // TRUE if "test failed since DTC have been cleared"
      tU8 m_bNotCompletedThisCycle:1;           // TRUE if "Test not passed/failed since Power Up"
      tU8 m_bWarningIndicator:1;                //
   }sStatus;
   tU8 u8Status;
}tuUDSStatus;


typedef std::vector<tU8>        tExtData;

struct vdl_tsDiaglogExtData
{
   tU8      u8ExtId;
   tExtData oData;
};

typedef std::vector<vdl_tsDiaglogExtData>   tExtDataArray;

// data structure for report record config
struct vdl_tsDiaglogReadReport
{
   tU32 u32DTC;
   tU16 u16ITC;
   tU32 u32Status;
};

// data structure for plugin report record 
struct vdl_tsDiaglogPlugInReport
{
   tU32 u32DTC;
   tU16 u16ITC;
   tU32 u32Status;
   tU8  u8MemoryId;
   tU8  u8Severity;
   tU8  u8OccCnt;
};

struct vdl_tsSnapShotDataStruct
{
   tU8  RecordNumber;
   tU8  NumberOfDid;
   std::vector<tU8> data;
};

struct vdl_tsSnapShotIdStruct
{
   tU32 DTC;
   tU8  RecordNumber;
};

class vdl_tsDiaglogItcInformation
{
public:
   vdl_tsDiaglogItcInformation(tU16 itc):
      u32DTC(0),
      u16ITC(itc),
      u8Status(0),
      u32Status(0),
      u8AgeingCounter(0),
      u8OccurenceCounter(0)
   {};

   tU32 u32DTC;
   tU16 u16ITC;
   tU8  u8Status;
   tU32 u32Status;
   tU8  u8AgeingCounter;
   tU8  u8OccurenceCounter;
};

class vdl_tsDiaglogTestResult
{
public:
   vdl_tsDiaglogTestResult():
      u32ITC(0),
      u32DTC(0),
      eReportStatus(DIAGLOG_REPORT_NONE),
      bDynamicalDTC(0),
      u32Timestamp(0)
   {};


   tU32                    u32ITC;
   tU32                    u32DTC;
   vdl_teDiaglogReportMsg  eReportStatus;
   bool                    bDynamicalDTC;
   tU32                    u32Timestamp;
   tExtDataArray           oExtData;
};

typedef std::list<vdl_tsDiaglogReadReport>                        tReadReportListArray;
typedef std::list<vdl_tsDiaglogReadReport>::iterator              tReadReportListArrayIt;
typedef std::list<vdl_tsDiaglogReadReport>::const_iterator        tReadReportListArrayCIt;

typedef std::vector<tS8>                      tStream;
typedef std::vector<tS8>::const_iterator      tStreamCIterator;

class vdl_tclReportRecord; // forward declaration for next typedef
typedef std::vector<vdl_tclReportRecord*>                        tReportArray;
typedef std::vector<vdl_tclReportRecord*>::iterator              tReportArrayIt;
typedef std::vector<vdl_tclReportRecord*>::const_iterator        tReportArrayCIt;

class vdl_tclReportMemory; // forward declaration for next typedef
typedef std::vector<vdl_tclReportMemory*>                        tMemoryArray;
typedef std::vector<vdl_tclReportMemory*>::iterator              tMemoryArrayIt;
typedef std::vector<vdl_tclReportMemory*>::const_iterator        tMemoryArrayCIt;

typedef std::list<tU32>                        tDTCListArray;
typedef std::list<tU32>::iterator              tDTCListArrayIt;
typedef std::list<tU32>::const_iterator        tDTCListArrayCIt;

typedef std::vector<tU16>                        tITCVector;
typedef std::vector<tU16>::iterator              tITCVectorIt;
typedef std::vector<tU16>::const_iterator        tITCVectorCIt;

typedef std::vector<tU32>                        tDTCVector;
typedef std::vector<tU32>::iterator              tDTCVectorIt;
typedef std::vector<tU32>::const_iterator        tDTCVectorCIt;

typedef std::list<vdl_tsSnapShotDataStruct>                        tSnapShotDataList;
typedef std::list<vdl_tsSnapShotDataStruct>::iterator              tSnapShotDataListIt;
typedef std::list<vdl_tsSnapShotDataStruct>::const_iterator        tSnapShotDataListCIt;

typedef std::list<vdl_tsSnapShotIdStruct>                        tSnapShotIdList;
typedef std::list<vdl_tsSnapShotIdStruct>::iterator              tSnapShotIdListIt;
typedef std::list<vdl_tsSnapShotIdStruct>::const_iterator        tSnapShotIdListCIt;

typedef std::map<tU32, tITCVector>                  tServiceUpdateMap;
typedef std::map<tU32, tITCVector>::iterator        tServiceUpdateMapIt;
typedef std::map<tU32, tITCVector>::const_iterator  tServiceUpdateMapCIt;

#endif // VD_DIAGLOG_INCLUDEGUARD_vd_diaglog_typedefs_basic
