////////////////////////////////////////////////////////////////////////////////
// FILE:         vd_diaglog_trace.h
// PROJECT:      Ford H/LRNS
// SW-COMPONENT: vd_diaglog
//----------------------------------------------------------------------
//
// DESCRIPTION:   This file contains all defines required by TTFIS-Tracing
//
//----------------------------------------------------------------------
// COPYRIGHT:    (c) 2006 Robert Bosch GmbH, Hildesheim
////////////////////////////////////////////////////////////////////////////////

#ifndef VD_DIAGLOG_INCLUDEGUARD_vd_diaglog_trace
#define VD_DIAGLOG_INCLUDEGUARD_vd_diaglog_trace

/* --Includes. */
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"

#include "vd_diaglog_trace.h"
// etrace has a macro definition for "_" that might cause trouble in boost headers files, therefore we undefine it here. Usage of "_" is deprecated. Please use the diagnostic macros with ","
#ifdef _
#undef _
#endif

#define ET_TRACE_FATAL( u16CompId, pcBuffer)     (et_vTrace(u16CompId, (tU16)TR_LEVEL_FATAL, pcBuffer))
#define ET_TRACE_FATAL_BIN(u16CompId, pcBuffer)  (et_vTraceBinary(u16CompId, (tU16)TR_LEVEL_FATAL, pcBuffer))


#define DIAGLOG_TRACE_CLASS_INFO 			(tU16) (TR_COMP_DIAGNOSIS + 0x09)
#define DIAGLOG_TRACE_CLASS_ERROR			(tU16) (TR_COMP_DIAGNOSIS + 0x0a)
#define DIAGLOG_TRACE_CLASS_FUNC			   (tU16) (TR_COMP_DIAGNOSIS + 0x0b)
#define DIAGLOG_TRACE_CLASS_MEM				(tU16) (TR_COMP_DIAGNOSIS + 0x0c)
#define DIAGLOG_TRACE_CLASS_SM				(tU16) (TR_COMP_DIAGNOSIS + 0x0d)
#define DIAGLOG_TRACE_CLASS_TSH_TP			(tU16) (TR_COMP_DIAGNOSIS + 0x10) // same as in fc_diagnosis
#define DIAGLOG_TRACE_CLASS_CCA_MSG			(tU16) (TR_COMP_DIAGNOSIS + 0x11)
#define DIAGLOG_TRACE_CLASS_CSM           (tU16) (TR_COMP_DIAGNOSIS + 0x12)
#define I_DIAGLOG_ERROR                                            0xFFFE // TRACE




#ifndef TSH_ERROR
   #define TSH_ERROR(a)     ET_TRACE_ERROR_BIN(DIAGLOG_TRACE_CLASS_ERROR, ET_EN_T16 _ I_DIAGLOG_ERROR _ ET_EN_T32 _ a _ ET_EN_DONE);
#endif


#define I_DIA_DEFSET_TRACE                                     0xFFFF // TRACE

#ifndef TSH_TP
   #define TSH_TP(a)        ET_TRACE_INFO_BIN(DIAGLOG_TRACE_CLASS_TSH_TP, ET_EN_T16 _ I_DIA_DEFSET_TRACE _ ET_EN_T32 _ a _ ET_EN_DONE);
#endif


enum tenTrcTraceClass
{    
	TR_CLASS_DIAGLOG_INFO		= DIAGLOG_TRACE_CLASS_INFO,
	TR_CLASS_DIAGLOG_ERROR		= DIAGLOG_TRACE_CLASS_ERROR,
   TR_CLASS_DIAGLOG_FUNC		= DIAGLOG_TRACE_CLASS_FUNC,
   TR_CLASS_DIAGLOG_MEM			= DIAGLOG_TRACE_CLASS_MEM,
   TR_CLASS_DIAGLOG_SM			= DIAGLOG_TRACE_CLASS_SM,
   TR_CLASS_DIAGLOG_TSH_TP		= DIAGLOG_TRACE_CLASS_TSH_TP,
   TR_CLASS_DIAGLOG_CCA_MSG   = DIAGLOG_TRACE_CLASS_CCA_MSG,
   TR_CLASS_DIAGLOG_CSM       = DIAGLOG_TRACE_CLASS_CSM

};

#define DIAGLOG_TRACE_INFO_BLOCKMODE      0x0001
#define DIAGLOG_TRACE_INFO_BLOCKMODE_PRE  0x0002

class vdDiagLog_tclApp;  //lint !e763

class vdl_tclTrace
{
// ctors/dtors
private:
   // private ctor to avoid inadvertant use
   //lint -esym(1704, vdl_tclTrace::vdl_tclTrace) "PQM_authorized_24"
   vdl_tclTrace();
public:
   vdl_tclTrace(vdDiagLog_tclApp*);
   ~vdl_tclTrace();
// operations
   tVoid vTraceRx(tU8 const* pu8Data) const;
// attributes
private:
   vdDiagLog_tclApp* m_poApp;
// implementation
   tVoid vDumpReportMem() const;
   tVoid vDumpReportMemById(tU8 MemoryID) const;
};

namespace vdl_nsTraceFunctions
{

/*inline tVoid vTraceSimple(tU16 u16Msg)
{
   ET_TRACE_INFO_BIN(DIAGLOG_TRACE_CLASS_FUNC, ET_EN_T16 _ u16Msg _ ET_EN_DONE);
}*/

}


#endif // VD_DIAGLOG_INCLUDEGUARD_vd_diaglog_trace
