//////////////////////////////////////////////////////////////////////////
// FILE:         vd_diaglog_storage_interface.h
// PROJECT:      Diag Core
// SW-COMPONENT: DiagLog
//----------------------------------------------------------------------
//
// DESCRIPTION: DiagLog storage Inferface
//              
//----------------------------------------------------------------------
// COPYRIGHT:    (c) 2014 Robert Bosch GmbH, Hildesheim
// HISTORY:      
// Date      | Author                       | Modification
// 28.10.14  | BSOT Plischke                | Initial version
//
//////////////////////////////////////////////////////////////////////////
#ifndef VD_DIAGLOG_INCLUDEGUARD_vd_diaglog_storage_interface
#define VD_DIAGLOG_INCLUDEGUARD_vd_diaglog_storage_interface

class vdl_tclDiagLogObject; //lint !e763

/*interface*/class vdl_tclStorageUserInterface
{
private:
   vdl_tclStorageUserInterface();

public:
   vdl_tclStorageUserInterface(tCString const szFilename);
   virtual ~vdl_tclStorageUserInterface();

   // this functions are called from the storage algorithm 
   virtual tVoid vSave(tStream& roData) = 0;
   virtual bool bLoad(tStream& roData) = 0;
   virtual tU8 u8GetDataFormatVerision() const = 0;
   virtual tVoid vGetSizeOfLoadBuffer(tS32& Max, tS32& Min) = 0;

private:
// attributes
   vdl_tclDiagLogObject*       m_poStorageObject;

protected:
// functions
   tVoid setModified();
   tU32 u32GetDataBaseTimestamp() const;
   tVoid saveNowIfModified();
   bool isDataBaseLoaded() const;
   tVoid deleteDataBase();
   bool loadDataBaseIfNotLoaded();
   tVoid requestForSaveIfModified();
};

#endif // VD_DIAGLOG_INCLUDEGUARD_vd_diaglog_file_storage_interface
