//////////////////////////////////////////////////////////////////////////
// FILE:         vd_diaglog_storage_handler.h
// PROJECT:      Diag Core
// SW-COMPONENT: DiagLog
//----------------------------------------------------------------------
//
// DESCRIPTION: DiagLog Master Object class - generic base class for Memory Objects
//              
//----------------------------------------------------------------------
// COPYRIGHT:    (c) 2014 Robert Bosch GmbH, Hildesheim
// HISTORY:      
// Date      | Author                       | Modification
// 29.10.14  | BSOT Plischke                 | Initial version
//
//////////////////////////////////////////////////////////////////////////
#ifndef VD_DIAGLOG_INCLUDEGUARD_vd_diaglog_storage_handler
#define VD_DIAGLOG_INCLUDEGUARD_vd_diaglog_storage_handler


#ifndef VD_DIAGLOG_INCLUDEGUARD_vd_diaglog_object
   #include <common/framework/vd_diaglog_object.h>
#endif

class vdl_tclStorageHandler
{
// construction/destruction
public:
   vdl_tclStorageHandler();  
   virtual ~vdl_tclStorageHandler(); 

// attributes
private:
   typedef std::list<vdl_tclDiagLogObject*>                    tMemoryObjectList;
   typedef std::list<vdl_tclDiagLogObject*>::iterator          tMemoryObjectListIt;
   typedef std::list<vdl_tclDiagLogObject*>::const_iterator    tMemoryObjectListCIt;

   tMemoryObjectList           m_oMemoryObjectList;

public:
   static OSAL_tTimerHandle   m_hSaveDataBaseTimer;

// operations
private:
   tVoid vOnInit();
   tVoid vOnClose() const;
   tVoid vStartMemoryBlockingTimer(tU32 timeMs) const;

public:
   // called by Framework
   static void vSaveDataBaseTimerHandler(tPVoid /*pvArg*/);   
   tVoid updateAfterStorageTimer() const;

   // called by user
   vdl_tclDiagLogObject* registerNewStorageObject(vdl_tclStorageUserInterface* const poInterface ,tCString const szFilename);
   tVoid unregisterNewStorageObject(vdl_tclDiagLogObject* const );

   // called by Object
   tVoid saveDoneInformation() const;

};

#endif // VD_DIAGLOG_INCLUDEGUARD_vd_diaglog_storage_handler

