//////////////////////////////////////////////////////////////////////////
// FILE:         vd_diaglog_report_record_const_data.h
// PROJECT:      common
// SW-COMPONENT: DiagLog
//----------------------------------------------------------------------
//
// DESCRIPTION: DiagLog ITC configuration class
//              
//----------------------------------------------------------------------
// COPYRIGHT:    (c) 2012 Robert Bosch GmbH, Hildesheim
// HISTORY:      
// Date      | Author                       | Modification
// 30.07.12  | BSOT Plischke                | Initial version for new Diaglog
//
//////////////////////////////////////////////////////////////////////////
#ifndef VD_DIAGLOG_INCLUDEGUARD_vd_diaglog_report_record_const_data
#define VD_DIAGLOG_INCLUDEGUARD_vd_diaglog_report_record_const_data

/* --Includes. */
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"


class vdl_tclReportRecordConstData
{
public:
   vdl_tclReportRecordConstData(const trReportRecordData* pDtcDefinitionTable, const int iSize):
      m_DtcDefinitionTable(pDtcDefinitionTable),
      m_iDtcDefinitionTableSize(iSize)
   {};
   virtual ~vdl_tclReportRecordConstData(){};

   const trReportRecordData*  m_DtcDefinitionTable;
   const int                  m_iDtcDefinitionTableSize;

   vdl_teDiaglogReportType GetReportType(tU16 const Index) 
   {
      return( GetData<vdl_teDiaglogReportType>(Index, m_DtcDefinitionTable[Index].m_eReportType));
   };


   // GetItcId
   tU16 GetItcId(tU16 const Index) const
   {
      return( GetData<tU16>(Index, m_DtcDefinitionTable[Index].m_u16ITC));
   };

   // GetDtcId
   tU32 GetDtcId(tU16 const Index)  const
   {
      return( GetData<tU32>(Index, m_DtcDefinitionTable[Index].m_u32DTC));
   };


   // GetVariant
   tU8 GetVariant(tU16 const Index) const
   {
      return( GetData<tU8>(Index, m_DtcDefinitionTable[Index].m_u8Variant));
   };

   // GetSeverity
   tU8 GetSeverity(tU16 const Index) const
   {
      return( GetData<tU8>(Index, m_DtcDefinitionTable[Index].m_u8Severity));
   };

   // GetWarningIndicator
   bool GetWarningIndicator(tU16 const Index) const
   {
      return( GetData<bool>(Index, m_DtcDefinitionTable[Index].m_bWarningIndicator));
   };

   // GetDTCEnabled
   bool GetDTCEnabled(tU16 const Index) const
   {
      return( GetData<bool>(Index, m_DtcDefinitionTable[Index].m_bDTCEnabled));
   };

   // GetIsContinous
   bool GetIsAgeingAllowed(tU16 const Index) const
   {
      return( GetData<bool>(Index, m_DtcDefinitionTable[Index].m_bAgeingAllowed));
   };

   // GetCanClear
   bool GetCanClear(tU16 const Index) const
   {
      return( GetData<bool>(Index, m_DtcDefinitionTable[Index].m_bCanClear));
   };

   // GetIsClearOnFirstPass
   bool GetIsClearOnFirstPass(tU16 const Index) const
   {
      return( GetData<bool>(Index, m_DtcDefinitionTable[Index].m_bClearOnFirstPass));
   };

   // GetClearOnStartup
   bool GetClearOnStartup(tU16 const Index) const
   {
      return( GetData<bool>(Index, m_DtcDefinitionTable[Index].m_bClearOnStartup));
   };

   // GetIsStateChangeAllowedWithoutDebounce
   bool GetIsStateChangeAllowedWithoutDebounce(tU16 const Index) const
   {
      return( GetData<bool>(Index, m_DtcDefinitionTable[Index].m_bChangeWithoutDebounce));
   };

   // GetFailDelta
   tS32 GetFailDelta(tU16 const Index) const
   {
      return( GetData<tS32>(Index, m_DtcDefinitionTable[Index].m_s32FailDelta));
   };

   // GetPassDelta
   tS32 GetPassDelta(tU16 const Index) const
   {
      return( GetData<tS32>(Index, m_DtcDefinitionTable[Index].m_s32PassDelta));
   };

   // GetMaxAge
   tU8 GetMaxAge(tU16 const Index) const
   {
      return( GetData<tU8>(Index, m_DtcDefinitionTable[Index].m_u8MaxAge));
   };

   // GetMaxAge
   vdl_teDiaglogAgeingCycle GetAgeTriggerEvent(tU16 const Index) const
   {
      return( GetData<vdl_teDiaglogAgeingCycle>(Index, m_DtcDefinitionTable[Index].m_eAgeingTrigger));
   };

   // GetTestFrequency
   tU8 GetTestFrequency(tU16 const Index) const
   {
      return( GetData<tU8>(Index, m_DtcDefinitionTable[Index].m_U8TestFrequency));
   };

   // GetBlockingList
   const tU32* ptrGetBlockList(tU16 const Index) const
   {
      if(DIAGLOG_MAX_BLOCKDTCLIST > 0)
      {
         return( GetData<const tU32*>(Index, &(m_DtcDefinitionTable[Index].m_u32BlockingDTCList[0])));
      }
      else
      {
         return NULL;
      }
   };

   // GetBlockingMode
   tU32 GetBlockingMode(tU16 const Index) const
   {
      return( GetData<tU32>(Index, m_DtcDefinitionTable[Index].m_u32DTCBlockingMode));
   };

   // GetAppId
   tU32 GetAppId(tU16 const Index) const
   {
      return( GetData<tU32>(Index, m_DtcDefinitionTable[Index].m_u32AppID));
   };

   // GetExtData
   const tU8* ptrGetExtData(tU16 const Index) const
   {
      if(DIAGLOG_MAX_EXTENDED_RECORDS_SUPPORTED > 0)
      {
         return( GetData<const tU8*>(Index, &(m_DtcDefinitionTable[Index].m_extendedDataRecords[0])));
      }
      else
      {
         return NULL;
      }
      /*
      if(Index < m_iDtcDefinitionTableSize)
      {
         return &(m_DtcDefinitionTable[Index].m_extendedDataRecords[0]);
      }
      else
      {
         et_vErrmemStringNormal( TR_COMP_DIAGNOSIS, "DIAGLOG Get Data Index %x failed Size=%d",Index,m_iDtcDefinitionTableSize);
         NORMAL_M_ASSERT_ALWAYS();
         return NULL;
      }
      */
   };
   // GetSnapShotData
   const tU8* ptrGetSnapShotData(tU16 const Index) const
   {
      if(DIAGLOG_MAX_EXTENDED_RECORDS_SUPPORTED > 0)
      {
         return( GetData<const tU8*>(Index, &(m_DtcDefinitionTable[Index].m_snapshotDataRecords[0])));
      }
      else
      {
         return NULL;
      }
   };


private:

   template <typename T>
   tBool GetData(const tU16 Index, T& DestData, const T SourceData) 
   {
      if(Index < m_iDtcDefinitionTableSize)
      {
         DestData = SourceData;
         return true;
      }
      else
      {
         et_vErrmemStringNormal( TR_COMP_DIAGNOSIS, "DIAGLOG Get Data Index %x failed Size=%d",Index,m_iDtcDefinitionTableSize);
         return false;
      }
   }



   template <typename T>
   T GetData(const tU16 Index, const T SourceData)   const
   {
      if(Index < m_iDtcDefinitionTableSize)
      {
         return SourceData;
      }
      else
      {
         et_vErrmemStringNormal( TR_COMP_DIAGNOSIS, "DIAGLOG Get Data Index %x failed Size=%d",Index,m_iDtcDefinitionTableSize);
         NORMAL_M_ASSERT_ALWAYS();
         return (T)0;
      }
   }

};

#endif // VD_DIAGLOG_INCLUDEGUARD_vd_diaglog_report_record_const_data
