//////////////////////////////////////////////////////////////////////////
// FILE:         vd_diaglog_report_record.h
// PROJECT:      common
// SW-COMPONENT: DiagLog
//----------------------------------------------------------------------
//
// DESCRIPTION: DiagLog Report Record base class
//              
//----------------------------------------------------------------------
// COPYRIGHT:    (c) 2005 Robert Bosch GmbH, Hildesheim
// HISTORY:      
// Date      | Author                       | Modification
// 27.10.05  | ESA2 Barber                  | Initial version
// 04.10.12  | BSOT Plischke                | new Diaglog
// 22.10.15  | gpu2kor					    | fix for CMG3GB-2474
// 28.12.18  | mky6kor						| Extended data configuration(RTC-434184)
//////////////////////////////////////////////////////////////////////////
#ifndef VD_DIAGLOG_INCLUDEGUARD_vd_diaglog_report_record
#define VD_DIAGLOG_INCLUDEGUARD_vd_diaglog_report_record


#ifndef VD_DIAGLOG_INCLUDEGUARD_vd_diaglog_object
   #include <common/framework/vd_diaglog_object.h>
#endif

#ifndef VD_DIAGLOG_INCLUDEGUARD_vd_diaglog_configuration
   #include <project/framework/vd_diaglog_configuration.h>
#endif

#ifndef VD_DIAGLOG_INCLUDEGUARD_vd_diaglog_typedefs
   #include <common/framework/vd_diaglog_typedefs.h>
#endif

#ifndef VD_DIAGLOG_INCLUDEGUARD_vd_diaglog_report_record_const_data
   #include <common/framework/vd_diaglog_report_record_const_data.h>
#endif

#ifndef VD_DIAGLOG_INCLUDEGUARD_vd_diaglog_itc_definition_common
   #include <common/framework/vd_diaglog_itc_definition_common.h>
#endif

// forward declaration
class vdl_tclReportMemory; //lint !e763
namespace VDD
{
class ExtendedData;
}// namespace VDD

class vdl_tclReportRecord
{
// construction/destruction
private:
   // private ctor to avoid inadvertant use
   //lint -esym(1704, vdl_tclReportRecord::vdl_tclReportRecord) "PQM_authorized_21"
   vdl_tclReportRecord();

   // the following could be overwritten by Local, so use it as private only
   tS32  u32GetPassDeltaByConf() const              {return m_pReportRecordConstData->GetPassDelta(m_Index);}     // could be overwritten by Local, use s32GetPassValue
   tS32  u32GetFailDeltaByConf() const              {return m_pReportRecordConstData->GetFailDelta(m_Index);}     // could be overwritten by Local, use s32GetFailValue
   tU8   u8GetMaxAgeByConf() const                  {return m_pReportRecordConstData->GetMaxAge(m_Index);}        // could be overwritten by Local, use u8GetMaxAge

public:
   vdl_tclReportRecord(vdl_tclReportMemory* const pMemoryObject, vdl_tclReportRecordConstData const* pReportRecordConstData,  tU16 Index);
   vdl_tclReportRecord(vdl_tclReportMemory* const pMemoryObject, tU16 u16ITC, tU32 u32DTC);
   virtual ~vdl_tclReportRecord();

// attributes
   bool  m_bIsIgnitionCycleActive;           // ture if we are currently in Ignition RUN state


   // Data from const Block
   tU32  u32DTC() const                             { if(m_u32DTC!=0)
                                                         return m_u32DTC;
                                                       else
                                                         return m_pReportRecordConstData->GetDtcId(m_Index);}
   tU16  u16ITC() const                             { if(m_u16ITC!=0)
                                                         return m_u16ITC;
                                                       else
                                                         return m_pReportRecordConstData->GetItcId(m_Index);}
   tU32  u32GetDTCBlockingMode() const              {return m_pReportRecordConstData->GetBlockingMode(m_Index);}
   const tU32* ptrGetBlockList() const              {return m_pReportRecordConstData->ptrGetBlockList(m_Index);}
   tU8   u8GetTestFreq() const                      {return m_pReportRecordConstData->GetTestFrequency(m_Index);}
   tU32  u32GetAppID() const                        {return m_pReportRecordConstData->GetAppId(m_Index);}
   tU8   u8GetVariant() const                       {return m_pReportRecordConstData->GetVariant(m_Index);}
   tU8   u8GetSeverity() const                      {return m_pReportRecordConstData->GetSeverity(m_Index);}
   bool  bGetWarningIndicatorConfiguration()const   {return m_pReportRecordConstData->GetWarningIndicator(m_Index);}
   bool  bIsAgeingAllowedByConf() const             {return m_pReportRecordConstData->GetIsAgeingAllowed(m_Index);}
   bool  bIsClearAllowed() const                    {return m_pReportRecordConstData->GetCanClear(m_Index);}
   bool  bIsClearOnFirstPass() const                {return m_pReportRecordConstData->GetIsClearOnFirstPass(m_Index);}
   bool  bIsClearOnStartup() const                  {return m_pReportRecordConstData->GetClearOnStartup(m_Index);}
   bool  bIsChangeAllowedWihtoutDebounce() const    {return m_pReportRecordConstData->GetIsStateChangeAllowedWithoutDebounce(m_Index);}
   const tU8* pGetExtData() const                   {return m_pReportRecordConstData->ptrGetExtData(m_Index);}
   const tU8* pGetSnapShotData() const              {return m_pReportRecordConstData->ptrGetSnapShotData(m_Index);}
   tS32  s32GetPassValue() const                    {return m_s32PassValue;}
   tVoid vSetPassValue(tS32 Value)                  {m_s32PassValue = Value;}
   tS32  s32GetFailValue() const                    {return m_s32FailValue;}
   tVoid vSetFailValue(tS32 Value)                  {m_s32FailValue = Value;}
   tU8   u8GetMaxAge() const                        {return m_u8MaxAgeing;}
   tVoid u8SetMaxAge(tU8 Value)                     {m_u8MaxAgeing = Value;}
   tU16  u16GetIndex() const                        {return m_Index;}
   vdl_teDiaglogAgeingCycle getAgeingTrigger() const {return  m_pReportRecordConstData->GetAgeTriggerEvent(m_Index);}      

   /**** Data from dyn block ****/
   bool  bIsDTCEnabled() const                      {return ((    (m_bDisabledByVariant == false)  
                                                               && (m_uRecordStatus.sStatus.m_bIsCalibrationDTCEnabled)
                                                               && (m_uRecordStatus.sStatus.m_bIsDTCControlEnabled)
                                                              )?true:false);}


   // DTCControl
   bool  bIsDTCControlEnabled() const               {return (m_uRecordStatus.sStatus.m_bIsDTCControlEnabled?true:false);}
   tVoid vSetDTCControlEnabled()                    {  if (m_uRecordStatus.sStatus.m_bIsDTCControlEnabled != TRUE)
                                                       {
                                                          m_uRecordStatus.sStatus.m_bIsDTCControlEnabled = TRUE;
                                                          vSetModified();
                                                       }
                                                    }
   tVoid vSetDTCControlDisabled()                   {  if (m_uRecordStatus.sStatus.m_bIsDTCControlEnabled != TRUE)
                                                       {
                                                          m_uRecordStatus.sStatus.m_bIsDTCControlEnabled = TRUE;
                                                          vSetModified();
                                                       }
                                                    }

   // DTCCalibration
   bool  bIsDTCCalibrationEnabled() const           {return (m_uRecordStatus.sStatus.m_bIsCalibrationDTCEnabled?true:false);}
   tVoid vSetDTCCalibrationEnabled()                {  if (m_uRecordStatus.sStatus.m_bIsCalibrationDTCEnabled != TRUE)
                                                       {
                                                          m_uRecordStatus.sStatus.m_bIsCalibrationDTCEnabled = TRUE;
                                                          vSetModified();
                                                       }
                                                    }
   tVoid vSetDTCCalibrationDisabled()               {  if (m_uRecordStatus.sStatus.m_bIsCalibrationDTCEnabled != FALSE)
                                                       {
                                                          m_uRecordStatus.sStatus.m_bIsCalibrationDTCEnabled = FALSE;
                                                          vSetModified();
                                                       }
                                                    }

   //DTCReadByCalibration
   bool  bIsDTCReadByCalibrationEnabled() const;    // see cpp-File
   tVoid vSetDTCReadByCalibrationEnabled()          {  if (m_uRecordStatus.sStatus.m_bIsDTCReadByCalibrationEnabled != TRUE)
                                                       {
                                                          m_uRecordStatus.sStatus.m_bIsDTCReadByCalibrationEnabled = TRUE;
                                                          vSetModified();
                                                       }
                                                    }
   tVoid vSetDTCReadByCalibrationDisabled()         {  if (m_uRecordStatus.sStatus.m_bIsDTCReadByCalibrationEnabled != FALSE)
                                                       {
                                                          m_uRecordStatus.sStatus.m_bIsDTCReadByCalibrationEnabled = FALSE;
                                                          vSetModified();
                                                       }
                                                    }

   /***** status Flags ******/
   // Active
   bool  bGetIsActive() const                            {return (m_uRecordStatus.sStatus.m_bIsActive?true:false);}
   tVoid vSetIsActive(bool bStatus)                      {  if (m_uRecordStatus.sStatus.m_bIsActive != bStatus)
                                                            {
                                                               m_uRecordStatus.sStatus.m_bIsActive = bStatus;
                                                               vSetModified();
                                                            }
                                                         }

   // FailedInPreviousIgnCycle
   bool  bGetIsFailedInPreviousIgnCycle() const          {return (m_uRecordStatus.sStatus.m_bIsFailedInPreviousIgnCycle?true:false);}
   tVoid bSetIsFailedInPreviousIgnCycle(bool bStatus)    {  if (m_uRecordStatus.sStatus.m_bIsFailedInPreviousIgnCycle != bStatus)
                                                            {
                                                               m_uRecordStatus.sStatus.m_bIsFailedInPreviousIgnCycle = bStatus;
                                                               vSetModified();
                                                            }
                                                         }

   // PassedInCurrentIgnCycle
   bool  bGetIsPassedInCurrentIgnCycle() const           {return (m_uRecordStatus.sStatus.m_bIsPassedInCurrentIgnCycle?true:false);}
   tVoid bSetIsPassedInCurrentIgnCycle(bool bStatus)     {  if (m_uRecordStatus.sStatus.m_bIsPassedInCurrentIgnCycle != bStatus)
                                                            {
                                                               m_uRecordStatus.sStatus.m_bIsPassedInCurrentIgnCycle = bStatus;
                                                               vSetModified();
                                                            }
                                                         }


   // FailedInCurrentIgnCycle 
   bool  bGetIsFailedInCurrentIgnCycle() const           {return (m_uRecordStatus.sStatus.m_bIsFailedInCurrentIgnCycle?true:false);}
   tVoid bSetIsFailedInCurrentIgnCycle(bool bStatus)     {  if (m_uRecordStatus.sStatus.m_bIsFailedInCurrentIgnCycle != bStatus)
                                                            {
                                                               m_uRecordStatus.sStatus.m_bIsFailedInCurrentIgnCycle = bStatus;
                                                               vSetModified();
                                                            }
                                                         }

   // History
   bool  bGetIsHistory() const                           {return (m_uRecordStatus.sStatus.m_bIsHistory?true:false);}
   tVoid bSetIsHistory(bool bStatus)                     {  if (m_uRecordStatus.sStatus.m_bIsHistory != bStatus)
                                                            {
                                                               m_uRecordStatus.sStatus.m_bIsHistory = bStatus;
                                                               vSetModified();
                                                            }
                                                         }

   // FailedSinceDTCCleared
   bool  bGetIsFailedSinceDTCCleared() const             {return (m_uRecordStatus.sStatus.m_bIsFailedSinceDTCCleared?true:false);}
   tVoid bSetIsFailedSinceDTCCleared(bool bStatus)        {  if (m_uRecordStatus.sStatus.m_bIsFailedSinceDTCCleared != bStatus)
                                                            {
                                                               m_uRecordStatus.sStatus.m_bIsFailedSinceDTCCleared = bStatus;
                                                               vSetModified();
                                                            }
                                                         }

   // PassedSinceCurrentPowerUp
   bool  bGetIsPassedSinceCurrentPowerUp() const         {return (m_uRecordStatus.sStatus.m_bIsPassedSinceCurrentPowerUp?true:false);}
   tVoid bSetIsPassedSinceCurrentPowerUp(bool bStatus)   {  if (m_uRecordStatus.sStatus.m_bIsPassedSinceCurrentPowerUp != bStatus)
                                                            {
                                                               m_uRecordStatus.sStatus.m_bIsPassedSinceCurrentPowerUp = bStatus;
                                                               vSetModified();
                                                            }
                                                         }

   // FailedInCurrentPowerCycle
   bool  bGetIsFailedInCurrentPowerCycle()  const        {return (m_uRecordStatus.sStatus.m_bIsFailedInCurrentPowerCycle?true:false);}
   tVoid bSetIsFailedInCurrentPowerCycle(bool bStatus)   {  if (m_uRecordStatus.sStatus.m_bIsFailedInCurrentPowerCycle != bStatus)
                                                            {
                                                               m_uRecordStatus.sStatus.m_bIsFailedInCurrentPowerCycle = bStatus;
                                                               vSetModified();
                                                            }
                                                         }

   // NotCompleteThisPowerCycle
   bool  bGetIsNotCompleteThisPowerCycle()  const        {return (m_uRecordStatus.sStatus.m_bIsNotCompleteThisOperationCycle?true:false);}
   tVoid bSetIsNotCompleteThisPowerCycle(bool bStatus)   {  if (m_uRecordStatus.sStatus.m_bIsNotCompleteThisOperationCycle != bStatus)
                                                            {
                                                               m_uRecordStatus.sStatus.m_bIsNotCompleteThisOperationCycle = bStatus;
                                                               vSetModified();
                                                            }
                                                         }


   // NotCompleteSinceCleared
   bool  bGetIsNotCompleteSinceCleared()  const          {return (m_uRecordStatus.sStatus.m_bIsNotCompleteSinceLastClear?true:false);}
   tVoid bSetIsNotCompleteSinceCleared(bool bStatus)     {  if (m_uRecordStatus.sStatus.m_bIsNotCompleteSinceLastClear != bStatus)
                                                            {
                                                               m_uRecordStatus.sStatus.m_bIsNotCompleteSinceLastClear = bStatus;
                                                               vSetModified();
                                                            }
                                                         }


   // NotPassedSinceDTCCleared
   bool  bGetIsNotPassedSinceDTCCleared()  const         {return (m_uRecordStatus.sStatus.m_bIsNotPassedSinceDTCCleared?true:false);}
   tVoid bSetIsNotPassedSinceDTCCleared(bool bStatus)    {  if (m_uRecordStatus.sStatus.m_bIsNotPassedSinceDTCCleared != bStatus)
                                                            {
                                                               m_uRecordStatus.sStatus.m_bIsNotPassedSinceDTCCleared = bStatus;
                                                               vSetModified();
                                                            }
                                                         }

   // IsPassedSinceDTCCleared
   bool  bGetIsPassedSinceDTCCleared() const             {return (m_uRecordStatus.sStatus.m_bIsPassedSinceDTCCleared?true:false);}
   tVoid bSetIsPassedSinceDTCCleared(bool bStatus)       {  if (m_uRecordStatus.sStatus.m_bIsPassedSinceDTCCleared != bStatus)
                                                            {
                                                               m_uRecordStatus.sStatus.m_bIsPassedSinceDTCCleared = bStatus;
                                                               vSetModified();
                                                            }
                                                         }

   tU32  u32GetStatus() const                            {return (m_uRecordStatus.u32Status);}
   tuRecordStatus getRecordStatus() const                {return m_uRecordStatus;}
   tU8   u8GetFailOccurenceCounter() const               {return (m_u8FailOccurenceCounter);}
   tU8   u8GetAgeingCounter() const                      {return (m_u8AgeingCounter);}

   tU8 u8GetMemoryId() const;
   const vdl_tclReportMemory* u8GetMemoryObject() const {return m_pMemoryObject;}
   bool isDynamicalDTC()const                            {return((u16ITC()>= DYNAMICAL_ITC_START_ID)?true:false);}

   tU8 u8MonitoringCyclesSinceFirstFail() const{ return this->m_u8MonCycleSinceFirstFail;}

protected:
   vdl_tclReportMemory* const  m_pMemoryObject;
   tU16  m_Index;                             // Index to const Data Object
   tuRecordStatus m_uRecordStatus;           // DTC Status Mask (persistent)

   tU8   m_u8FailOccurenceCounter;           // counts number of confirmed Fail detections (persistent)
   tU8   m_u8MonCycleSinceFirstFail;
   tS32  m_s32FailValue;                     // fail debouncing (can be overwritten via EOL)
   tS32  m_s32PassValue;                     // pass debouncing (can be overwritten via EOL)
   tU8   m_u8MaxAgeing;                      // max ageing value(can be overwritten via EOL)

   std::map<tU8, VDD::ExtendedData*> extendedData;
   const vdl_tclReportRecordConstData* m_pReportRecordConstData;

   tU16  m_u16ITC;                           // needed for dynamical DTC's
   tU32  m_u32DTC;                           // needed for dynamical DTC's

   bool  m_bDisabledByVariant;

public:
    tU8   m_u8AgeingCounter;                  // counts number passed ignitionscycles (persistent)

// operations
   // Data from dyn block
   virtual tVoid vClear(bool forced=false);
   virtual tVoid processSystemEvent(vdl_teDiaglogSystemEvent systemEvent);
   virtual tVoid vPass();
   virtual tVoid vPassQualified();
   virtual tVoid vFail();
   virtual tVoid vFailQualified();
   virtual bool bLoad(tStreamCIterator&);
   virtual tVoid vSave(tStream&) const;
   virtual tVoid vTrace();

   tVoid vSetModified();

   void  initialise()   {addExtendedData();}
   VDD::ExtendedData const* getExtendedData(tU8) const;
   void getSnapShotData(tU8 recordNumber, tU32& status, tSnapShotDataList& SnapShotDataList) const;
   
   static VDD::ExtendedData const* extendedDataRecordListBasedOnMultiITC(tReportArray ITCList, tU8 recordNumber);
private:
   void collectExtendedData();
   void collectSnapShotData(vdl_teDiaglogSnapShotTrigger trigger) const;
   void addExtendedData();
   tBool bEventStep(vdl_teDiaglogEventStep enEventStep, vdl_tclReportRecord* pReportRecord = NULL) const;
   tVoid vOperatingCycleEnd();
   tVoid vIgnitionCycleEnd();
   tVoid vIgnitionCycleStart();
   tVoid vOperatingCycleStart();

protected:
   VDD::ExtendedData* generateExtendedData(tU8 recNo, const vdl_tclReportRecord* const pReportRecord);

};

#endif // VD_DIAGLOG_INCLUDEGUARD_vd_diaglog_report_record
