/************************************************************************
* FILE:         vd_diaglog_proxy.cpp
* PROJECT:      all
* SW-COMPONENT:
*----------------------------------------------------------------------
*
* DESCRIPTION: DiagLog main application proxy -> SPM Interface
*
*----------------------------------------------------------------------
* COPYRIGHT:    (c) 2013 Robert Bosch GmbH, Hildesheim
* HISTORY:
* Date      | Author             | Modification
* 09.07.13  | BSOT Plischke      | initial version
*************************************************************************/
#ifndef VD_DIAGLOG_INCLUDEGUARD_vd_diaglog_main
   #include <common/framework/vd_diaglog_main.h>
#endif

// first include diaglog settings
#include <common/framework/vd_diaglog_settings.h>

#include "vd_diaglog_proxy.h"


#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_DIAGLOG_INFO
#include "trcGenProj/Header/vd_diaglog_proxy.cpp.trc.h"
#endif

/*********************************************************************************
* G3G Interface
**********************************************************************************/

///////////////////////////////////////////////////////////////////////////////////
//
// FUNCTION: vdDiagLog_tclAppProxy::theServer
//
// DESCRIPTION: creat new server object
//              G3G Interface
//
// PARAMETER:  void
//
// RETURNVALUE: tVoid
//
///////////////////////////////////////////////////////////////////////////////////
//
/*static*/ ail_tclAppAdapt*
vdDiagLog_tclAppProxy::theServer()
{
   return vdDiagLog_tclApp::theServer();
}

/*********************************************************************************
* GM Interface
**********************************************************************************/

///////////////////////////////////////////////////////////////////////////////////
//
// FUNCTION: vdDiagLog_tclAppProxy::vdDiagLog_tclAppProxy
//
// DESCRIPTION: constructor
//
// PARAMETER:  void
//
// RETURNVALUE: tVoid
//
///////////////////////////////////////////////////////////////////////////////////
//
vdDiagLog_tclAppProxy::vdDiagLog_tclAppProxy ( tVoid )
{
   ETG_TRACE_USR3_THR(( "--> diagnostics_tclAppProxy::diagnostics_tclAppProxy"));
   poVDDiaglog = vdDiagLog_tclApp::theServer();
   ETG_TRACE_USR3_THR(( "<-- diagnostics_tclAppProxy::diagnostics_tclAppProxy"));
}

///////////////////////////////////////////////////////////////////////////////////
//
// FUNCTION: vdDiagLog_tclAppProxy::~vdDiagLog_tclAppProxy
//
// DESCRIPTION: destructor
//
// PARAMETER:  void
//
// RETURNVALUE: tVoid
//
///////////////////////////////////////////////////////////////////////////////////
//
vdDiagLog_tclAppProxy::~vdDiagLog_tclAppProxy()
{
   ETG_TRACE_USR3_THR(( "--> diagnostics_tclAppProxy::~diagnostics_tclAppProxy"));

   _BP_TRY_BEGIN
   {
      if (poVDDiaglog != NULL)
      {
         releaseInstanceOfVdDiagLog_tclApp();
         poVDDiaglog = NULL;
      }
   }
   _BP_CATCH_ALL
   {
      ETG_TRACE_ERRMEM(( "!!! diagnostics_tclAppProxy::~diagnostics_tclAppProxy => _BP_CATCH_ALL"));
      NORMAL_M_ASSERT_ALWAYS();
   }
   _BP_CATCH_END

   ETG_TRACE_USR3_THR(( "<-- diagnostics_tclAppProxy::~diagnostics_tclAppProxy"));
}

///////////////////////////////////////////////////////////////////////////////////
//
// FUNCTION: vdDiagLog_tclAppProxy::bInitInstance
//
// DESCRIPTION: forward to Diaglog Interface
//
// PARAMETER:  tU16 u16NewLpmId,
//             tU16 u16MyAppId
//
// RETURNVALUE: bool succesfull=true
//
///////////////////////////////////////////////////////////////////////////////////
//
tBool vdDiagLog_tclAppProxy::bInitInstance (tU16 u16NewLpmId, tU16 u16MyAppId)
{
   ETG_TRACE_USR3_THR(( "--> diagnostics_tclAppProxy::bInitInstance"));

   tBool bReturn;

   if (poVDDiaglog != NULL)
   {
      bReturn = poVDDiaglog->bInitInstance(u16NewLpmId, u16MyAppId);
   }
   else
   {
      bReturn = FALSE;
   }

   ETG_TRACE_USR3_THR(( "<-- diagnostics_tclAppProxy::bInitInstance"));
   return bReturn;
}

///////////////////////////////////////////////////////////////////////////////////
//
// FUNCTION: vdDiagLog_tclAppProxy::vDeinitInstance
//
// DESCRIPTION: forward to Diaglog Interface
//
// PARAMETER:  none
//
// RETURNVALUE: none
//
///////////////////////////////////////////////////////////////////////////////////
//
tVoid vdDiagLog_tclAppProxy::vDeinitInstance()
{
   ETG_TRACE_USR3_THR(( "--> diagnostics_tclAppProxy::vDeinitInstance"));
   if (poVDDiaglog != NULL)
   {
      poVDDiaglog->vDeinitInstance();
   }
   ETG_TRACE_USR3_THR(( "<-- diagnostics_tclAppProxy::vDeinitInstance"));
}



