/*!
* \file       vd_diaglog_object.h
*
* \brief      DiagLog Object class - generic base class
*
* \details    used to persistently store and read the logging info persistent files.
*
* \component  Diaglog
*
* \ingroup    DiaglogFramework
*
* \copyright  (c) 2018 Robert Bosch GmbH
*
* The reproduction, distribution and utilization of this file as
* well as the communication of its contents to others without express
* authorization is prohibited. Offenders will be held liable for the
* payment of damages. All rights reserved in the event of the grant
* of a patent, utility model or design.
*/

#ifndef VD_DIAGLOG_INCLUDEGUARD_vd_diaglog_object
#define VD_DIAGLOG_INCLUDEGUARD_vd_diaglog_object

// Version must be changed if new Elements are added
#define DIAGLOG_MEMORY_VERSION_MAIN    5
#define DIAGLOG_MEMORY_HEADER_SIZE     6

class vdl_tclStorageUserInterface;
class vdl_tclStorageHandler;

#ifdef VARIANT_S_FTR_ENABLE_TRANSACTION_SAFETY
class vdDiaglog_ObjManager;
#endif

class vdl_tclDiagLogObject
{
// construction/destruction
private:
   vdl_tclDiagLogObject();
public:
   vdl_tclDiagLogObject(vdl_tclStorageHandler* const poStorageHandler, vdl_tclStorageUserInterface* const poStorageUser, tCString const szFilename);  
   virtual ~vdl_tclDiagLogObject(); 
public:
// attributes
private:
   bool                 m_bIsModified;             // database (object hierarchy) is modified
   tU32                 m_u32DataBaseTimestamp;    // the Date and Time of creation of Diaglog.log

   bool                 m_bCanSave;
   bool                 m_bIsLoaded;
   tCString             m_szFilename;
   static tU8           m_instanceCounter;  
   vdl_tclStorageUserInterface* const m_poStorageUser;
   vdl_tclStorageHandler* const m_poStorageHandler;  
#ifdef VARIANT_S_FTR_ENABLE_TRANSACTION_SAFETY
   vdDiaglog_ObjManager* m_poObjMgr;
#endif
// operations
public:
   // by storage Handler
   tU32 u32GetDataBaseTimestamp() const      {return m_u32DataBaseTimestamp;}
   tVoid setCanSave(bool b)                  {m_bCanSave = b;}
   tCString getFileName()                    {return m_szFilename;}

   // by User
   tVoid setModified()                       {m_bIsModified = true;}
   tVoid saveNowIfModified();
   bool isDataBaseLoaded() const             {return m_bIsLoaded;}
   tVoid deleteDataBase();
   bool loadDataBaseIfNotLoaded();
   tVoid requestForSaveIfModified();

private:

   bool bReCreateFile();
   bool bIsModified() const                  {return m_bIsModified;}
   bool bSave();
   bool bLoad();
   tVoid vSetDataBaseTimestamp(tU32 Timestamp) {m_u32DataBaseTimestamp = Timestamp;}
   tVoid vSaveVersionData(tStream&) const;
   bool bIsLoaded() const                    {return m_bIsLoaded;}
   bool bCheckHeader(tStream& oData);
   bool bIsLogCompatible(const tU8 Version, const tU8 u8Format) const;
   tU8  u8GetMemoryVersion()const{ return DIAGLOG_MEMORY_VERSION_MAIN;}


};

#endif // VD_DIAGLOG_INCLUDEGUARD_vd_diaglog_object
