/************************************************************************
* FILE:         vd_diaglog_main.h
* PROJECT:      DIAG Core
* SW-COMPONENT: VD_DiagLog
*----------------------------------------------------------------------
*
* DESCRIPTION: DiagLog main application class
*
*----------------------------------------------------------------------
* COPYRIGHT:    (c) 2005 Robert Bosch GmbH, Hildesheim
* HISTORY:
* Date      | Author             | Modification
* 17.10.05  | CM-DI/ESA2 Barber  | initial version
* 23.07.10  | TMS Daoud          | Updates for GMG2
* 14.01.13  | BSOT Plischke      | new Diaglog
*************************************************************************/

#ifndef VD_DIAGLOG_INCLUDEGUARD_vd_diaglog_main
#define VD_DIAGLOG_INCLUDEGUARD_vd_diaglog_main

#ifndef _GLIBCXX_USE_CXX11_ABI
#define _GLIBCXX_USE_CXX11_ABI 1
#endif
//-----------------------------------------------------------------------------
// includes
//-----------------------------------------------------------------------------

/* --Includes. */
#define AIL_S_IMPORT_INTERFACE_GENERIC
#include "ail_if.h"

/* --Includes. */
#define AHL_S_IMPORT_INTERFACE_GENERIC
#include "ahl_if.h"


#ifndef VD_DIAGLOG_INCLUDEGUARD_vd_diaglog_typedefs
   #include <common/framework/vd_diaglog_typedefs.h>
#endif

#ifndef VD_DIAGLOG_INCLUDEGUARD_vd_diaglog_memory_master
   #include <common/framework/vd_diaglog_memory_master.h>
#endif

#ifndef VD_DIAGLOG_INCLUDEGUARD_vd_diaglog_blockingmode
   #include <common/framework/vd_diaglog_blockingmode.h>
#endif

#ifndef VD_DIAGLOG_INCLUDEGUARD_vd_diaglog_main_prj
   #include <project/framework/vd_diaglog_main_prj.h>
#endif

#ifndef VD_DIAGLOG_INCLUDEGUARD_vd_diaglog_storage_handler
   #include <common/framework/vd_diaglog_storage_handler.h>
#endif



// CCA constants for array sizes and semaphore name
#define DIAGLOG_FUNCARRAY_SIZE    3
#define DIAGLOG_NOTARRAY_SIZE     27
#define DIAGLOG_NOTTABLE_SEM_NAME  "DIAGLOG_NOTTABLESEM"
#define DIAGLOG_REPORTMEM_SEM_NAME   "DIAGLOG_REPORTMEMSEM"
#define DIAGLOG_ASF_SEM_NAME   "DIAGLOG_ASFSEM"
#define DIAGLOG_DTCTRIGTIMER_SEM_NAME   "DIAGLOG_DTCTIMERSEM"

#define DIAGLOG_EVENT_NAME "DIAGLOG_EVENT_NAME"
#define DIAGLOG_EVENT_TIMER_QUALI_MASK           0x01
#define DIAGLOG_EVENT_TRIGGER_BLOCKINGMODE_MASK  0x02
#define DIAGLOG_EVENT_TIMER_PLUGIN_STEP_MASK     0x04
#define DIAGLOG_EVENT_TRIGGER_UPDATE_AFTER_BM    0x08
#define DIAGLOG_EVENT_TIMER_STORAGE_MASK         0x10
#define DIAGLOG_EVENT_TERMINATE_MASK             0x80



// timer thread registry entries
// Audio system thread default config

#define DIAGLOG_REG_THREAD_NAME                  "DIA_LOG"
#define DIAGLOG_REG_THREAD_DEFAULT_PRIO          133
#define DIAGLOG_REG_THREAD_DEFAULT_STACKSIZE     4096
#define DIAGLOG_REG_THREAD_PRIO                  "DIAGLOG_PRIO"
#define DIAGLOG_REG_THREAD_STACK_SIZE            "DIAGLOG_STCK"
#define DIAGLOG_REG_THREAD_PATH                  "APP_THREAD"



class vdDiagLog_tclService;            //lint !e763
class vdl_tclMemoryMaster;             //lint !e763
class vdl_tclTrace;                    //lint !e763
class vdDiaglog_tclclienthandlerspm;   //lint !e763
class vdl_tclIncCommunication;         //lint !e763
class vdDiagLog_tclAppPrj;             //lint !e763
class vdl_tclPluginBaseClass;          //lint !e763
class vdl_tclSnapShotData;             //lint !e763

typedef struct
{
   vdl_tclPluginBaseClass* pCallbackClass;
   tS32   s32TimerId;
   tS32   s32IntervalTime;
   tS32   s32CurrTimeCounter;
} vdl_tsDiaglogTimerRegistration;


void releaseInstanceOfVdDiagLog_tclApp ( void );

//-----------------------------------------------------------------------------
// class definition
//-----------------------------------------------------------------------------
class vdDiagLog_tclApp : //public ahl_tclBaseWork,
                         public ail_tclAppInterface,
                         public vdDiagLog_tclAppPrj
{
// construction/destruction
public:
   // method to create server object - called by SPM
   static vdDiagLog_tclApp* theServer();
   static void deleteInstance ( void );

   vdDiagLog_tclApp();
private:
   // private ctor to avoid inadvertant use
   //lint -esym(1704, vdDiagLog_tclApp::vdDiagLog_tclApp) "PQM_authorized_22"
   vdDiagLog_tclApp(const vdDiagLog_tclApp& c); //this function must not be used, therefore it is private

// event enums, constants and statics
public:
   enum {enTimerEventMask = 0x00000040};

   typedef std::list<vdl_tsDiaglogTimerRegistration>                    tTimerRegistrationList;
   typedef std::list<vdl_tsDiaglogTimerRegistration>::iterator          tTimerRegistrationListIt;
   typedef std::list<vdl_tsDiaglogTimerRegistration>::const_iterator    tTimerRegistrationListCIt;


// attributes

   // standard data
   static vdDiagLog_tclApp*   m_poInstance;
private:
   static vdDiagLog_tclApp*   _theServer;

   ahl_tFunction              m_aFuncArray[DIAGLOG_FUNCARRAY_SIZE];     // for notification storage
   ahl_tNotification          m_aNotArray[DIAGLOG_NOTARRAY_SIZE];       // for notification storage
   OSAL_tIODescriptor         m_fdTrace;
   vdl_tclTrace*              m_poTraceHandler;
   OSAL_tThreadID             m_threadID;
   static bool                m_fTerminated;
   vdDiagLog_BlockingMode     m_oBlockingModeHandler;
   static bool                m_isPluginTimerRunning;

public:
   // diaglog specific
   static OSAL_tSemHandle     m_hNotTableSem;
   static OSAL_tSemHandle     m_hReportMemSem;
   static OSAL_tSemHandle     m_hASFSem;


   static OSAL_tTimerHandle   m_hQualificationTimer;
   static OSAL_tEventHandle   m_hEventHandle;
   static OSAL_tTimerHandle   m_hPlugInTimer;

   ahl_tclNotificationTable*  m_poNotTable;
   vdl_tclMemoryMaster        m_oMemoryMaster;
   vdl_tclStorageHandler      m_oStorageHandler;         // storage service
   vdDiagLog_tclService*      m_poService;
   vdDiaglog_tclclienthandlerspm* m_poSpmClientHandler;
   vdl_tclIncCommunication*   m_poIncInterface;          // V850 interface
   vdl_tclSnapShotData*       m_poSnapShotData;


   static tTimerRegistrationList   m_oTimerRegList;
   static tS32                     m_s32TimerId;

// operators
private:
   vdDiagLog_tclApp& operator=(const vdDiagLog_tclApp& c); //this function must not be used, therefore it is private

// operations
public:

   tU32 u32GetSystemBlockingMode()                                         {return m_oBlockingModeHandler.u32GetSystemBlockingMode();}
   tU32 u32GetValidSinceLastSendBlockingMode()                             {return m_oBlockingModeHandler.u32GetValidSinceLastSendBlockingMode();}
   bool isBlockingModeActive(vdl_tclReportRecord const* pReportRecord,tU32& blockingModeMask) const{return m_oBlockingModeHandler.isBlockingModeActive(pReportRecord,blockingModeMask);}
   tVoid vSetBlockingMode(tU32 u32Mode)                                    {m_oBlockingModeHandler.vSetBlockingMode(u32Mode);}
   tVoid vResetBlockingMode(tU32 u32Mode)                                  {m_oBlockingModeHandler.vResetBlockingMode(u32Mode);}
   tVoid vSetResetBlockingMode(tU32 u32ModeSet, tU32 u32ModeReset)         {m_oBlockingModeHandler.vSetResetBlockingMode(u32ModeSet,u32ModeReset);}
   tVoid vSetResetBlockingModeEventUpdate()                                {m_oBlockingModeHandler.vSetResetBlockingModeEventUpdate();}
   void updateBlockingModeAfterPassed(vdl_tclReportRecord const* pReportRecord){m_oBlockingModeHandler.updateBlockingModeAfterPassed(pReportRecord);}
   bool registerBlockModeCallback(tU8 MemoryId, tU16 ITC, tU32 callbackId, tU32 blockingMask, std::vector<tU32> blockDTCList){return (m_oBlockingModeHandler.registerBlockModeCallback(MemoryId, ITC, callbackId, blockingMask, blockDTCList));}
   bool unregisterBlockModeCallback(tU8 MemoryId, tU16 ITC)                {return (m_oBlockingModeHandler.unregisterBlockModeCallback(MemoryId, ITC));}

   vdl_tclQualificationBase* getQualificationObject() {return &m_oMemoryMaster.m_oQualificationList;}
   vdl_tclStorageHandler const*  getStorageObject() {return &m_oStorageHandler;}

   // standard functions
   virtual tBool bOnInit();
   virtual tVoid vOnServiceState
      (
      tU16 u16ServiceId,
      tU16 u16ServerId,
      tU16 u16RegisterId,
      tU8 u8ServiceState,
      tU16 u16SubId
      );
   virtual tVoid vOnNewAppState
      (
      tU32 u32OldAppState,
      tU32 u32AppState
      );
   virtual tVoid vOnNewMessage (amt_tclBaseMessage* poMessage);
   virtual tBool bOnWatchdog();
   virtual tVoid vOnApplicationClose();
   virtual tVoid vOnUnregister(tU16 u16ServiceID,tU16 u16RegisterID);

   tBool bRegisterForTimer(vdl_tclPluginBaseClass* pCallbackClass); // this Timer has a Tolerance of -100ms
   tBool bUnRegisterForTimer(vdl_tclPluginBaseClass* pCallbackClass);
   tBool bRegisterForEvent(vdl_tclPluginBaseClass* pCallbackClass);
   tBool bUnRegisterForEvent(vdl_tclPluginBaseClass* pCallbackClass);
   tS32 s32CreateTimer(vdl_tclPluginBaseClass* pCallbackClass) const;
   tBool bDeleteTimer(vdl_tclPluginBaseClass* pCallbackClass) const;
   tBool bSetTimer(tS32 s32TimerId, tS32 s32Time) const;
   static tVoid bTimerStep();
   static tVoid vPostEvent(tU32 Event);
   tVoid vStartDm1MessageOperatingCycle();
   tVoid vEndDm1MessageOperatingCycle();
// implementation
protected:
   virtual ~vdDiagLog_tclApp();

   //lint -sem(vdDiagLog_tclApp::vClose,cleanup)
   tVoid vClose();
   tVoid vRegisterTraceService();
   tVoid vUnregisterTraceService();
   bool bThreadSetup();
   // overrides
   virtual tBool bGetServiceVersion
      (
      tU16 u16ServiceID,
      tU16& rfu16MajorVersion,
      tU16& rfu16MinorVersion,
      tU16& rfu16PatchVersion
      );
private:

   static void vQualificationTimerHandler(tPVoid /*pvArg*/);
   static void vTriggerTimerHandler(tPVoid /*pvArg*/);// general Timer
   static tVoid vChannelMgr(tU8 const*);
   static tVoid vTimerThread(tVoid*);

   tVoid vCreateMemory();
   tVoid vDestroyMemory();

   static inline void LockMemorySemaphore();
   static inline void FreeMemorySemaphore();

   static tVoid vStopPluginTimer();
   static tVoid vStartPluginTimer(tU32 Timer);


};

class ScopedLockSemaphore
{
private:
   OSAL_tSemHandle hSem;
public:
   ScopedLockSemaphore(OSAL_tSemHandle handle)
   {
      hSem = handle;
      tS32 result = OSAL_s32SemaphoreWait(hSem, OSAL_C_U32_INFINITE);
      if(OSAL_OK != result)
      {
         NORMAL_M_ASSERT_ALWAYS();
      }
   }
   ~ScopedLockSemaphore()
   {
      tS32 result = OSAL_s32SemaphorePost(hSem);
      if(OSAL_OK != result)
      {
         NORMAL_M_ASSERT_ALWAYS();
      }
      hSem = OSAL_C_INVALID_HANDLE;
   }
};
#endif //VD_DIAGLOG_INCLUDEGUARD_vd_diaglog_main

