//////////////////////////////////////////////////////////////////////////
// FILE:         vd_diaglog_freeze_frame_data.cpp
// PROJECT:      common
// SW-COMPONENT: DiagLog
//----------------------------------------------------------------------
//
// DESCRIPTION: DiagLog FreezeFrame base class
//              
//----------------------------------------------------------------------
// COPYRIGHT:    (c) 2013 Robert Bosch GmbH, Hildesheim
// HISTORY:      
// Date      | Author                       | Modification
// 13.05.13  | BSOT Plischke                | Initial version
//
//////////////////////////////////////////////////////////////////////////

// first include diaglog settings
#include <common/framework/vd_diaglog_settings.h>

#ifndef VD_DIAGLOG_INCLUDEGUARD_vd_diaglog_freeze_frame_data_prj
   #include <project/framework/vd_diaglog_freeze_frame_data_prj.h>
#endif

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_DIAGLOG_INFO
#include "trcGenProj/Header/vd_diaglog_freeze_frame_data.cpp.trc.h"   
#endif

int vdl_tclFreezeFrameDataBase::iSizeOfFreezeFrameData() const
{
   return (sizeof(vdl_tuDiaglogFreezeFrameData));
}

void vdl_tclFreezeFrameDataBase::vLoadFreezeFrameData(tStreamCIterator& iPos)
{
   // get now freezeFrameData
   for(int i=0; i<iSizeOfFreezeFrameData(); i++)
   {
      m_uFreezeFrameData.Array[i]=static_cast<tU8>(*iPos++);
   }
}

void vdl_tclFreezeFrameDataBase::vSaveFreezeFrameData(tStream& roData) const
{
   // store now freezeFrameData
   for(int i=0; i<iSizeOfFreezeFrameData(); i++)
   {
      roData.push_back(static_cast<tS8>(m_uFreezeFrameData.Array[i]));
   }
}

vdl_tuDiaglogFreezeFrameData vdl_tclFreezeFrameDataBase::uGetFreezeFrameData()const
{
   return m_uFreezeFrameData;
}

