/*
 * vd_diaglog_filedir.h
 *
 *  Created on: 28.03.2017
 *      Author: abe6kor
 */

#include <common/framework/vd_diaglog_settings.h>

#include <common/framework/utils/vd_diaglog_filedir.h>


#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_DIAGLOG_INFO
#include "trcGenProj/Header/vd_diaglog_filedir.cpp.trc.h"
#endif

using namespace std;

//-----------------------------------------------------------------------------

vdDiaglog_FileDir::vdDiaglog_FileDir ( tCString dirName, mode_t dirMode )
   : mDirName(dirName), mMode(dirMode)
{
	ETG_TRACE_COMP_THR(( " vdDiaglog_FileDir::vdDiaglog_FileDir(tCString dirName, mode_t dirMode)"));
}

//-----------------------------------------------------------------------------

vdDiaglog_FileDir::~vdDiaglog_FileDir ( void )
{
	ETG_TRACE_COMP_THR(( " vdDiaglog_FileDir::~vdDiaglog_FileDir"));
}

//-----------------------------------------------------------------------------

bool
vdDiaglog_FileDir::createDirIfNotExist ( void )
{
	ETG_TRACE_COMP_THR(( "--> vdDiaglog_FileDir::createDirIfNotExist"));

   bool retCode = true;

   if ( !doesExist() )
   {
	   ETG_TRACE_COMP_THR(( "vdDiaglog_FileDir::createDirIfNotExist dir: %s NOT EXIST!", mDirName.c_str()));
      if ( mkdir(mDirName.c_str(), mMode) != 0 )
      {
    	  ETG_TRACE_ERRMEM(("##### CREATION OF DIRECTORY \"%s\" FAILED !! #####", mDirName.c_str()));
         retCode = false;
      }
      else
      {
         //we need to set the mode again as the umask somehow affect the mode when creating the dir
    	  if ( ::chmod(mDirName.c_str(), mMode) != -1 )
    	  {
    		  ETG_TRACE_COMP_THR(("##### CREATION OF DIRECTORY \"%s\" with correct Permissions SUCCESSFULL !! #####", mDirName.c_str()));
    	  }
      }
   }

   ETG_TRACE_COMP_THR(( "<-- vdDiaglog_FileDir::createDirIfNotExist"));

   return retCode;
}

//-----------------------------------------------------------------------------

bool
vdDiaglog_FileDir::doesExist ( void ) const
{

   bool retCode = false;

   struct stat sb;
   if ( (stat(mDirName.c_str(), &sb) == 0) && S_ISDIR(sb.st_mode) ) retCode = true;

   return retCode;
}
