/*!
* \file       vd_diaglog_CRCCalculator.h
*
* \brief      Used to calculate, verify checksum
*
* \details    Used to calculate, verify checksum
*
* \component  Diaglog
*
* \ingroup    DiaglogUtils
*
* \copyright  (c) 2018 Robert Bosch GmbH
*
* The reproduction, distribution and utilization of this file as
* well as the communication of its contents to others without express
* authorization is prohibited. Offenders will be held liable for the
* payment of damages. All rights reserved in the event of the grant
* of a patent, utility model or design.
*/

#ifndef __VD_DIAGLOG_INCLUDEGUARD_CRC_CALCULATOR__
#define __VD_DIAGLOG_INCLUDEGUARD_CRC_CALCULATOR__

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/vd_diaglog_macros.h"
#endif

enum vdDiaglog_eCRCFormat
{
    DIAGLOG_EN_CRC_FORMAT_UNKNOWN = 0,
    DIAGLOG_EN_CRC_FORMAT_BIG_ENDIAN,
    DIAGLOG_EN_CRC_FORMAT_LITTLE_ENDIAN,
    DIAGLOG_EN_CRC_FORMAT_COUNT
};

class vdDiaglog_CRCCalculator
{
    DECL_SINGLETON_CONSTRUCTOR_AND_DESTRUCTOR(vdDiaglog_CRCCalculator);

public:
    //! class destructor
    virtual ~vdDiaglog_CRCCalculator(void);

    //! calculate CRC (CCITT)
    virtual tU16 calcCrCCITT(const tU8 data[], tU16 length, vdDiaglog_eCRCFormat fmt = DIAGLOG_EN_CRC_FORMAT_BIG_ENDIAN);
    //! calculate CRC (CCITT)
    virtual tU16 calcCrCCITT(const tS8 data[], tU32 length, vdDiaglog_eCRCFormat fmt = DIAGLOG_EN_CRC_FORMAT_BIG_ENDIAN);
    //! calculate CRC (CCITT) and compare with the given crc value
    virtual bool calcAndCompareCrcCCITT(const tU8 data[], tU16 length, tU16 crc, vdDiaglog_eCRCFormat fmt = DIAGLOG_EN_CRC_FORMAT_BIG_ENDIAN);
    //! calculate CRC (CCITT) and compare with the given crc value
    virtual bool calcAndCompareCrcCCITT(const tS8 data[], tU32 length, tU16 crc, vdDiaglog_eCRCFormat fmt = DIAGLOG_EN_CRC_FORMAT_BIG_ENDIAN);

protected:
    //! default constructor
    vdDiaglog_CRCCalculator(void);
};

vdDiaglog_CRCCalculator* getInstanceOfCRCCalculator(void);
void releaseInstanceOfCRCCalculator(void);

#endif /* __VD_DIAGLOG_INCLUDEGUARD_CRC_CALCULATOR__ */