/*!
* \file       vd_diaglog_CRCCalculator.cpp
*
* \brief      Used to calculate, verify checksum
*
* \details    Used to calculate, verify checksum
*
* \component  Diaglog
*
* \ingroup    DiaglogUtils
*
* \copyright  (c) 2018 Robert Bosch GmbH
*
* The reproduction, distribution and utilization of this file as
* well as the communication of its contents to others without express
* authorization is prohibited. Offenders will be held liable for the
* payment of damages. All rights reserved in the event of the grant
* of a patent, utility model or design.
*/

// first include diaglog settings
#include <common/framework/vd_diaglog_settings.h>

#ifndef __VD_DIAGLOG_INCLUDEGUARD_CRC_CALCULATOR__
#include "common/framework/utils/vd_diaglog_CRCCalculator.h"
#endif

#include <boost/crc.hpp>      // for boost::crc_basic, boost::crc_optimal

DIA_IMPL_SINGLETON(vdDiaglog_CRCCalculator)

vdDiaglog_CRCCalculator*
getInstanceOfCRCCalculator(void)
{
    return vdDiaglog_CRCCalculator::getInstance();
}

void
releaseInstanceOfCRCCalculator(void)
{
    return vdDiaglog_CRCCalculator::deleteInstance();
}


//-----------------------------------------------------------------------------

vdDiaglog_CRCCalculator::vdDiaglog_CRCCalculator(void)
{}

//-----------------------------------------------------------------------------

vdDiaglog_CRCCalculator::~vdDiaglog_CRCCalculator(void)
{}

//-----------------------------------------------------------------------------

tU16
vdDiaglog_CRCCalculator::calcCrCCITT(const tU8 data[], tU16 length, vdDiaglog_eCRCFormat fmt)
{
    // boost calculates the CRC in big endian format
    boost::crc_ccitt_type crc_ccitt;
    crc_ccitt.process_bytes(data, length);

    tU16 crc = crc_ccitt.checksum();
    tU16 crcFinal = (fmt == DIAGLOG_EN_CRC_FORMAT_LITTLE_ENDIAN) ? ((tU16)(((crc & 0x00FF) << 8) | ((crc & 0xFF00) >> 8))) : crc;

    return crcFinal;
}

//-----------------------------------------------------------------------------

tU16
vdDiaglog_CRCCalculator::calcCrCCITT(const tS8 data[], tU32 length, vdDiaglog_eCRCFormat fmt)
{
    // boost calculates the CRC in big endian format
    boost::crc_ccitt_type crc_ccitt;
    crc_ccitt.process_bytes(data, length);

    tU16 crc = crc_ccitt.checksum();
    tU16 crcFinal = (fmt == DIAGLOG_EN_CRC_FORMAT_LITTLE_ENDIAN) ? ((tU16)(((crc & 0x00FF) << 8) | ((crc & 0xFF00) >> 8))) : crc;

    return crcFinal;
}

//-----------------------------------------------------------------------------

bool
vdDiaglog_CRCCalculator::calcAndCompareCrcCCITT(const tU8 data[], tU16 length, tU16 crc, vdDiaglog_eCRCFormat fmt)
{

    tU16 crcCalc = calcCrCCITT(data, length, fmt);

    return (crcCalc == crc);

}

//-----------------------------------------------------------------------------

bool
vdDiaglog_CRCCalculator::calcAndCompareCrcCCITT(const tS8 data[], tU32 length, tU16 crc, vdDiaglog_eCRCFormat fmt)
{

    tU16 crcCalc = calcCrCCITT(data, length, fmt);

    return (crcCalc == crc);

}
