//////////////////////////////////////////////////////////////////////////
// FILE:         vd_diaglog_snapshotdata.h
// PROJECT:      Diag Core
// SW-COMPONENT: DiagLog
//----------------------------------------------------------------------
//
// DESCRIPTION: DiagLog Qualification base typename
//              
//----------------------------------------------------------------------
// COPYRIGHT:    (c) 2015 Robert Bosch GmbH, Hildesheim
// HISTORY:      
// Date      | Author                       | Modification
// 16.04.15  | BSOT Plischke                | Initial version
//////////////////////////////////////////////////////////////////////////
#ifndef VD_DIAGLOG_INCLUDEGUARD_vd_diaglog_snapshotdata
#define VD_DIAGLOG_INCLUDEGUARD_vd_diaglog_snapshotdata

#ifndef VD_DIAGLOG_INCLUDEGUARD_vd_diaglog_snapshotDataConfiguration
   #include <common/framework/snapshotData/vd_diaglog_snapshotDataConfiguration.h>
#endif

#ifndef VD_DIAGLOG_INCLUDEGUARD_vd_diaglog_storage_interface
   #include <common/framework/vd_diaglog_storage_interface.h>
#endif

typedef enum
{
   SNAPSHOT_ADDED = 0,
   SNAPSHOT_WAIT_FOR_RESPONSE,
   SNAPSHOT_DATA_RECEIVED
}teDIAGLOG_SNAPSHOT_STATE;

#define DIAGLOG_SNAPSHOTDATA_VERSION_FORMAT  1

///////////////////////////////////////////////////////////////////////////////////
//
// CLASS: SnapshotRecord
//
// DESCRIPTION: this class is for internal communcation, because the request is asyncrone
//
///////////////////////////////////////////////////////////////////////////////////
//
class vdl_tclSnapshotRecord
{
private:
   vdl_tclSnapshotRecord():m_Handle(0xFFFF),m_DTC(0),m_ITC(0),m_memoryID(0),m_RecordId(0),m_DID(0),m_Identifier(0),m_state(SNAPSHOT_ADDED){}; //lint -esym(1704, vdl_tclSnapshotRecord::vdl_tclSnapshotRecord)  // do not use so made as private

public:
   vdl_tclSnapshotRecord(tU32 DTC, tU16 ITC, tU8 memoryID, tU8 recordId, tU16 DID):
      m_DTC(DTC),
      m_ITC(ITC),
      m_memoryID(memoryID),
      m_RecordId(recordId),
      m_DID(DID),
      m_state(SNAPSHOT_ADDED)
   {
      m_Handle = createHandle();
      m_Identifier = calcIdentifier(m_memoryID,m_DTC);
   }

   // this is for load Data
   vdl_tclSnapshotRecord(tU32 identifier, tU8 recordId, tU16 DID, std::vector<tU8> data):
      m_Handle(0xFFFF),
      m_ITC(0),
      m_RecordId(recordId),
      m_DID(DID),
      m_Identifier(identifier),
      m_data(data),
      m_state(SNAPSHOT_DATA_RECEIVED)
   {
      m_DTC = getDtcFromIdentifier(m_Identifier);
      m_memoryID = getMemoryIdFromIdentifier(m_Identifier);
   }
   virtual ~vdl_tclSnapshotRecord(){};

// operations
   tU32 createHandle(void) const                                  {return (m_HandleCounter++);}
   tU32 calcIdentifier(tU8 MemoryID, tU32 DTC)const               {return(((tU32)MemoryID<<24) + (DTC & 0xFFFFFF));}
   tU32 getDtcFromIdentifier(tU32 identifier)const                {return(identifier & 0xFFFFFF);}
   tU8  getMemoryIdFromIdentifier(tU32 identifier)const           {return((tU8)(identifier >> 24));}

// variables
   tU32  m_Handle;
   tU32  m_DTC;
   tU16  m_ITC;
   tU8   m_memoryID;
   tU8   m_RecordId;
   tU16  m_DID;
   tU32  m_Identifier;
   std::vector<tU8> m_data;
   teDIAGLOG_SNAPSHOT_STATE  m_state;
   static tU32 m_HandleCounter;
};

/* List of SnapShot Data to communicate with diagnosis */
typedef std::vector<vdl_tclSnapshotRecord>                    tSnapshotRecordList;
typedef std::vector<vdl_tclSnapshotRecord>::iterator          tSnapshotRecordListIt;  // read/write iterator
typedef std::vector<vdl_tclSnapshotRecord>::const_iterator    tSnapshotRecordListCIt; // read only iterator


///////////////////////////////////////////////////////////////////////////////////
//
// CLASS: vdl_tclSnapShotData
//
// DESCRIPTION: this class holds the SnapShotData
//
///////////////////////////////////////////////////////////////////////////////////
//


typedef std::vector<tU8>                    tSSD_Data;
typedef std::vector<tU8>::iterator          tSSD_DataIt;
typedef std::vector<tU8>::const_iterator    tSSD_DataCIt;

typedef std::map<tU16/*DID*/     , tSSD_Data/*U8 Data Array*/>                  tSSD_DIDMap;
typedef std::map<tU16/*DID*/     , tSSD_Data/*U8 Data Array*/>::iterator        tSSD_DIDMapIt;
typedef std::map<tU16/*DID*/     , tSSD_Data/*U8 Data Array*/>::const_iterator  tSSD_DIDMapCIt;

typedef std::map<tU8 /*RecordNr*/, tSSD_DIDMap           >                      tSSD_RecordMap;
typedef std::map<tU8 /*RecordNr*/, tSSD_DIDMap           >::iterator            tSSD_RecordMapIt;
typedef std::map<tU8 /*RecordNr*/, tSSD_DIDMap           >::const_iterator      tSSD_RecordMapCIt;

typedef std::map<tU32/*ITC*/     , tSSD_RecordMap        >                      tSSD_Map;
typedef std::map<tU32/*ITC*/     , tSSD_RecordMap        >::iterator            tSSD_MapIt;
typedef std::map<tU32/*ITC*/     , tSSD_RecordMap        >::const_iterator      tSSD_MapCIt;


class vdl_tclSnapShotData: public vdl_tclStorageUserInterface
{
public:
   vdl_tclSnapShotData();
   virtual ~vdl_tclSnapShotData();
   void vInit();
   void vClose();
   bool getSnapShotDataByDTC(tU8 MemoryId, tU32 DTC, tU8 recordNumber, tSnapShotDataList& SnapShotDataList, bool isDTCSet);
   bool getSnapShotIdList(tU8 MemoryId, tSnapShotIdList& SnapShotIdList);
   void updateSnapShotDataByRecord(const vdl_tclReportRecord* pRecord,vdl_teDiaglogSnapShotTrigger trigger);
   void copyDataToSnapShot(tU32 handle, tSSD_Data data);
   void traceSnapShotMap(void);
   void clearSnapShotByDTC(tU8 MemoryId, tU32 DTC);
   
   // attributes
   static OSAL_tSemHandle     m_hReportSem;  // m_SnapShotRecordList semaphore

   // vdl_tclStorageUserInterface IF
   virtual tVoid vSave(tStream& roData);
   virtual bool bLoad(tStream& roData);
   virtual tU8 u8GetDataFormatVerision() const {return DIAGLOG_SNAPSHOTDATA_VERSION_FORMAT;}
   virtual tVoid vGetSizeOfLoadBuffer(tS32& Max, tS32& Min);

private:
   // operations
   tU8  getNrOfDIDs(tU8 record){return (m_oSnapShotConfig.getNrOfDIDs(record));}
   tU16 getDID(const tU8 record, tU8 pos){return (m_oSnapShotConfig.getDID(record,pos)& DIAGLOG_FREEZE_FRAME_DATA_TYPE_DID_MASK);}
   tU32 getDIDType(const tU8 record, tU8 pos){return (m_oSnapShotConfig.getDID(record,pos)& DIAGLOG_FREEZE_FRAME_DATA_TYPE_MASK);}

   void create_mainMapMember(tSSD_Map& ITCMap, vdl_tclSnapshotRecord snapshotRecord)const;
   void create_RecordMapMember(tSSD_RecordMap& RecordMap, vdl_tclSnapshotRecord snapshotRecord)const;
   void create_DIDMapMember(tSSD_DIDMap& DIDMap, vdl_tclSnapshotRecord snapshotRecord)const;
   void addToDidMap(tSSD_DIDMap& didMap,vdl_tclSnapshotRecord snapshotRecord)const;
   void addToRecordMap(tSSD_RecordMap& recordMap,vdl_tclSnapshotRecord snapshotRecord)const;
   void requestSnapShotData();
   vdl_tclSnapshotRecord* findSnapshotRecordByHandle(tU32 handle);
   void removeSnapshotRecordByHandle(tU32 handle);
   void copyDidMapToSnapShotData(tSSD_DIDMap& didMap, vdl_tsSnapShotDataStruct& snapShotData)const;
   void addSnapShotData(vdl_tclSnapshotRecord snapshotRecord);

   void LockSnapShotRecordSemaphore() const;
   void FreeSnapShotRecordSemaphore() const;

   void saveDatabase()
   {   
      setModified();
      requestForSaveIfModified();
   }

   // Identifier for map, HINT: use this functions if we switch to ITC instead of DTC
   tU32 calcIdentifier(tU8 MemoryID, tU32 DTC)const               {return(((tU32)MemoryID<<24) + (DTC & 0xFFFFFF));}
   tU32 getDtcFromIdentifier(tU32 identifier)const                {return(identifier & 0xFFFFFF);}
   tU8  getMemoryIdFromIdentifier(tU32 identifier)const           {return((tU8)(identifier >> 24));}
   bool isIdentifierOfMemoryID(tU8 MemoryID, tU32 identifier)const{return(((identifier >> 24)== MemoryID)?true:false);} 

   // virtual
   virtual bool requestSnapShotDataBySnapshotRecord(vdl_tclSnapshotRecord snapshotRecord);

   // attributes
   vdl_tclSnapShotConfig   m_oSnapShotConfig;    // const configuration Data
   tSSD_Map                m_SnapShotDataList;   // map of all SnapShot Data
   tSnapshotRecordList     m_SnapShotRecordList; // communication with diagnosis
};

#endif //VD_DIAGLOG_INCLUDEGUARD_vd_diaglog_snapshotdata
