/*
 * DiaglogService.cpp
 *
 *  Created on: 07.07.2015
 *      Author: gib2hi
 */

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#define OSAL_S_IMPORT_INTERFACE_TYPES
#define OSAL_S_IMPORT_INTERFACE_MEMORY
#include "osal_if.h"

#ifndef VD_DIAGLOG_INCLUDEGUARD_vd_diaglog_main
#include "common/framework/vd_diaglog_main.h"
#endif

#ifndef VD_DIAGLOG_INCLUDEGUARD_vd_diaglog_trace
#include "common/framework/vd_diaglog_trace.h"
#endif

#define  AIL_S_IMPORT_INTERFACE_GENERIC
#include "ail_if.h"

#define SCD_S_IMPORT_INTERFACE_GENERIC
#include "scd_if.h"

#define VD_DIAGLOG_S_IMPORT_INTERFACE_GENERIC
#include "vd_diaglog_if.h"

#include "DiaglogService.h"

#define SYSTEM_S_IMPORT_INTERFACE_UTILITY
#include "stl_pif.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_DIAGLOG_SM
#include "trcGenProj/Header/DiaglogService.cpp.trc.h"
#endif

namespace asf {

//------------------------------------------------------------------------------

DiaglogService::DiaglogService ( void )
   : DiaglogStub("diaglogServerPort"),
     m_pAilApp(0)
{
   et_vTraceOpen();

   if(FALSE == amt_bInit())
   {
      ETG_TRACE_ERR(("!!! DiaglogService::DiaglogService => ERROR: amt_bInit failed"));
   }

   if(FALSE == scd_init())
   {
      ETG_TRACE_ERR(("!!! DiaglogService::DiaglogService => ERROR: scd_init failed"));
   }

   if(FALSE == exh_bInitExceptionHandling()) //lint !e774: Boolean within 'if' always evaluates to False
   {
      ETG_TRACE_ERR(("!!! DiaglogService::DiaglogService => ERROR: exh_bInitExceptionHandling failed"));
   }

   if(scd_bAppRegistryAvailable(CCA_C_U16_APP_DIAGLOG))
   {
      ETG_TRACE_COMP(("--- DiaglogService::DiaglogService => Trying to start CCA_C_U16_APP_DIAGLOG"));

      m_pAilApp = vdDiagLog_tclApp::theServerPrj(this);
      if (m_pAilApp != NULL)
      {
         m_pAilApp->bInitInstance(0, CCA_C_U16_APP_DIAGLOG);
      }
   }
}

//------------------------------------------------------------------------------

DiaglogService::~DiaglogService()
{
   _BP_TRY_BEGIN
   {
      if (m_pAilApp)
      {
         m_pAilApp = NULL;
      }
   }
   _BP_CATCH_ALL
   {
      NORMAL_M_ASSERT_ALWAYS();
   }
   _BP_CATCH_END
}

//------------------------------------------------------------------------------

void
DiaglogService::onSaveTestResultRequest (const ::boost::shared_ptr< SaveTestResultRequest >& request)
{
   ScopedLockSemaphore lock(vdDiagLog_tclApp::m_hASFSem);
   tU16 u16NumTestResults = (uint16_t)request->getTestResultList().size();

   if (u16NumTestResults == 0)
   {
      ETG_TRACE_COMP_THR(("--- asf::DiaglogService::onSaveTestResultRequest => Empty list"));
      sendSaveTestResultResponse(0, request->getAct());
   }
   else
   {
      if (vdDiagLog_tclApp::m_poInstance)
      {
         bool bProcessed = true;

         for (tU16 i = 0; i < u16NumTestResults; i++)
         {
            SaveTestResultRequestTestResultListStruct report = (request->getTestResultList())[i];

            tU32 u32ITC = report.getElem1();
            tU8 u8Result = report.getElem2();

            ETG_TRACE_COMP_THR(("--- asf::DiaglogService::onSaveTestResultRequest => [%d] u32ITC = 0x%04x, u8Result = %d",
                  i, u32ITC, u8Result));

            vdl_teDiaglogReportMsg  enMsgReportStatus = DIAGLOG_REPORT_NONE;
            switch (u8Result)
            {
               case 0: enMsgReportStatus = DIAGLOG_REPORT_PASSED; break;
               case 1: enMsgReportStatus = DIAGLOG_REPORT_FAILED; break;
               case 2: enMsgReportStatus = DIAGLOG_REPORT_NORESULT; break;
               default: enMsgReportStatus = DIAGLOG_REPORT_NONE; break;
            }

            vdl_tsDiaglogTestResult oData;
            oData.u32ITC         = u32ITC;
            oData.u32DTC         = 0;
            oData.bDynamicalDTC  = false;
            oData.eReportStatus  = enMsgReportStatus;
            oData.u32Timestamp   = 0;

            if (vdDiagLog_tclApp::m_poInstance->m_oMemoryMaster.bProcessTestReport(oData) == false)
            {
               bProcessed = false;
            }
         } //for (tU16 i = 0; i < u16NumTestResults; i++)

         if (bProcessed == true)
         {
            sendSaveTestResultResponse(0, request->getAct());
         }
         else
         {
            // at minimum one ITC in the list was invalid
            //sendClearDTCError(...);
            sendSaveTestResultResponse(1, request->getAct());
         }
      } //if (vdDiagLog_tclApp::m_poInstance)
      else
      {
         NORMAL_M_ASSERT_ALWAYS ();
         sendSaveTestResultError(DBUS_ERROR_NO_MEMORY, "vdDiagLog_tclApp::m_poInstance is NULL", request->getAct());
      }
   }
}

//------------------------------------------------------------------------------

void
DiaglogService::onClearDTCRequest (const ::boost::shared_ptr< ClearDTCRequest >& request)
{
   ScopedLockSemaphore lock(vdDiagLog_tclApp::m_hASFSem);
   tU8 u8Group = request->getGroup();
   tU32 u32DTCMask = request->getDTCMask();

   ETG_TRACE_COMP_THR(("--- asf::DiaglogService::onClearDTCRequest => u8Group=%d, u32DTCMask=0x%04x",
         u8Group, u32DTCMask));

   if (vdDiagLog_tclApp::m_poInstance)
   {
      bool bProcessed = vdDiagLog_tclApp::m_poInstance->m_oMemoryMaster.processClearRequest(u8Group, u32DTCMask);
      if (bProcessed == true)
      {
         sendClearDTCResponse(0, request->getAct());
      }
      else
      {
         //sendClearDTCError(...);
         sendClearDTCResponse(1, request->getAct());
      }
   }
   else
   {
      NORMAL_M_ASSERT_ALWAYS ();
      sendClearDTCError(DBUS_ERROR_NO_MEMORY, "vdDiagLog_tclApp::m_poInstance is NULL", request->getAct());
   }
}

//------------------------------------------------------------------------------

} //namespace asf



