/************************************************************************
* FILE:         dia_tclUDS_BD_GetMacAddress.h
* PROJECT:      DIAG Core
* SW-COMPONENT: Diagnostic application
*----------------------------------------------------------------------
*
* DESCRIPTION: Classes for UDS service Get Display Type
*
*----------------------------------------------------------------------
* COPYRIGHT:    (c) 2010 Robert Bosch GmbH, Hildesheim
* HISTORY:
* Date      | Author             | Modification
* 23.09.10  | TMS Plischke       | initial version
*
*************************************************************************/

#ifndef dia_tclUDS_BD_GetMacAddress_H
#define dia_tclUDS_BD_GetMacAddress_H

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include <common/framework/sysadapters/dia_SystemAdapterFacade.h>
#endif

#ifndef __INCLUDED_DIA_SERVICE_HANDLER_UDS__
#include "common/framework/protocols/uds/dia_ServiceHandlerUDS.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_BLUETOOTH_LISTENER__
#include <project/interfaces/dia_IBluetoothListener.h>
#endif

class dia_tclUDS_BD_GetMacAddress : public dia_ServiceHandlerUDS,
                                    public dia_IBluetoothListenerImpl
{
   DECL_DEPRECATED_DEFAULT_CONSTRUCTOR(dia_tclUDS_BD_GetMacAddress);
   DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(dia_tclUDS_BD_GetMacAddress);

 public:
   //! class constructor
   dia_tclUDS_BD_GetMacAddress ( tCString name, tU8 sid, tU16 did );

   //! class destructor
   virtual ~dia_tclUDS_BD_GetMacAddress(void);

   //! method called to start service processing
   virtual void vProcessRequest ( const std::vector<tArgsType>& vecArgs );

   //! Request Handler Function
   virtual void vOnReadMacAddressResult( const tU8* const pu8Result );

   //! Response Handler Function Error
   virtual void vOnReadMacAddressError(const tU32 errCode );
};


#endif

