/************************************************************************
* FILE:         dia_tclUDS_BD_GetBDAddress.h
* PROJECT:      DIAG Core
* SW-COMPONENT: Diagnostic application
*----------------------------------------------------------------------
*
* DESCRIPTION: Classes for UDS service Get Display Type
*
*----------------------------------------------------------------------
* COPYRIGHT:    (c) 2010 Robert Bosch GmbH, Hildesheim
* HISTORY:
* Date      | Author             | Modification
* 23.09.10  | TMS Plischke       | initial version
*
*************************************************************************/

#ifndef dia_tclUDS_BD_GetBDAddress_H
#define dia_tclUDS_BD_GetBDAddress_H

#ifndef __INCLUDED_DIA_COMMON_PROTOCOLS_UDS__
#include "common/framework/protocols/uds/dia_common_uds.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_BLUETOOTH_LISTENER__
#include <project/interfaces/dia_IBluetoothListener.h>
#endif

class dia_tclUDS_BD_GetBDAddress : public dia_ServiceHandlerUDS,
                                   public dia_IBluetoothListenerImpl
{
   DECL_DEPRECATED_DEFAULT_CONSTRUCTOR(dia_tclUDS_BD_GetBDAddress);
   DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(dia_tclUDS_BD_GetBDAddress);

  public:
   //! class constructor
   dia_tclUDS_BD_GetBDAddress ( tCString name, tU8 sid, tU16 did );

   //! class destructor
   virtual ~dia_tclUDS_BD_GetBDAddress(tVoid);

   virtual tVoid vProcessRequest ( const std::vector<tArgsType>& vecArgs );

   virtual tVoid vOnReadBDAddressResult( const tU8* const pu8Result );
   virtual tVoid vOnReadBDAddressError(const tU32 errCode );
};
#endif

