/*
 * dia_SrvHandler_ReadInputHdlPressedKeyPrj.cpp
 *
 *  Created on: Jul 11, 2019
 *      Author: hgr6kor
 */

// TTFis:\> DIA_REQ UDS 03 22 62 30

#ifndef DIA_SRVHANDLER_READINPUTHDLPRESSEDKEYPRJ_H_
#include "dia_SrvHandler_ReadInputHdlPressedKeyPrj.h"
#endif

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif
#ifndef __INCLUDED_DIA_DEFINES_UDS__
#include <common/framework/protocols/uds/dia_defsUds.h>
#endif
#ifndef __INCLUDED_DIA_DEFS_COMMON__
#include "common/framework/application/dia_defsCommon.h"
#endif

#ifndef __INCLUDED_DIA_IOCTRL_INPUT_HDL_PRESSED_KEY_PRJ_H__
#include "dia_IOCtrlInputHdlPressedKeyPrj.h"
#endif
#define DATA_START 3
#define DATA_LENGTH 2



//-----------------------------------------------------------------------------

dia_SrvHandler_ReadInputHdlPressedKeyPrj::dia_SrvHandler_ReadInputHdlPressedKeyPrj ( void )
    : dia_ServiceHandlerUDS("dia_SrvHandler_ReadInputHdlPressedKeyPrj",
	  DIA_C_U8_UDS_SID_READ_DATA_BY_IDENTIFIER,
	  (tU16) DIA_C_U16_DID_RBCM_INPUT_HDL_KEY_PRESSED /*DID*/ )
{
   dia_tclFnctTrace trc("dia_SrvHandler_ReadInputHdlPressedKeyPrj::dia_SrvHandler_ReadInputHdlPressedKeyPrj(void)");
}

//-----------------------------------------------------------------------------

dia_SrvHandler_ReadInputHdlPressedKeyPrj::~dia_SrvHandler_ReadInputHdlPressedKeyPrj ( void )
{
    _BP_TRY_BEGIN
    {
       (void) unsetSysAdapterListener<dia_IInputHandlingPrjListener>(this);
    }
    _BP_CATCH_ALL
    {
        DIA_TR_ERR("EXCEPTION CAUGHT: dia_SrvHandler_ReadInputHdlPressedKeyPrj::~dia_SrvHandler_ReadInputHdlPressedKeyPrj !!!");
        NORMAL_M_ASSERT_ALWAYS();
    }
    _BP_CATCH_END
}

//-------------------------------------------------------------------------------

void
dia_SrvHandler_ReadInputHdlPressedKeyPrj::vProcessRequest ( const std::vector<tArgsType>& /*vecArgs*/ )
{
   dia_tclFnctTrace trc("dia_SrvHandler_ReadInputHdlPressedKeyPrj::vProcessRequest");

   tBool errorDetected = TRUE;

   dia_IInputHandlingPrj* pInterface = 0;
   if ( querySysAdapterInterface<dia_IInputHandlingPrj>(&pInterface) == DIA_SUCCESS )
   {
   	  DIA_TR_INF("dia_SrvHandler_ReadInputHdlPressedKeyPrj::vProcessRequest - querySysAdapterInterface OK");
      if ( pInterface )
      {
      	(void) setSysAdapterListener<dia_IInputHandlingPrjListener>(this);
         if ( pInterface->getPressedKeys () == DIA_SUCCESS )
         {
            errorDetected = FALSE;
         }
		 else
		 {
         	DIA_TR_INF("dia_SrvHandler_ReadInputHdlPressedKeyPrj::vProcessRequest - getPressedKeys() failed.");
         }
      }
   }
   else
   {
   	  DIA_TR_INF("dia_SrvHandler_ReadInputHdlPressedKeyPrj::vProcessRequest - querySysAdapterInterface NOK !");
   }

   if ( errorDetected )
   {
      (void) unsetSysAdapterListener<dia_IInputHandlingPrjListener>(this);
      DIA_TR_ERR(" ---  SEND TO KEYBOARD SERVER FAILED!!!!");
      vSendNegativeResponse(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
   }
}

//-----------------------------------------------------------------------------

void
dia_SrvHandler_ReadInputHdlPressedKeyPrj::vOnGetPressedKey ( const std::vector<tU8> pressedKeys )
{
   dia_tclFnctTrace trc("dia_SrvHandler_ReadInputHdlPressedKeyPrj:vOnGetPressedKey");

   (void) unsetSysAdapterListener<dia_IInputHandlingPrjListener>(this);

   // Sending back the positive answer
   oDiagMsgBuffer().vSetPosResp();
   oDiagMsgBuffer().vSetDataLength(DATA_START + DATA_LENGTH);

   tU16 u16Size = (tU16) pressedKeys.size();
   tU16 internalKey;
   if (u16Size > 0)
   {
      internalKey = getInpHndlKeyCode(pressedKeys[0]);
      DIA_TR_INF("dia_SrvHandler_ReadInputHdlPressedKeyPrj::vOnGetPressedKey KeyCode = %2d", internalKey);
   }
   else
   {
      internalKey = 0xFFFF;
      DIA_TR_INF("dia_SrvHandler_ReadInputHdlPressedKeyPrj::vOnGetPressedKey No Key Pressed KeyCode = %2d", internalKey);
   }

   (void) oDiagMsgBuffer().vSetDataU8(DATA_START, (tU8) (internalKey >> 8));
   (void) oDiagMsgBuffer().vSetDataU8(DATA_START+1, (tU8) internalKey);

   (void) unsetSysAdapterListener<dia_IInputHandlingPrjListener>(this);
   vResReadyAndQuit();
}
//-----------------------------------------------------------------------------
/******************************************************************************
* FUNCTION:    vOnGetPressedKeyError
*
* DESCRIPTION: Handle the error and unset the InputHandlingListener
*
* PARAMETER:    none
			    none
*
* RETURNVALUE: none
*              none
*
******************************************************************************/
void
dia_SrvHandler_ReadInputHdlPressedKeyPrj::vOnGetPressedKeyError( void )
{
	(void) unsetSysAdapterListener<dia_IInputHandlingPrjListener>(this);
	DIA_TR_ERR(" ---  SEND TO KEYBOARD SERVER FAILED!!!!");
	vSendNegativeResponse(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
}
//-----------------------------------------------------------------------------

tU16
dia_SrvHandler_ReadInputHdlPressedKeyPrj::getInpHndlKeyCode ( tU8 KeyCode )
{
	 dia_tclFnctTrace trc("dia_SrvHandler_ReadInputHdlPressedKeyPrj::geInpHndlKeyCode");
	 tU16 tU16Keycode = 0xFFFF;
	  switch(KeyCode)
	  {
			case DIA_PRJ_KEY_CODE_INPUT_INF4CV_MCP_HOME_COCKPIT:
				tU16Keycode = DIA_KEYCODE_INPUT_INF4CV_MCP_HOME_COCKPIT;
				 break;
			case DIA_PRJ_KEY_CODE_INPUT_INF4CV_MCP_SRC_COCKPIT:
				tU16Keycode = DIA_KEYCODE_INPUT_INF4CV_MCP_SRC_COCKPIT;
				 break;
			case DIA_PRJ_KEY_CODE_INPUT_INF4CV_MCP_NAV:
				tU16Keycode = DIA_KEYCODE_INPUT_INF4CV_MCP_NAV;
				 break;
			case DIA_PRJ_KEY_CODE_INPUT_INF4CV_MCP_MAP:
				tU16Keycode= DIA_KEYCODE_INPUT_INF4CV_MCP_MAP;
				 break;
			case DIA_PRJ_KEY_CODE_INPUT_INF4CV_MCP_SRC_CABIN:
				tU16Keycode = DIA_KEYCODE_INPUT_INF4CV_MCP_SRC_CABIN;
				 break;
			case DIA_PRJ_KEY_CODE_INPUT_INF4CV_MCP_HOME_CABIN:
				tU16Keycode = DIA_KEYCODE_INPUT_INF4CV_MCP_HOME_CABIN;
				 break;
			case DIA_PRJ_KEY_CODE_INPUT_INF4CV_MCP_SET_COCKPIT:
				tU16Keycode = DIA_KEYCODE_INPUT_INF4CV_MCP_SET_COCKPIT;
				 break;
			case DIA_PRJ_KEY_CODE_INPUT_INF4CV_MCP_CAM:
				tU16Keycode = DIA_KEYCODE_INPUT_INF4CV_MCP_CAM;
				 break;
			case DIA_PRJ_KEY_CODE_INPUT_INF4CV_MCP_PHONE_ACCEPT:
				tU16Keycode = DIA_KEYCODE_INPUT_INF4CV_MCP_PHONE_ACCEPT;
				 break;
			case DIA_PRJ_KEY_CODE_INPUT_INF4CV_MCP_PHONE_REJECT:
				tU16Keycode = DIA_KEYCODE_INPUT_INF4CV_MCP_PHONE_REJECT;
				 break;
			case DIA_PRJ_KEY_CODE_INPUT_INF4CV_MCP_MON:
				tU16Keycode = DIA_KEYCODE_INPUT_INF4CV_MCP_MON;
				 break;
            case DIA_PRJ_KEY_CODE_INPUT_INF4CV_MCP_SET_CABIN:
            	tU16Keycode = DIA_KEYCODE_INPUT_INF4CV_MCP_SET_CABIN;
				 break;
			case DIA_PRJ_KEY_CODE_INPUT_ENCODER_KEY_INF4CV_VOLUMEBUTTON_COCKPIT:
				tU16Keycode = DIA_KEYCODE_INPUT_ENCODER_KEY_INF4CV_VOLUMEBUTTON_COCKPIT;
				break;
			case DIA_PRJ_KEY_CODE_INPUT_ENCODER_KEY_INF4CV_VOLUMEBUTTON_CABIN:
				tU16Keycode = DIA_KEYCODE_INPUT_ENCODER_KEY_INF4CV_VOLUMEBUTTON_CABIN;
				break;
			case DIA_PRJ_KEY_CODE_POWER:
				tU16Keycode = DIA_KEYCODE_INPUT_INF4CV_MCP_POWER;
				break;
			case DIA_PRJ_KEY_CODE_POWER_LONGPRESS:
				tU16Keycode = DIA_KEYCODE_INPUT_INF4CV_MCP_POWER_LONG;
				break;
			default:
				DIA_TR_INF("No valid value has supplied");
				break;
	}

	 DIA_TR_INF("dia_SrvHandler_ReadInputHdlPressedKeyPrj::geInpHndlKeyCode - Code=0x%x  ,KeyID=0x%x",KeyCode,tU16Keycode);
	 return tU16Keycode;
 }
