/**
 * @file   : dia_SrvHandler_AuxIn_Get.h
 * @author : bsu9kor
 * @date   : Aug 1, 2016
 * @brief  : Read the status of the Aux-In Detect Plug and the Detect Plug Diag GPIO.
 * @copyright (c) 2016 Robert Bosch Car Multimedia Gmbh
 * @addgroup : Diagnosis
 * @{
 */

#ifndef DIA_SRVHANDLER_AUXIN_GET_H_
#define DIA_SRVHANDLER_AUXIN_GET_H_

#ifndef __INCLUDED_DIA_COMMON_PROTOCOLS_UDS__
#include "common/framework/protocols/uds/dia_common_uds.h"
#endif


#ifndef __INCLUDED_DIA_SERVICE_HANDLER_UDS__
#include "common/framework/protocols/uds/dia_ServiceHandlerUDS.h"
#endif

#ifndef __INCLUDED_DIA_DEFS_CONFIG_PROJECT__
#include "project/framework/config/dia_defsProjectConfig.h"
#endif

class dia_SrvHandler_AuxIn_Get
: public dia_ServiceHandlerUDS
{
	DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(dia_SrvHandler_AuxIn_Get);
public:

	   //! class constructor
		dia_SrvHandler_AuxIn_Get ( void );

	   //! handle the received request
	   virtual void vProcessRequest ( const std::vector<void*>& vecArgs );
protected:

	   //! class destructor
	   virtual ~dia_SrvHandler_AuxIn_Get ( void );
	   //! Get Property Details
	   tDiaResult getPropertyDetails( tU32 PropID);
	   //!Property data
	   tU8 mPropData;

};

#endif /* ifndef DIA_SRVHANDLER_AUXIN_GET_H_ */
