/*
 * dia_RoutineCtrlGenerateCSR.cpp
 *
 *  Created on: 09.12.2016
 *      Author: stc2hi
 */

#ifndef __INCLUDED_DIA_ROUTINE_CTRL_GENERATE_CSR__
#include <project/services/production/dia_RoutineCtrlGenerateCSR.h>
#endif

#ifndef __INCLUDED_DIA_ROUTINE_CONTROL_MANAGER__
#include <common/framework/protocols/uds/rtctrl/dia_RoutineCtrlManager.h>
#endif

#ifndef __INCLUDED_DIA_FILE__
#include <common/framework/application/dia_File.h>
#endif

#ifndef __INCLUDED_DIA_DEFS_CONFIG__
#include "common/framework/config/dia_defsConfig.h"
#endif

#ifndef __INCLUDED_DIA_CONFIG_MANAGER__
#include "common/framework/config/dia_ConfigManager.h"
#endif

#include <sys/wait.h> //lint !e451 !e537 repeatedly included header file without standard include guard

static const std::string fullCmdName         ("/bin/bash");
static const std::string scriptFilePathName  ("/opt/bosch/security/PartAuthentication/Scripts/genCSR.sh");
static const std::string csrFilePathName     ("/tmp/partAuth/csr/tt_ams_csr.pem");


//---------------------------------------------------------------------------------------------------------------------

dia_RoutineCtrlGenerateCSR::dia_RoutineCtrlGenerateCSR(void)
   : RoutineCtrlExecuteSystemCommand("Routine for GenerateCSR", DIA_C_U16_ID_RTCTRL_GENERATE_CSR, fullCmdName)
{
   dia_tclFnctTrace oTrace("dia_RoutineCtrlGenerateCSR::dia_RoutineCtrlGenerateCSR");
}

//---------------------------------------------------------------------------------------------------------------------

dia_RoutineCtrlGenerateCSR::~dia_RoutineCtrlGenerateCSR ( void )
{
   _BP_TRY_BEGIN
   {
      (void) dia_RoutineCtrlGenerateCSR::tearDown();
   }
   _BP_CATCH_ALL
   {
      DIA_TR_ERR("dia_RoutineCtrlGenerateCSR::~dia_RoutineCtrlGenerateCSR - Exception caught!");
      DIA_ASSERT_ALWAYS();
   }
   _BP_CATCH_END
}

//-----------------------------------------------------------------------------

void
dia_RoutineCtrlGenerateCSR::vOnServiceTimeout ( void )
{
   dia_tclFnctTrace oTrace("dia_RoutineCtrlGenerateCSR::vOnServiceTimeout()");
}

//------------------------------------------------------------------------------

tDiaResult
dia_RoutineCtrlGenerateCSR::getCommandArguments ( std::vector<std::string>& argv )
{
   dia_tclFnctTrace oTrace("dia_RoutineCtrlGenerateCSR::getCommandArguments");

   std::string param;
   std::vector<tU8> naviUnitID;

   if (DIA_SUCCESS == dia_getProperty(DIA_PROP_CM_NAVI_UNIT, naviUnitID))
   {
     param.insert(param.end(), naviUnitID.begin(), naviUnitID.end());
   }

   argv.push_back(scriptFilePathName);
   argv.push_back(param);


   return DIA_SUCCESS;
}

//-----------------------------------------------------------------------------

void
dia_RoutineCtrlGenerateCSR::startSystemCommand ( void )
{
   dia_tclFnctTrace oTrace("dia_RoutineCtrlGenerateCSR::startSystemCommand()");

   mResponseStatus = ROUTINE_NOK;

   DIA_TR_INF("dia_RoutineCtrlGenerateCSR::startSystemCommand => fork now !!");
   mChildProcessID = ::fork();

   if ( mChildProcessID == 0 ) // at this point we are running in the child process
   {
      std::vector<const char*> cargv;
      for (unsigned i = 0; i < mSystemCommandArgs.size(); i++)
      {
         cargv.push_back(mSystemCommandArgs[i].c_str());
      }
      cargv.push_back(NULL);
      // Create new process group with child as leader.
      if ( ::setpgid(0,0) < 0 ) exit(EXIT_FAILURE);
      (void) ::execv(mFullCommandName.c_str(),const_cast<char**>(cargv.data()));

      // otherwise exit failed
      ::exit(EXIT_FAILURE);
   }
   else if ( mChildProcessID > 0 ) // at this point we are running in the parent process
   {
      // check status of child process
      int status = -1;
      pid_t cpid = ::waitpid(mChildProcessID, &status, 0);

      DIA_TR_INF("dia_RoutineCtrlGenerateCSR::startSystemCommand => Child Running Id: %d, cpid: %d", mChildProcessID, cpid);

      int response = WIFEXITED (status);
      DIA_TR_INF("dia_RoutineCtrlGenerateCSR::startSystemCommand => Child WIFEXITED code: %d", response);
      if ( response != 0 )
      {
         // terminated normally
         response = WEXITSTATUS (status);
         DIA_TR_INF("dia_RoutineCtrlGenerateCSR::startSystemCommand => Child WEXITSTATUS code: %d",response);

         if (DIA_SUCCESS == evaluateCommandResponse(response))
         {
            mResponseStatus = ROUTINE_OK;
         }
      }

      mChildProcessID = 0;
      mIsRunning = false;
      mIsResultReady  = TRUE;
   }
   else
   {
      DIA_TR_ERR("dia_RoutineCtrlGenerateCSR::startSystemCommand => fork failed");
   }
}

//------------------------------------------------------------------------------

tDiaResult dia_RoutineCtrlGenerateCSR::evaluateCommandResponse ( int exitCode )
{
   dia_tclFnctTrace oTrace("dia_RoutineCtrlGenerateCSR::evaluateCommandResponse()");

   tDiaResult result = DIA_FAILED;

   if (exitCode == 0)
   {
      dia_File csrFile(csrFilePathName);
      if ((csrFile.doesExist()) && (DIA_SUCCESS == csrFile.open("r")))
      {
         while (!csrFile.endOfFile())
         {
            std::string line;
            (void) csrFile.getLine(line);
            mResults.insert(mResults.end(), line.begin(), line.end());
         }
         (void) csrFile.close();

         result = DIA_SUCCESS;
      }
   }

   return result;
}

//------------------------------------------------------------------------------

