/*
 * dia_RoutineCtrlCertificateStoring.cpp
 *
 *  Created on: 09.12.2016
 *      Author: abe6kor
 */

#ifndef __INCLUDED_DIA_ROUTINE_CTRL_GENERATE_KEY_PAIR__
#include <project/services/production/dia_RoutineCtrlCertificateStoring.h>
#endif

#ifndef __INCLUDED_DIA_ROUTINE_CONTROL_MANAGER__
#include <common/framework/protocols/uds/rtctrl/dia_RoutineCtrlManager.h>
#endif

#ifndef __INCLUDED_DIA_FILE__
#include <common/framework/application/dia_File.h>
#endif

#ifndef __INCLUDED_DIA_DEFS_CONFIG__
#include "common/framework/config/dia_defsConfig.h"
#endif

#ifndef __INCLUDED_DIA_CONFIG_MANAGER__
#include "common/framework/config/dia_ConfigManager.h"
#endif

#include <sys/wait.h> //lint !e451 !e537 repeatedly included header file without standard include guard

static const std::string fullCmdName         ("/bin/bash");
static const std::string scriptFilePathName  ("/opt/bosch/security/PartAuthentication/Scripts/validateCert.sh");


namespace dia
{

//---------------------------------------------------------------------------------------------------------------------

dia_RoutineCtrlCertificateStoring::dia_RoutineCtrlCertificateStoring(void)
   : RoutineCtrlExecuteSystemCommand("RoutineCtrlCertificateStoring", DIA_C_U16_ID_RTCTRL_CERTIFICATE_STORING, fullCmdName)
{
   dia_tclFnctTrace oTrace("dia::dia_RoutineCtrlCertificateStoring::dia_RoutineCtrlCertificateStoring");
}

//---------------------------------------------------------------------------------------------------------------------

dia_RoutineCtrlCertificateStoring::~dia_RoutineCtrlCertificateStoring ( void )
{
   _BP_TRY_BEGIN
   {
      (void) dia_RoutineCtrlCertificateStoring::tearDown();
   }
   _BP_CATCH_ALL
   {
      DIA_TR_ERR("dia::dia_RoutineCtrlCertificateStoring::~dia_RoutineCtrlCertificateStoring - Exception caught!");
      DIA_ASSERT_ALWAYS();
   }
   _BP_CATCH_END
}

//-----------------------------------------------------------------------------

void
dia_RoutineCtrlCertificateStoring::vOnServiceTimeout ( void )
{
   dia_tclFnctTrace oTrace("dia_RoutineCtrlCertificateStoring::vOnServiceTimeout()");
}

//------------------------------------------------------------------------------

tDiaResult
dia_RoutineCtrlCertificateStoring::getCommandArguments ( std::vector<std::string>& argv )
{
   dia_tclFnctTrace oTrace("dia::dia_RoutineCtrlCertificateStoring::getCommandArguments");

   argv.push_back(scriptFilePathName);

   return DIA_SUCCESS;
}

//-----------------------------------------------------------------------------

void
dia_RoutineCtrlCertificateStoring::startSystemCommand ( void )
{
   dia_tclFnctTrace oTrace("dia_RoutineCtrlCertificateStoring::startSystemCommand()");

   mResponseStatus = ROUTINE_NOK;

   DIA_TR_INF("dia_RoutineCtrlCertificateStoring::startSystemCommand => fork now !!");
   mChildProcessID = ::fork();

   if ( mChildProcessID == 0 ) // at this point we are running in the child process
   {
      std::vector<const char*> cargv;
      for (unsigned i = 0; i < mSystemCommandArgs.size(); i++)
      {
         cargv.push_back(mSystemCommandArgs[i].c_str());
      }
      cargv.push_back(NULL);
      // Create new process group with child as leader.
      if ( ::setpgid(0,0) < 0 ) exit(EXIT_FAILURE);
      (void) ::execv(mFullCommandName.c_str(),const_cast<char**>(cargv.data()));

      // otherwise exit failed
      ::exit(EXIT_FAILURE);
   }
   else if ( mChildProcessID > 0 ) // at this point we are running in the parent process
   {
      // check status of child process
      int status = -1;
      pid_t cpid = ::waitpid(mChildProcessID, &status, 0);

      DIA_TR_INF("dia_RoutineCtrlCertificateStoring::startSystemCommand => Child Running Id: %d, cpid: %d", mChildProcessID, cpid);

      int response = WIFEXITED (status);
      DIA_TR_INF("dia_RoutineCtrlCertificateStoring::startSystemCommand => Child WIFEXITED code: %d", response);
      if ( response != 0 )
      {
         // terminated normally
         response = WEXITSTATUS (status);
         DIA_TR_INF("dia_RoutineCtrlCertificateStoring::startSystemCommand => Child WEXITSTATUS code: %d",response);

      //   if (DIA_SUCCESS == evaluateCommandResponse(response))
         if (DIA_SUCCESS == response)
         {
            mResponseStatus = ROUTINE_OK;
         }
      }

      mChildProcessID = 0;
      mIsRunning = false;
      mIsResultReady  = TRUE;
   }
   else
   {
      DIA_TR_ERR("dia_RoutineCtrlCertificateStoring::startSystemCommand => fork failed");
   }
}
}
