/*
 * dia_RoutineCtrlAIVICalculateConfigFingerprint.cpp
 *
 *  Created on: 22.10.2015
 *      Author: shw2abt
 */

#ifndef __INCLUDED_DIA_COMMON_CONFIG__
#include "common/framework/config/dia_common_config.h"
#endif

#ifndef __INCLUDED_DIA_UTILITIES__
#include "common/framework/utils/dia_utilities.h"
#endif

#ifndef __INCLUDED_DIA_COMMON_UDS_RTCTRL__
#include "common/framework/protocols/uds/rtctrl/dia_common_uds_rtctrl.h"
#endif

#ifndef __INCLUDED_DIA_DEFS_CONFIG__
#include "common/framework/config/dia_defsConfig.h"
#endif

#ifndef __INCLUDED_DIA_DEFS_CONFIG_PROJECT__
#include "project/framework/config/dia_defsProjectConfig.h"
#endif

// include own class
#ifndef __INCLUDED_DIA_ROUTINE_CTRL_AIVI_CALCULATE_CONFIG_FINGERPRINT__
#include "dia_RoutineCtrlAIVICalculateConfigFingerprint.h"
#endif

//------------------------------------------------------------------------------

dia_RoutineCtrlAIVICalculateConfigFingerprint::dia_RoutineCtrlAIVICalculateConfigFingerprint (tCString name, tU16 udsID)
   : dia::RoutineCtrlGenericCalculateConfigFingerprint(name, udsID),
     mDIDAIVI (udsID)
{
   dia_tclFnctTrace oTrace("dia_RoutineCtrlAIVICalculateConfigFingerprint::dia_RoutineCtrlAIVICalculateConfigFingerprint(tCString,tU16)");
}

//------------------------------------------------------------------------------

dia_RoutineCtrlAIVICalculateConfigFingerprint::~dia_RoutineCtrlAIVICalculateConfigFingerprint ( void )
{
}

//------------------------------------------------------------------------------

tDiaResult
dia_RoutineCtrlAIVICalculateConfigFingerprint::start ( std::vector<tU8>& params, tU8 timerValue )
{
   dia_tclFnctTrace oTrace("dia_RoutineCtrlAIVICalculateConfigFingerprint::start()");
   tDiaResult retCode = DIA_FAILED;

   // Switch between fingerprints according DID and active set (aka scope)
   if(dia_getPropertySize(DIA_PROP_AIVI_VARIANT_CODING)==DIA_AIVI_VARIANT_CODING_LENGTH){
      tU8 aiviVariantCoding[DIA_AIVI_VARIANT_CODING_LENGTH] = { 0 };
      tDiaResult getPropRes = dia_getProperty(DIA_PROP_AIVI_VARIANT_CODING, aiviVariantCoding, DIA_AIVI_VARIANT_CODING_LENGTH);
      if (getPropRes == DIA_SUCCESS) {
         tU8 currentSet = (aiviVariantCoding[0] & 0xF0) >> 4;
         DIA_TR_INF("dia_RoutineCtrlAIVICalculateConfigFingerprint::start Current Set = 0x%02x .", currentSet);
         // load respective fingerprint
         switch(mDIDAIVI){
            case DIA_C_U16_DID_RBCM_CUSTOMER_CONFIG_FINGERPRINT: {
               DIA_TR_INF("dia_RoutineCtrlAIVICalculateConfigFingerprint::start CUSTOMER_CONFIG_FINGERPRINT (0x%04x) .", mDIDAIVI);
               switch(currentSet){
                  case 1:
                     DIA_TR_INF("dia_RoutineCtrlAIVICalculateConfigFingerprint::start Set 1 copied to routine .");
                     retCode = dia::RoutineCtrlGenericCalculateConfigFingerprint::loadFingerprintInfo ( aCustomerFingerprintData_Set1, sizeof(aCustomerFingerprintData_Set1)/sizeof(dia_FingerprintInfo) );
                     break;
                  case 2:
                     DIA_TR_INF("dia_RoutineCtrlAIVICalculateConfigFingerprint::start Set 2 copied to routine .");
                     retCode = dia::RoutineCtrlGenericCalculateConfigFingerprint::loadFingerprintInfo ( aCustomerFingerprintData_Set2, sizeof(aCustomerFingerprintData_Set2)/sizeof(dia_FingerprintInfo) );
                     break;
                  default:
                     DIA_TR_INF("dia_RoutineCtrlAIVICalculateConfigFingerprint::start Set 1 copied to routine .");
                     retCode = dia::RoutineCtrlGenericCalculateConfigFingerprint::loadFingerprintInfo ( aCustomerFingerprintData_Set1, sizeof(aCustomerFingerprintData_Set1)/sizeof(dia_FingerprintInfo) );
                     break;
               }
            }
               break;
            case DIA_C_U16_DID_RBCM_CUSTOMER_DEF_CONFIG_FINGERPRINT: {
               DIA_TR_INF("dia_RoutineCtrlAIVICalculateConfigFingerprint::start CUSTOMER_DEF_CONFIG_FINGERPRINT (0x%04x) .", mDIDAIVI);
               switch(currentSet){
                  case 1:
                     DIA_TR_INF("dia_RoutineCtrlAIVICalculateConfigFingerprint::start Set 1 copied to routine .");
                     retCode = dia::RoutineCtrlGenericCalculateConfigFingerprint::loadFingerprintInfo ( aCustomerDefaultFingerprintData_Set1, sizeof(aCustomerDefaultFingerprintData_Set1)/sizeof(dia_FingerprintInfo) );
                     break;
                  case 2:
                     DIA_TR_INF("dia_RoutineCtrlAIVICalculateConfigFingerprint::start Set 2 copied to routine .");
                     retCode = dia::RoutineCtrlGenericCalculateConfigFingerprint::loadFingerprintInfo ( aCustomerDefaultFingerprintData_Set2, sizeof(aCustomerDefaultFingerprintData_Set2)/sizeof(dia_FingerprintInfo) );
                     break;
                  default:
                     DIA_TR_INF("dia_RoutineCtrlAIVICalculateConfigFingerprint::start Set 1 copied to routine .");
                     retCode = dia::RoutineCtrlGenericCalculateConfigFingerprint::loadFingerprintInfo ( aCustomerDefaultFingerprintData_Set1, sizeof(aCustomerDefaultFingerprintData_Set1)/sizeof(dia_FingerprintInfo) );
                     break;
               }
            }
               break;
            default:
               DIA_TR_INF("dia_RoutineCtrlAIVICalculateConfigFingerprint::start DID 0x%04x not covered !", mDIDAIVI);
               break;
         }
      } else {
         DIA_TR_INF("dia_RoutineCtrlAIVICalculateConfigFingerprint::start =======================================");
         DIA_TR_INF("dia_RoutineCtrlAIVICalculateConfigFingerprint::start PROP_AIVI_VARIANT_CODING NOT READABLE !");
         DIA_TR_INF("dia_RoutineCtrlAIVICalculateConfigFingerprint::start GO TO DEFAULT SET 1                   !");
         DIA_TR_INF("dia_RoutineCtrlAIVICalculateConfigFingerprint::start =======================================");
         switch (mDIDAIVI) {
            case DIA_C_U16_DID_RBCM_CUSTOMER_CONFIG_FINGERPRINT: {
               DIA_TR_INF("dia_RoutineCtrlAIVICalculateConfigFingerprint::start CUSTOMER_CONFIG_FINGERPRINT (0x%04x) .", mDIDAIVI);
               DIA_TR_INF("dia_RoutineCtrlAIVICalculateConfigFingerprint::start Set 1 copied to routine .");
               retCode = dia::RoutineCtrlGenericCalculateConfigFingerprint::loadFingerprintInfo(aCustomerFingerprintData_Set1, sizeof(aCustomerFingerprintData_Set1) / sizeof(dia_FingerprintInfo));
            }
               break;
            case DIA_C_U16_DID_RBCM_CUSTOMER_DEF_CONFIG_FINGERPRINT: {
               DIA_TR_INF("dia_RoutineCtrlAIVICalculateConfigFingerprint::start CUSTOMER_DEF_CONFIG_FINGERPRINT (0x%04x) .", mDIDAIVI);
               DIA_TR_INF("dia_RoutineCtrlAIVICalculateConfigFingerprint::start Set 1 copied to routine .");
               retCode = dia::RoutineCtrlGenericCalculateConfigFingerprint::loadFingerprintInfo(aCustomerDefaultFingerprintData_Set1, sizeof(aCustomerDefaultFingerprintData_Set1) / sizeof(dia_FingerprintInfo));
               break;
            default:
               DIA_TR_INF("dia_RoutineCtrlAIVICalculateConfigFingerprint::start DID 0x%04x not covered !", mDIDAIVI);
               break;
            }
         }
      }
   }

   // check if fingerprint loaded successfully
   if(retCode==DIA_SUCCESS){  //lint !e774 retCode will be set with loadFingerprintInfo
      DIA_TR_INF("dia_RoutineCtrlAIVICalculateConfigFingerprint::start new fingerprint data loaded.");
   } else {
      DIA_TR_ERR("dia_RoutineCtrlAIVICalculateConfigFingerprint::start ERROR in loading fingerprint data !");
   }

   // execute standard fingerprint calculation
   retCode = dia::RoutineCtrlGenericCalculateConfigFingerprint::start(params, timerValue);

   return retCode;
}
