/*
 * dia_IOCtrlHMILanguage_set.h
 *
 *  Created on: 16.12.2015
 *      Author: bsu9kor
 *      -----------------------------------------------------------------------------------------------------------------------
 *      Date        Author	    Modification
 *      22.12.2015  bsu9kor		Added enum changes fron DIA_EN_CM_LANGUAGE to DIA_EN_NISSAN_LANGUAGE
 *
 *      ---------------------------------------------------------------------------------------------------------------------
 */

#ifndef __INCLUDED_DIA_IOCTRL_HMI_LANGUAGE_SET__
#define __INCLUDED_DIA_IOCTRL_HMI_LANGUAGE_SET__

#ifndef __INCLUDED_DIA_IOCTRL_SIGNAL_RESTRICTED_TO_REMOTE_CONTROL__
#include "common/framework/protocols/uds/ioctrl/dia_IOCtrlSignalRestrictedToRemoteControl.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_NISSANLANGUAGE_LISTENER__
#include "project/interfaces/dia_INissanLanguageListener.h"
#endif

////////////////////////////////////////////////////////////////////////////////
//
//
//
////////////////////////////////////////////////////////////////////////////////

class dia_IOCtrlHMILanguage_set
   : public dia_IOCtrlSignal,
     public dia_INissanLanguageListenerImpl
{
public:
   //! class constructor
   dia_IOCtrlHMILanguage_set(tVoid);
   //! class destructor
   virtual ~dia_IOCtrlHMILanguage_set(tVoid);
   //! handle freeze request
//   virtual tDiaResult handleFreeze ( tVoid );

   virtual tDiaResult handleRequest(tU8 timerValue, std::vector<tU8>* ctrlValue);
   //!
   virtual tVoid handleTimeout(tVoid);

   //! result of the setHMILanguage operations
   virtual tVoid vOnSetHMILanguage(tDiaResult result);
   //! result on read the current HMI Language
   virtual tVoid vOnGetHMILanguage ( dia_eNissanLanguage language );

protected:
   //! switch off the test screen
   virtual tDiaResult vOnTerminate(dia_eIOCtrlStatus status);
   //! send set new HMI language
//   virtual tDiaResult setHMILanguage ( dia_eCMLanguage language );
   //! frozen value used to restore language in case of return control to ECU
   dia_eNissanLanguage mLanguageBeforeFreeze;
};

#endif /* __INCLUDED_DIA_IOCTRL_HMI_LANGUAGE_SET__ */
