/*
 * dia_IOCtrlHMILanguage_set.cpp
 *
 *  Created on: 16.12.2015
 *      Author: bsu9kor
 *      -----------------------------------------------------------------------------------------------------------------------
 *      Date        Author	    Modification
 *      22.12.2015  bsu9kor		Added enum changes fron DIA_EN_CM_LANGUAGE to DIA_EN_NISSAN_LANGUAGE
 *
 *      ---------------------------------------------------------------------------------------------------------------------
 */
//TTFis:\>DIA_REQ UDS 06 2F B1 01 03 01

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#include "dia_IOCtrlHMILanguage_set.h"
#include "common/services/uds/generic/dia_SrvHandlerGenericIOCtrlByIdentifier.h"

//------------------------------------------------------------------------------

dia_IOCtrlHMILanguage_set::dia_IOCtrlHMILanguage_set ( tVoid )
   : dia_IOCtrlSignal (
         DIA_C_U16_DID_RBCM_HMI_LANGUAGE,
         DIA_EN_IOCTRL_SIGTYPE_HMI_LANGUAGE,
         1 // Payload Length
         )
{
   mLanguageBeforeFreeze = DIA_EN_NISSAN_LANGUAGE_UNKNOWN;
}

//------------------------------------------------------------------------------

dia_IOCtrlHMILanguage_set::~dia_IOCtrlHMILanguage_set ( tVoid )
{
   _BP_TRY_BEGIN
   {
      (tVoid) unsetSysAdapterListener<dia_INissanLanguageListener>(this);
   }
   _BP_CATCH_ALL
   {
       DIA_TR_ERR("EXCEPTION CAUGHT: dia_IOCtrlHMILanguage_set::~dia_IOCtrlHMILanguage_set !!!");
       NORMAL_M_ASSERT_ALWAYS();
   }
   _BP_CATCH_END
}

//------------------------------------------------------------------------------

tDiaResult
dia_IOCtrlHMILanguage_set::handleRequest ( tU8 /*timerValue*/, std::vector<tU8>* ctrlValue )
{
   dia_tclFnctTrace oTrace("dia_IOCtrlHMILanguage_set::handleRequest()");
   tBool errorDetected = TRUE;

   dia_INissanLanguage* pInterface = 0;
   if ( querySysAdapterInterface<dia_INissanLanguage>(&pInterface) == DIA_SUCCESS )
   {
      if ( pInterface )
      {
         (tVoid) setSysAdapterListener<dia_INissanLanguageListener>(this);

         dia_eNissanLanguage newLanguage = DIA_EN_NISSAN_LANGUAGE_UNKNOWN;
         switch(ctrlValue->at(0)){
            case 0x01:
               newLanguage = DIA_EN_NISSAN_LANGUAGE_ENGLISH;
               break;
            case 0x02:
               newLanguage = DIA_EN_NISSAN_LANGUAGE_GERMAN;
               break;
            case 0x03:
               newLanguage = DIA_EN_NISSAN_LANGUAGE_PORTUGESE;
               break;
            case 0x04:
               newLanguage = DIA_EN_NISSAN_LANGUAGE_CHINESE;
               break;
            default:
               DIA_TR_ERR("dia_IOCtrlHMILanguage_set::handleRequest - LANGUAGE ID UNKNOWN.");
               break;
         }

         // save current language
         if (mLanguageBeforeFreeze == DIA_EN_NISSAN_LANGUAGE_UNKNOWN) {
            DIA_TR_INF("dia_IOCtrlHMILanguage_set::handleRequest - Save current language.");
            pInterface->getHMILanguage();
         }
         // set to new language
         if ( (newLanguage != DIA_EN_NISSAN_LANGUAGE_UNKNOWN) && ((pInterface->setHMILanguage(newLanguage)) == DIA_SUCCESS ))
         {
            errorDetected = FALSE;
         }
      } else {
         DIA_TR_ERR("dia_IOCtrlHMILanguage_set::handleRequest - pInterface FAILED.");
      }
   } else {
      DIA_TR_ERR("dia_IOCtrlHMILanguage_set::handleRequest - querySysAdapterInterface FAILED.");
   }

   if ( errorDetected )
   {
      (tVoid) unsetSysAdapterListener<dia_INissanLanguageListener>(this);
      DIA_TR_ERR("dia_IOCtrlHMILanguage_set --- SEND TO SYSTEM ADAPTER FAILED!!!!");
      return DIA_FAILED;
   }

   // now initialize the counter for the timer
   vSetTimer(DIA_C_U8_UDS_IOCTRL_TIMER_VALUE_INFINITE);

   mIsResultReady = FALSE;

   return DIA_SUCCESS;
}

//------------------------------------------------------------------------------

tVoid
dia_IOCtrlHMILanguage_set::vOnSetHMILanguage ( tDiaResult result )
{
   dia_tclFnctTrace oTrace("dia_IOCtrlHMILanguage_set::vOnSetHMILanguage()");

   (tVoid) unsetSysAdapterListener<dia_INissanLanguageListener>(this);
   mIsResultReady = TRUE;
   if (result == DIA_SUCCESS) {
      DIA_TR_INF("dia_IOCtrlHMILanguage_set::vOnSetHMILanguage SUCCESSFUL !!!");
   } else {
      setErrorInfo(DIA_E_CONDITIONS_NOT_CORRECT);
      DIA_TR_ERR("dia_IOCtrlHMILanguage_set::vOnSetHMILanguage DIA_FAILED !!!");
   }

   dia_SrvHandlerGenericIOCtrlByIdentifier::vOnSignalUpdate(this);
}

//-----------------------------------------------------------------------------

tDiaResult
dia_IOCtrlHMILanguage_set::vOnTerminate ( dia_eIOCtrlStatus status )
{
   dia_tclFnctTrace oTrace("dia_IOCtrlHMILanguage_set::vOnTerminate()");
   tDiaResult retCode = DIA_FAILED;

   dia_INissanLanguage* pInterface = 0;
   if (querySysAdapterInterface<dia_INissanLanguage>(&pInterface) == DIA_SUCCESS) {
      if (pInterface) {
         (tVoid) setSysAdapterListener<dia_INissanLanguageListener>(this);
         if (mLanguageBeforeFreeze != DIA_EN_NISSAN_LANGUAGE_UNKNOWN) {
            if (pInterface->setHMILanguage(mLanguageBeforeFreeze) == DIA_SUCCESS) {
               retCode = DIA_SUCCESS;
            }
         } else {
            DIA_TR_ERR("dia_IOCtrlHMILanguage_set::vOnTerminate - NO LANGUAGE IS FROZEN.");
         }
      }
   }
   // this ioctrl is no longer active
   eSetStatus(status);

   return retCode;
}

//-----------------------------------------------------------------------------

tVoid
dia_IOCtrlHMILanguage_set::vOnGetHMILanguage ( dia_eNissanLanguage language )
{
   dia_tclFnctTrace oTrace("dia_IOCtrlHMILanguage_set::vOnGetHMILanguage()");
   mLanguageBeforeFreeze = language;
}

//-----------------------------------------------------------------------------

tVoid
dia_IOCtrlHMILanguage_set::handleTimeout ( tVoid )
{
   dia_tclFnctTrace trc("dia_IOCtrlHMILanguage_set::handleTimeout");
   (tVoid) unsetSysAdapterListener<dia_INissanLanguageListener>(this);
}
