/*
 * dia_IOCtrlExternalSwitchWakeOut.cpp
 *
 *  Created on: Aug 7, 2019
 *      Author: HGR6KOR
 *  TTFis:> DIA_REQ UDS 00 2F 10 14 03 xx
 *                                  (xx = 00) -> External wakeout pin disabled
 *                                  (xx = 01) -> External wakeout pin enabled
 */

#ifndef DIA_IOCTRL_EXTERNAL_SWITCH_WAKEOUT_H_
#include "dia_IOCtrlExternalSwitchWakeOut.h"
#endif

#include "common/services/uds/generic/dia_SrvHandlerGenericIOCtrlByIdentifier.h"

#define CTRL_VALUE_SIZE 1
#define DATA_LENGTH 3

#define ACTIVATE_EXTERNALSWITCHWAKEOUT   0x01
#define DEACTIVATE_EXTERNALSWITCHWAKEOUT 0x00

#define DIA_PROP_GPIO_EXTERNALSWITCHWAKEOUT_SIZE 0x01
//------------------------------------------------------------------------------

dia_IOCtrlExternalSwitchWakeOut::dia_IOCtrlExternalSwitchWakeOut ( void )
   : dia_IOCtrlSignal (
		 "dia_IOCtrlExternalSwitchWakeOut",
		 DIA_C_U16_DID_CENTER_CMC_19_EXTERNAL_CTRL_SWITCH_WAKEOUT,
		 CTRL_VALUE_SIZE, // Length in Byte
         DIA_EN_IOCTRL_CTRLMODE_TESTER, // No freeze is necessary ; Tester is responsible for preconditions
         DIA_EN_IOCTRL_MONITORING_MODE_SHORT_TERM_ADJUSTMENT
        )
{
}
//------------------------------------------------------------------------------

dia_IOCtrlExternalSwitchWakeOut::~dia_IOCtrlExternalSwitchWakeOut ( void )
{
}
//------------------------------------------------------------------------------
tDiaResult
dia_IOCtrlExternalSwitchWakeOut::handleRequest ( tU8 timerValue, std::vector<tU8>* ctrlValue )
{
   dia_tclFnctTrace oTrace("dia_IOCtrlExternalSwitchWakeOut::handleRequest()");
   tU8 externalSwitchWakeoutValue = DEACTIVATE_EXTERNALSWITCHWAKEOUT;
   tDiaResult retCode = DIA_SUCCESS;

   DIA_TR_INF("dia_IOCtrlExternalSwitchWakeOut::handleRequest ctrlValue->size() = %d .", ctrlValue->size());

   switch(ctrlValue->at(0)){
      case 0x00:
    	  externalSwitchWakeoutValue = DEACTIVATE_EXTERNALSWITCHWAKEOUT;
         DIA_TR_INF("dia_IOCtrlRearCameraActivation::handleRequest DEACTIVATE System Amp On Output 0x%02x.", ctrlValue->at(0));
         break;
      default:
    	  DIA_TR_INF("dia_IOCtrlRearCameraActivation::handleRequest ACTIVATE System Amp On Output 0x%02x !", ctrlValue->at(0));
    	  externalSwitchWakeoutValue = ACTIVATE_EXTERNALSWITCHWAKEOUT;
         break;
   }
   // now initialize the counter for the timer
   DIA_TR_INF("timerValue: %d", timerValue);
   vSetTimer(DIA_C_U8_UDS_IOCTRL_TIMER_VALUE_INFINITE);
   mIsResultReady = FALSE;

   if (ExternalSwitchWakeOut (externalSwitchWakeoutValue) == DIA_SUCCESS)
   {
	   mIsResultReady = TRUE;
	   dia_SrvHandlerGenericIOCtrlByIdentifier::vOnSignalUpdate(this);
   }
   else
   {
	   retCode = DIA_FAILED;
   }
   // NO_ERROR allows the service handler to return immediately
   return retCode;
}

//------------------------------------------------------------------------------

tDiaResult
dia_IOCtrlExternalSwitchWakeOut::vOnTerminate ( dia_eIOCtrlStatus status )
{
   dia_tclFnctTrace oTrace("dia_IOCtrlExternalSwitchWakeOut::vOnTerminate()");

   tDiaResult retCode = DIA_E_NOERROR;

   if ( eGetStatus() == DIA_EN_IOCTRL_STATUS_ACTIVE )
   {
      if ( (status == DIA_EN_IOCTRL_STATUS_INACTIVE) || (status == DIA_EN_IOCTRL_STATUS_INACTIVE_TIMEOUT))
      {
         // we have to wait for the response
         mIsResultReady = FALSE;
         status = DIA_EN_IOCTRL_STATUS_INACTIVE;
      }
      // write ExternalSwitchWakeOut
      if (ExternalSwitchWakeOut (DEACTIVATE_EXTERNALSWITCHWAKEOUT) == DIA_SUCCESS)
      {
    	  mIsResultReady = TRUE;
    	  DIA_TR_INF("dia_IOCtrlExternalSwitchWakeOut::vOnTerminate(): ABLE TO WRITE GPIO data");
      }
      else
      {
    	  DIA_TR_INF("dia_IOCtrlExternalSwitchWakeOut::vOnTerminate(): UNABLE TO WRITE GPIO data");
      }

   }
   // this ioctrl is controlled by the external tester
   eSetMode(DIA_EN_IOCTRL_CTRLMODE_ECU);

   // this ioctrl is no longer active
   eSetStatus(status);

   return retCode;
}
//-----------------------------------------------------------------------------

void
dia_IOCtrlExternalSwitchWakeOut::handleTimeout ( void )
{
   dia_tclFnctTrace trc("dia_IOCtrlExternalSwitchWakeOut::handleTimeout");
}
//-----------------------------------------------------------------------------


tDiaResult
dia_IOCtrlExternalSwitchWakeOut::ExternalSwitchWakeOut ( const tU8 ctrlValue ) const
{
   dia_tclFnctTrace trc("dia_IOCtrlExternalSwitchWakeOut::ExternalSwitchWakeOut");

   tDiaResult retCode = DIA_SUCCESS;

   tU16 size = dia_getPropertySize(DIA_PROP_CMC_GPIO_EXTERNAL_SWITCH_WAKEOUT);
   tU8 data[DIA_PROP_GPIO_EXTERNALSWITCHWAKEOUT_SIZE] = {0};

   data[0] = ctrlValue;

   // write external switch  Output
   if (DIA_SUCCESS != dia_setProperty(DIA_PROP_CMC_GPIO_EXTERNAL_SWITCH_WAKEOUT, data, size))
   {
	   retCode = DIA_FAILED;
	   DIA_TR_INF("dia_IOCtrlExternalSwitchWakeOut::ExternalSwitchWakeOut(): UNABLE TO WRITE GPIO data");
   }
   return retCode;
}
