/*
 * dia_IOCtrlExternalAmplifierControlLine.h
 *
 *  Created on: 04.09.2015
 *      Author: sbr5kor
 *      --------------------------------------------------------------------------------------
 *      Date        Author	    Modification
 *
 *		30.06.2016  dvd5kor		IOCtrl external amplifier line to production session
 *      ---------------------------------------------------------------------------------------
 */

#ifndef DIA_IOCTRL_EXT_AMP_CTRL_LINE_H_
#define DIA_IOCTRL_EXT_AMP_CTRL_LINE_H_

#ifndef __INCLUDED_DIA_IOCTRL_SIGNAL__
#include "common/framework/protocols/uds/ioctrl/dia_IOCtrlSignal.h"
#endif

#ifndef __INCLUDED_DIA_CONFIG_MANAGER__
#include "common/framework/config/dia_ConfigManager.h"
#endif

#ifndef __INCLUDED_DIA_DEFS_CONFIG_PROJECT__
#include "project/framework/config/dia_defsProjectConfig.h"
#endif

class dia_IOCtrlExternalAmplifierControlLine
   :  public dia_IOCtrlSignal
{
public:
   //! class constructor
   dia_IOCtrlExternalAmplifierControlLine ( void );
   //! class destructor
   virtual ~dia_IOCtrlExternalAmplifierControlLine ( void );

   virtual tDiaResult handleRequest ( tU8 timerValue, std::vector<tU8>* ctrlValue );

   //!
   virtual void handleTimeout ( void );

   //!
   virtual bool isFrozen ( void ) const {return true;}

protected:
   //! deactivate System / Amp On Output
   virtual tDiaResult vOnTerminate ( dia_eIOCtrlStatus status );
   //! activate/deactivate System / Amp On Output
   tDiaResult controlSystemAmpOnOutput ( const tU8 ctrlValue ) const;

};

#endif /* DIA_IOCTRL_EXT_AMP_CTRL_LINE_H_ */
