/*
 * dia_IOCtrlDisplayTestPatternAIVI.h
 *
 *  Created on: 27.06.2017
 *      Author: abe6kor
 */
// DIA_REQ UDS 06 2F 62 02 cc zz zz -> 2 bytes of PWM value

#ifndef DIA_IOCTRL_DISPLAY_TEST_PATTERN_AIVI__H_
#define DIA_IOCTRL_DISPLAY_TEST_PATTERN_AIVI__H_

#ifndef __INCLUDED_DIA_IOCTRL_SIGNAL__
#include "common/framework/protocols/uds/ioctrl/dia_IOCtrlSignal.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_DISPLAYPATTERNAIVI_LISTENER__
#include "project/interfaces/dia_IDisplayPatternAIVIListener.h"
#endif

////////////////////////////////////////////////////////////////////////////////

class dia_IOCtrlDisplayTestPatternAIVI
: public dia_IOCtrlSignal,
  public dia_IDisplayPatternAIVIListenerImpl
{
public:
	//! class constructor
	dia_IOCtrlDisplayTestPatternAIVI ( void );
	//! class destructor
	virtual ~dia_IOCtrlDisplayTestPatternAIVI ( void );

	virtual tDiaResult handleRequest ( tU8 timerValue, std::vector<tU8>* ctrlValue );
	//!
	virtual void handleTimeout ( void );

	virtual void vOnSetDisplayTestPatternDone ( tDiaResult u32Res );

protected:
	//! switch off the test screen
	virtual tDiaResult vOnTerminate ( dia_eIOCtrlStatus status );

	tDiaResult SetScreen(tU8 u8Screen);
};

#endif // DIA_IOCTRL_DISPLAY_TEST_PATTERN_AIVI__H_
