/*
 * dia_IOCtrlDisplayTestPatternAIVI.cpp
 *
 *  Created on: 27.06.2017
 *      Author: abe6kor
 *
 */
// DIA_REQ UDS 06 2F 62 02 cc zz zz -> 2 bytes of PWM value

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

// #include "common/services/uds/generic/dia_SrvHandlerGenericIOCtrlByIdentifier.h"

#ifndef __INCLUDED_DIA_IOCTRL_MANAGER__
#include "common/framework/protocols/uds/ioctrl/dia_IOCtrlManager.h"
#endif

#ifndef DIA_IOCTRL_DISPLAY_TEST_PATTERN_H_
#include "project/services/production/dia_IOCtrlDisplayTestPatternAIVI.h"
#endif

#define DIA_C_U8_MAX_NUMBER_OF_CMDS_TEST_PATTERNS  ((tU8)    9)
#define DIA_C_U8_NAC_TEST_SCREENS                  ((tU8) 0x5C) // not a real test pattern, will start the NAC test
#define DIA_C_U8_RGB_NOK						   ((tU8) 0x10)
#define DIA_C_U8_RGB_OK							   ((tU8) 0x11)
#define DIA_C_U8_RGB_REPDARK					   ((tU8) 0x12)
#define DIA_C_U8_DOTDET01						   ((tU8) 0x20)
#define DIA_C_U8_DOTDET02						   ((tU8) 0x21)
#define DIA_C_U8_DOTDET03						   ((tU8) 0x22)
#define DIA_C_U8_DOTDET04						   ((tU8) 0x23)
#define DIA_C_U8_DOTDET05						   ((tU8) 0x24)
#define DIA_C_U8_DOTDET06						   ((tU8) 0x25)
#define DIA_C_U8_DOTDET07						   ((tU8) 0x26)
#define DIA_C_U8_DOTDET08						   ((tU8) 0x27)
#define DIA_C_U8_DOTDET09						   ((tU8) 0x28)
#define DIA_C_U8_DOTDET10						   ((tU8) 0x29)
#define DIA_C_U8_DOTDET11						   ((tU8) 0x2A)
#define DIA_C_U8_DOTDET12						   ((tU8) 0x2B)
#define DIA_C_U8_DOTDET13						   ((tU8) 0x2C)
#define DIA_C_U8_DOTDET14						   ((tU8) 0x2D)
#define DIA_C_U8_DOTDET15						   ((tU8) 0x2E)
#define DIA_C_U8_DOTDET16						   ((tU8) 0x2F)
#define DIA_C_U8_DOTDET17						   ((tU8) 0x30)
#define DIA_C_U8_DOTDET18						   ((tU8) 0x31)
#define DIA_C_U8_DOTDET19						   ((tU8) 0x32)
#define DIA_C_U8_DOTDET20						   ((tU8) 0x33)
#define DIA_C_U8_DOTDET21						   ((tU8) 0x34)
#define DIA_C_U8_DOTDET22						   ((tU8) 0x35)
#define DIA_C_U8_DOTDET23						   ((tU8) 0x36)
#define DIA_C_U8_DOTDET24						   ((tU8) 0x37)
#define DIA_C_U8_DOTDET25						   ((tU8) 0x38)
#define DIA_C_U8_DOTDET26						   ((tU8) 0x39)
#define DIA_C_U8_DOTDET27						   ((tU8) 0x3A)
#define DIA_C_U8_DOTDET28						   ((tU8) 0x3B)
#define DIA_C_U8_FLIP_UDHV						   ((tU8) 0x40)
#define DIA_C_U8_Point1                            ((tU8) 0x5D)
#define DIA_C_U8_Point2                            ((tU8) 0x5E)
#define DIA_C_U8_Point3                            ((tU8) 0x5F)
#define DIA_C_U8_Point4                            ((tU8) 0x60)
#define DIA_C_U8_Point5                            ((tU8) 0x61)
#define DIA_C_U8_10_STEP_GRAY_SCALE_SIGNAL  	   ((tU8) 0x70)
#define DIA_C_U8_75_SMPTE_COLOR_BAR_SIGNAL   	   ((tU8) 0x71)
#define DIA_C_U8_GAMMA0      					   ((tU8) 0x72)
#define DIA_C_U8_GAMMA16     					   ((tU8) 0x73)
#define DIA_C_U8_GAMMA32     					   ((tU8) 0x74)
#define DIA_C_U8_GAMMA48     					   ((tU8) 0x75)
#define DIA_C_U8_GAMMA64     					   ((tU8) 0x76)
#define DIA_C_U8_GAMMA80     					   ((tU8) 0x77)
#define DIA_C_U8_GAMMA96     					   ((tU8) 0x78)
#define DIA_C_U8_GAMMA112    					   ((tU8) 0x79)
#define DIA_C_U8_GAMMA128    					   ((tU8) 0x7A)
#define DIA_C_U8_GAMMA144    					   ((tU8) 0x7B)
#define DIA_C_U8_GAMMA160    					   ((tU8) 0x7C)
#define DIA_C_U8_GAMMA176    					   ((tU8) 0x7D)
#define DIA_C_U8_GAMMA192    					   ((tU8) 0x7E)
#define DIA_C_U8_GAMMA208    					   ((tU8) 0x7F)
#define DIA_C_U8_GAMMA224    					   ((tU8) 0x80)
#define DIA_C_U8_GAMMA240    					   ((tU8) 0x81)
#define DIA_C_U8_GAMMA255    					   ((tU8) 0x82)

//------------------------------------------------------------------------------

dia_IOCtrlDisplayTestPatternAIVI::dia_IOCtrlDisplayTestPatternAIVI ( void )
: dia_IOCtrlSignal (
		DIA_C_U16_DID_RBCM_DISPLAY_TEST_PATTERN,
		DIA_EN_IOCTRL_SIGTYPE_DISPLAY_TEST,
		1,
		DIA_EN_IOCTRL_CTRLMODE_TESTER
)
{}

//------------------------------------------------------------------------------

dia_IOCtrlDisplayTestPatternAIVI::~dia_IOCtrlDisplayTestPatternAIVI ( void )
{
	_BP_TRY_BEGIN
	{
		(void) unsetSysAdapterListener<dia_IDisplayPatternAIVIListener>(this);
	}
	_BP_CATCH_ALL
	{
		DIA_TR_ERR("EXCEPTION CAUGHT: dia_IOCtrlDisplayTestPatternAIVI::~dia_IOCtrlDisplayTestPatternAIVI !!!");
		DIA_ASSERT_ALWAYS();
	}
	_BP_CATCH_END
}

//------------------------------------------------------------------------------

tDiaResult
dia_IOCtrlDisplayTestPatternAIVI::handleRequest ( tU8 /*timerValue*/, std::vector<tU8>* ctrlValue )
{
	dia_tclFnctTrace oTrace("dia_IOCtrlDisplayTestPatternAIVI::handleRequest()");

	if ( DIA_SUCCESS != SetScreen( ctrlValue->at(0) ) )
	{
		(void) unsetSysAdapterListener<dia_IDisplayPatternAIVIListener>(this);
		DIA_TR_ERR(" ---  SEND TO HMI FAILED!!!!");
		return DIA_FAILED;
	}

	// now initialize the counter for the timer
	vSetTimer(DIA_C_U8_UDS_IOCTRL_TIMER_VALUE_INFINITE);

	mIsResultReady = FALSE;

	// NO_ERROR allows the service handler to return immediately
	return DIA_SUCCESS;
}

//------------------------------------------------------------------------------

tDiaResult
dia_IOCtrlDisplayTestPatternAIVI::vOnTerminate ( dia_eIOCtrlStatus status )
{
	dia_tclFnctTrace oTrace("dia_IOCtrlDisplayTestPatternAIVI::vOnTerminate()");

	tDiaResult retCode = DIA_E_NOERROR;

	if ( eGetStatus() == DIA_EN_IOCTRL_STATUS_ACTIVE )
	{
		if ( status == DIA_EN_IOCTRL_STATUS_INACTIVE)
		{
			// we have to wait for the response
			mIsResultReady = FALSE;
		}

		// Set to normal HMI screen
		if ( DIA_SUCCESS != SetScreen(0) )
		{
			DIA_TR_INF("FAILED TO DEACTIVATE DIAGNOSIS ACTIVITY SET : TEST SCREEN !!!");
			retCode = DIA_FAILED;
		}
	}

	// this ioctrl is no longer active
	// eSetStatus(status); // Don't set the status, wait for the response from HMI

	return retCode;
}


//-----------------------------------------------------------------------------

void
dia_IOCtrlDisplayTestPatternAIVI::vOnSetDisplayTestPatternDone (  tDiaResult res )
{
	dia_tclFnctTrace trc("dia_IOCtrlDisplayTestPatternAIVI::vOnSetDisplayTestPatternDone");

	(void) unsetSysAdapterListener<dia_IDisplayPatternAIVIListener>(this);
	mIsResultReady = TRUE;

	if(DIA_SUCCESS == res)
	{
		setErrorInfo(DIA_E_NOERROR);
	}
	else
	{
		setErrorInfo(DIA_E_CONDITIONS_NOT_CORRECT);
	}

	dia_IOCtrlManager::vOnSignalUpdate(*this);

	// #ifndef __DIA_UNIT_TESTING__
	// dia_SrvHandlerGenericIOCtrlByIdentifier::vOnSignalUpdate(this);
	// #endif
}

//-----------------------------------------------------------------------------

void
dia_IOCtrlDisplayTestPatternAIVI::handleTimeout ( void )
{
	dia_tclFnctTrace trc("dia_IOCtrlDisplayTestPatternAIVI::handleTimeout");
	(void) unsetSysAdapterListener<dia_IDisplayPatternAIVIListener>(this);
}

//------------------------------------------------------------------------------

tDiaResult
dia_IOCtrlDisplayTestPatternAIVI::SetScreen(tU8 u8Screen)
{
	static dia_eDisplayPatternAIVIID dispPatternMapping[DIA_C_U8_MAX_NUMBER_OF_CMDS_TEST_PATTERNS] = {
			DIA_EN_DISPLAY_PATTERN_AIVI_NONE,
			DIA_EN_DISPLAY_PATTERN_AIVI_WHITE,
			DIA_EN_DISPLAY_PATTERN_AIVI_BLACK,
			DIA_EN_DISPLAY_PATTERN_AIVI_RED,
			DIA_EN_DISPLAY_PATTERN_AIVI_GREEN,
			DIA_EN_DISPLAY_PATTERN_AIVI_BLUE,
			DIA_EN_DISPLAY_PATTERN_AIVI_COLOURED,
			DIA_EN_DISPLAY_PATTERN_AIVI_FLICKER_TEST,
			DIA_EN_DISPLAY_PATTERN_AIVI_TEST_MARK
	};

	tDiaResult ret = DIA_FAILED;

	dia_IDisplayPatternAIVI* pInterface = 0;
	if ( querySysAdapterInterface<dia_IDisplayPatternAIVI>(&pInterface) == DIA_SUCCESS )
	{
		if ( pInterface )
		{
			dia_eDisplayPatternAIVIID patternID = DIA_EN_DISPLAY_PATTERN_AIVI_UNKNOWN;
			if ( u8Screen < DIA_C_U8_MAX_NUMBER_OF_CMDS_TEST_PATTERNS )
			{
				patternID = dispPatternMapping[u8Screen];
			}
			else
			{
				switch(u8Screen)
				{
				case DIA_C_U8_NAC_TEST_SCREENS :
				{
					patternID = DIA_EN_DISPLAY_PATTERN_AIVI_TEF_SPECIAL1;
				}break;

				case DIA_C_U8_RGB_OK :
				{
					//DIA_TR_INF("SENDING REQ FOR RGB_OK !!!");
					patternID = DIA_EN_DISPLAY_PATTERN_AIVI_RGB_OK;
				}break;

				case DIA_C_U8_RGB_NOK :
				{
					//DIA_TR_INF("SENDING REQ FOR RGB_NOK !!!");
					patternID = DIA_EN_DISPLAY_PATTERN_AIVI_RGB_NOK;
				}break;

				case DIA_C_U8_RGB_REPDARK :
				{
					//DIA_TR_INF("SENDING REQ FOR RGB_REPDARK !!!");
					patternID = DIA_EN_DISPLAY_PATTERN_AIVI_RGB_REPDARK;
				}break;

				case DIA_C_U8_DOTDET01 :
				{
					//DIA_TR_INF("SENDING REQ FOR DOTDET01 !!!");
					patternID = DIA_EN_DISPLAY_PATTERN_AIVI_DOTDET01;
				}break;

				case DIA_C_U8_DOTDET02 :
				{
					//DIA_TR_INF("SENDING REQ FOR DOTDET02 !!!");
					patternID = DIA_EN_DISPLAY_PATTERN_AIVI_DOTDET02;
				}break;

				case DIA_C_U8_DOTDET03:
				{
					//DIA_TR_INF("SENDING REQ FOR DOTDET03 !!!");
					patternID = DIA_EN_DISPLAY_PATTERN_AIVI_DOTDET03;
				}break;

				case DIA_C_U8_DOTDET04 :
				{
					//DIA_TR_INF("SENDING REQ FOR DOTDET04 !!!");
					patternID = DIA_EN_DISPLAY_PATTERN_AIVI_DOTDET04;
				}break;

				case DIA_C_U8_DOTDET05:
				{
					//DIA_TR_INF("SENDING REQ FOR DOTDET05 !!!");
					patternID = DIA_EN_DISPLAY_PATTERN_AIVI_DOTDET05;
				}break;

				case DIA_C_U8_DOTDET06 :
				{
					//DIA_TR_INF("SENDING REQ FOR DOTDET06 !!!");
					patternID = DIA_EN_DISPLAY_PATTERN_AIVI_DOTDET06;
				}break;

				case DIA_C_U8_DOTDET07 :
				{
					//DIA_TR_INF("SENDING REQ FOR DOTDET07 !!!");
					patternID = DIA_EN_DISPLAY_PATTERN_AIVI_DOTDET07;
				}break;

				case DIA_C_U8_DOTDET08 :
				{
					//DIA_TR_INF("SENDING REQ FOR DOTDET08 !!!");
					patternID = DIA_EN_DISPLAY_PATTERN_AIVI_DOTDET08;
				}break;

				case DIA_C_U8_DOTDET09 :
				{
					//DIA_TR_INF("SENDING REQ FOR DOTDET09 !!!");
					patternID = DIA_EN_DISPLAY_PATTERN_AIVI_DOTDET09;
				}break;

				case DIA_C_U8_DOTDET10 :
				{
					//DIA_TR_INF("SENDING REQ FOR DOTDET10 !!!");
					patternID = DIA_EN_DISPLAY_PATTERN_AIVI_DOTDET10;
				}break;

				case DIA_C_U8_DOTDET11:
				{
					//DIA_TR_INF("SENDING REQ FOR DOTDET11 !!!");
					patternID = DIA_EN_DISPLAY_PATTERN_AIVI_DOTDET11;
				}break;

				case DIA_C_U8_DOTDET12 :
				{
					//DIA_TR_INF("SENDING REQ FOR DOTDET12 !!!");
					patternID = DIA_EN_DISPLAY_PATTERN_AIVI_DOTDET12;
				}break;

				case DIA_C_U8_DOTDET13 :
				{
					//DIA_TR_INF("SENDING REQ FOR DOTDET13 !!!");
					patternID = DIA_EN_DISPLAY_PATTERN_AIVI_DOTDET13;
				}break;

				case DIA_C_U8_DOTDET14 :
				{
					//DIA_TR_INF("SENDING REQ FOR DOTDET14 !!!");
					patternID = DIA_EN_DISPLAY_PATTERN_AIVI_DOTDET14;
				}break;

				case DIA_C_U8_DOTDET15 :
				{
					//DIA_TR_INF("SENDING REQ FOR DOTDET15 !!!");
					patternID = DIA_EN_DISPLAY_PATTERN_AIVI_DOTDET15;
				}break;

				case DIA_C_U8_DOTDET16 :
				{
					//DIA_TR_INF("SENDING REQ FOR DOTDET16 !!!");
					patternID = DIA_EN_DISPLAY_PATTERN_AIVI_DOTDET16;
				}break;

				case DIA_C_U8_DOTDET17 :
				{
					//DIA_TR_INF("SENDING REQ FOR DOTDET17 !!!");
					patternID = DIA_EN_DISPLAY_PATTERN_AIVI_DOTDET17;
				}break;

				case DIA_C_U8_DOTDET18:
				{
					//DIA_TR_INF("SENDING REQ FOR DOTDET18 !!!");
					patternID = DIA_EN_DISPLAY_PATTERN_AIVI_DOTDET18;
				}break;

				case DIA_C_U8_DOTDET19 :
				{
					//DIA_TR_INF("SENDING REQ FOR DOTDET19 !!!");
					patternID = DIA_EN_DISPLAY_PATTERN_AIVI_DOTDET19;
				}break;

				case DIA_C_U8_DOTDET20 :
				{
					//DIA_TR_INF("SENDING REQ FOR DOTDET20 !!!");
					patternID = DIA_EN_DISPLAY_PATTERN_AIVI_DOTDET20;
				}break;

				case DIA_C_U8_DOTDET21 :
				{
					//DIA_TR_INF("SENDING REQ FOR DOTDET21 !!!");
					patternID = DIA_EN_DISPLAY_PATTERN_AIVI_DOTDET21;
				}break;

				case DIA_C_U8_DOTDET22 :
				{
					//DIA_TR_INF("SENDING REQ FOR DOTDET22 !!!");
					patternID = DIA_EN_DISPLAY_PATTERN_AIVI_DOTDET22;
				}break;

				case DIA_C_U8_DOTDET23 :
				{
					//DIA_TR_INF("SENDING REQ FOR DOTDET23 !!!");
					patternID = DIA_EN_DISPLAY_PATTERN_AIVI_DOTDET23;
				}break;

				case DIA_C_U8_DOTDET24 :
				{
					//DIA_TR_INF("SENDING REQ FOR DOTDET24 !!!");
					patternID = DIA_EN_DISPLAY_PATTERN_AIVI_DOTDET24;
				}break;

				case DIA_C_U8_DOTDET25 :
				{
					//DIA_TR_INF("SENDING REQ FOR DOTDET25 !!!");
					patternID = DIA_EN_DISPLAY_PATTERN_AIVI_DOTDET25;
				}break;

				case DIA_C_U8_DOTDET26 :
				{
					//DIA_TR_INF("SENDING REQ FOR DOTDET26 !!!");
					patternID = DIA_EN_DISPLAY_PATTERN_AIVI_DOTDET26;
				}break;

				case DIA_C_U8_DOTDET27 :
				{
					//DIA_TR_INF("SENDING REQ FOR DOTDET27 !!!");
					patternID = DIA_EN_DISPLAY_PATTERN_AIVI_DOTDET27;
				}break;

				case DIA_C_U8_DOTDET28 :
				{
					//DIA_TR_INF("SENDING REQ FOR DOTDET28 !!!");
					patternID = DIA_EN_DISPLAY_PATTERN_AIVI_DOTDET28;
				}break;

				case DIA_C_U8_FLIP_UDHV :
				{
					//DIA_TR_INF("SENDING REQ FOR FLIP UHDV !!!");
					patternID = DIA_EN_DISPLAY_PATTERN_AIVI_FI_EN_FLIP_UDHV;
				}break;

				case DIA_C_U8_Point1:
				{
					//DIA_TR_INF("SENDING REQ FOR POINT 1 !!!");
					patternID = DIA_EN_DISPLAY_PATTERN_AIVI_POINT_1;
				}break;

				case DIA_C_U8_Point2:
				{
					//DIA_TR_INF("SENDING REQ FOR POINT 2 !!!");
					patternID = DIA_EN_DISPLAY_PATTERN_AIVI_POINT_2;
				}break;

				case DIA_C_U8_Point3:
				{
					//DIA_TR_INF("SENDING REQ FOR POINT 3!!!");
					patternID = DIA_EN_DISPLAY_PATTERN_AIVI_POINT_3;
				}break;

				case DIA_C_U8_Point4:
				{
					//DIA_TR_INF("SENDING REQ FOR POINT 4!!!");
					patternID = DIA_EN_DISPLAY_PATTERN_AIVI_POINT_4;
				}break;

				case DIA_C_U8_Point5:
				{
					//DIA_TR_INF("SENDING REQ FOR POINT 5!!!");
					patternID = DIA_EN_DISPLAY_PATTERN_AIVI_POINT_5;
				}break;

				case DIA_C_U8_10_STEP_GRAY_SCALE_SIGNAL:
				{
					//DIA_TR_INF("SENDING REQ FOR DIA_C_U8_10_STEP_GRAY_SCALE_SIGNAL!!!");
					patternID = DIA_EN_DISPLAY_PATTERN_AIVI_0_STEP_GRAY_SCALE_SIGNAL;
				}break;

				case DIA_C_U8_75_SMPTE_COLOR_BAR_SIGNAL:
				{
					//DIA_TR_INF("SENDING REQ FOR DIA_C_U8_75_SMPTE_COLOR_BAR_SIGNAL!!!");
					patternID = DIA_EN_DISPLAY_PATTERN_AIVI_75_SMPTE_COLOR_BAR_SIGNAL;
				}break;

				case DIA_C_U8_GAMMA0:
				{
					//DIA_TR_INF("SENDING REQ FOR DIA_C_U8_GAMMA0!!!");
					patternID = DIA_EN_DISPLAY_PATTERN_AIVI_GAMMA0;
				}break;

				case DIA_C_U8_GAMMA16:
				{
					//DIA_TR_INF("SENDING REQ FOR DIA_C_U8_GAMMA16!!!");
					patternID = DIA_EN_DISPLAY_PATTERN_AIVI_GAMMA16;
				}break;

				case DIA_C_U8_GAMMA32:
				{
					//DIA_TR_INF("SENDING REQ FOR DIA_C_U8_GAMMA32!!!");
					patternID = DIA_EN_DISPLAY_PATTERN_AIVI_GAMMA32;
				}break;

				case DIA_C_U8_GAMMA48:
				{
					//DIA_TR_INF("SENDING REQ FOR DIA_C_U8_GAMMA48!!!");
					patternID = DIA_EN_DISPLAY_PATTERN_AIVI_GAMMA48;
				}break;

				case DIA_C_U8_GAMMA64:
				{
					//DIA_TR_INF("SENDING REQ FOR DIA_C_U8_GAMMA64!!!");
					patternID = DIA_EN_DISPLAY_PATTERN_AIVI_GAMMA64;
				}break;

				case DIA_C_U8_GAMMA80:
				{
					//DIA_TR_INF("SENDING REQ FOR DIA_C_U8_GAMMA80!!!");
					patternID = DIA_EN_DISPLAY_PATTERN_AIVI_GAMMA80;
				}break;

				case DIA_C_U8_GAMMA96:
				{
					//DIA_TR_INF("SENDING REQ FOR DIA_C_U8_GAMMA96!!!");
					patternID = DIA_EN_DISPLAY_PATTERN_AIVI_GAMMA96;
				}break;

				case DIA_C_U8_GAMMA112:
				{
					//DIA_TR_INF("SENDING REQ FOR DIA_C_U8_GAMMA112!!!");
					patternID = DIA_EN_DISPLAY_PATTERN_AIVI_GAMMA112;
				}break;

				case DIA_C_U8_GAMMA128:
				{
					//DIA_TR_INF("SENDING REQ FOR DIA_C_U8_GAMMA128!!!");
					patternID = DIA_EN_DISPLAY_PATTERN_AIVI_GAMMA128;
				}break;

				case DIA_C_U8_GAMMA144:
				{
					//DIA_TR_INF("SENDING REQ FOR DIA_C_U8_GAMMA144!!!");
					patternID = DIA_EN_DISPLAY_PATTERN_AIVI_GAMMA144;
				}break;

				case DIA_C_U8_GAMMA160:
				{
					//DIA_TR_INF("SENDING REQ FOR DIA_C_U8_GAMMA160!!!");
					patternID = DIA_EN_DISPLAY_PATTERN_AIVI_GAMMA160;
				}break;

				case DIA_C_U8_GAMMA176:
				{
					//DIA_TR_INF("SENDING REQ FOR DIA_C_U8_GAMMA176!!!");
					patternID = DIA_EN_DISPLAY_PATTERN_AIVI_GAMMA176;
				}break;

				case DIA_C_U8_GAMMA192:
				{
					//DIA_TR_INF("SENDING REQ FOR DIA_C_U8_GAMMA192!!!");
					patternID = DIA_EN_DISPLAY_PATTERN_AIVI_GAMMA192;
				}break;

				case DIA_C_U8_GAMMA208:
				{
					//DIA_TR_INF("SENDING REQ FOR DIA_C_U8_GAMMA208!!!");
					patternID = DIA_EN_DISPLAY_PATTERN_AIVI_GAMMA208;
				}break;

				case DIA_C_U8_GAMMA224:
				{
					//DIA_TR_INF("SENDING REQ FOR DIA_C_U8_GAMMA224!!!");
					patternID = DIA_EN_DISPLAY_PATTERN_AIVI_GAMMA224;
				}break;

				case DIA_C_U8_GAMMA240:
				{
					//DIA_TR_INF("SENDING REQ FOR DIA_C_U8_GAMMA240!!!");
					patternID = DIA_EN_DISPLAY_PATTERN_AIVI_GAMMA240;
				}break;

				case DIA_C_U8_GAMMA255:
				{
					//DIA_TR_INF("SENDING REQ FOR DIA_C_U8_GAMMA255!!!");
					patternID = DIA_EN_DISPLAY_PATTERN_AIVI_GAMMA255;
				}break;

				default :
				{
					//Do nothing;
				}break;
				}
			}


			if ( patternID != DIA_EN_DISPLAY_PATTERN_AIVI_UNKNOWN )
			{
				(void) setSysAdapterListener<dia_IDisplayPatternAIVIListener>(this);
				ret = pInterface->setDisplayPatternID(patternID);
			}
		}
	}
	return ret;
}

//------------------------------------------------------------------------------

