/*
 * dia_IOCtrlAudioExtOutHfVr.h
 *
 *  Created on: 23.03.2016
 *      Author: kaa1hi
 */

#ifndef DIA_IOCTRL_AUDIO_EXT_OUT_HF_VR_H_
#define DIA_IOCTRL_AUDIO_EXT_OUT_HF_VR_H_

#ifndef __INCLUDED_DIA_IOCTRL_SIGNAL__
#include "common/framework/protocols/uds/ioctrl/dia_IOCtrlSignal.h"
#endif

#ifndef __INCLUDED_DIA_CONFIG_MANAGER__
#include "common/framework/config/dia_ConfigManager.h"
#endif

#ifndef __INCLUDED_DIA_DEFS_CONFIG_PROJECT__
#include "project/framework/config/dia_defsProjectConfig.h"
#endif

class dia_IOCtrlAudioExtOutHfVr
   :  public dia_IOCtrlSignal
{
public:
   //! class constructor
   dia_IOCtrlAudioExtOutHfVr ( void );
   //! class destructor
   virtual ~dia_IOCtrlAudioExtOutHfVr ( void );

   virtual tDiaResult handleRequest ( tU8 timerValue, std::vector<tU8>* ctrlValue );

   //!
   virtual void handleTimeout ( void );

   //!
   virtual bool isFrozen ( void ) const {return true;}

protected:
   //! deactivate System / Amp On Output
   virtual tDiaResult vOnTerminate ( dia_eIOCtrlStatus status );
   //! activate/deactivate output for Tel Mode
   tDiaResult setExtOutput ( const tU8 ctrlValue ) const;

};

#endif /* DIA_IOCTRL_AUDIO_EXT_OUT_HF_VR_H_ */
