/************************************************************************
* FILE:           dia_SrvHandler_VinCurrentWrite.h
* PROJECT:        COACH MEDIA CENTER - DAIMLER EVOBUS
* SW-COMPONENT:   DIAGNOSIS
*----------------------------------------------------------------------
*
* DESCRIPTION:    This file contains the definition of dia_SrvHandler_VinCurrentWrite class,
*				  that provides a service handler which can be used to process  
*                 diagnostic write requests for VIN Current.
*
*----------------------------------------------------------------------
* HISTORY:
* Date           | Author                            | Modification
*----------------------------------------------------------------------
* 14.03.2019     | Arjun Manjunath Sanu (RBEI/ECA2)  | Initial
************************************************************************/

#ifndef __INCLUDED_SERVICE_HANDLER_VIN_CURRENT_WRITE__
#include "project/services/customer/vin/dia_SrvHandler_VinCurrentWrite.h"
#endif

#ifndef __INCLUDED_DIA_VIN_STATE_MACHINE_HANDLER__
#include "project/framework/vin/dia_VINStateMachineHandler.h"
#endif 

#ifndef __INCLUDED_DIA_DEFINES_UDS__
#include <common/framework/protocols/uds/dia_defsUds.h>
#endif

#ifndef __INCLUDED_DIA_CONFIG_MANAGER__
#include "common/framework/config/dia_ConfigManager.h"
#endif

#ifndef __INCLUDED_DIA_MESSAGE_BUFFER__
#include "common/framework/engine/dia_MessageBuffer.h"
#endif

#ifndef __INCLUDED_DIA_FACTORY__
#include "common/framework/application/dia_Factory.h"
#endif

#define DIA_U16_WRITE_DATA_BY_ID_REQUEST_LENGTH  ((tU16) (1 + mDIDLen))
#define DIA_U16_VIN_DATA_LENGTH  ((tU16) (17))
#define MSG_DATA_OFFSET 4
#define DIA_U16_REPLY_LENGTH   ((tU16) (1 /* SID */ + 2 /* DID */))

//------------------------------------------------------------------------------

dia_SrvHandler_VinCurrentWrite::dia_SrvHandler_VinCurrentWrite ( tCString name, tU8 sid, tU8 did )
   : dia_ServiceHandlerUDS("dia_SrvHandler_VinCurrentWrite",DIA_C_U8_UDS_SID_WRITE_DATA_BY_IDENTIFIER,(tU16) DIA_C_U16_DID_CENTER_CMC_19_VIN_CURRENT)
{
   dia_tclFnctTrace trc("dia_SrvHandler_VinCurrentWrite::dia_SrvHandler_VinCurrentWrite(tCString,tU8,tU16)");
}

//------------------------------------------------------------------------------

dia_SrvHandler_VinCurrentWrite::~dia_SrvHandler_VinCurrentWrite ( void )
{}

//------------------------------------------------------------------------------

void
dia_SrvHandler_VinCurrentWrite::vProcessRequest ( const std::vector<void*>& vecArgs )
{
   dia_tclFnctTrace trc("dia_SrvHandler_VinCurrentWrite::vProcessRequest(...)");

   // extract the data from the received message
   tU8 const* pU8 = oDiagMsgBuffer().u8GetBuffer();
   tU16 dataLength = oDiagMsgBuffer().u16GetDataLength();
   if ( dataLength !=  (DIA_U16_WRITE_DATA_BY_ID_REQUEST_LENGTH + DIA_U16_VIN_DATA_LENGTH + 1) ) // one additional byte contains the message length
   {
		DIA_TR_INF("dia_SrvHandler_VinCurrentWrite::vOnProcessRequest INVALID LENGTH. EXPECTED %d B BUT RECEIVED %d B !", (DIA_U16_WRITE_DATA_BY_ID_REQUEST_LENGTH+DIA_U16_VIN_DATA_LENGTH+1), dataLength);
		vSendNegativeResponse(getInstanceOfFactory()->makeNRC(DIA_E_INVALID_MESSAGE_LENGHT_OR_INVALID_FORMAT));
		return;
   }
   
   if ( !(vecArgs.size()) )
   {
		// Sending back the Negative answer
		DIA_TR_INF("dia_SrvHandler_VinCurrentWrite: FAILED (Property Not Available) !!");
		vSendNegativeResponse(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
		return;
   }
   
   std::vector<tU8> vinData;
   vinData.reserve(DIA_U16_VIN_DATA_LENGTH);
   //vinData.resize(DIA_U16_VIN_DATA_LENGTH);
   
   // copy until end of msg. (max ms length == 240B) or '\0' (0x0)
   tU16 u16EleCount = 0;
   for ( ; u16EleCount < DIA_U16_VIN_DATA_LENGTH; u16EleCount++)
   {
      if ( u16EleCount < DIA_PROP_LENGTH_MAX ) 
	  {
         vinData.push_back(pU8[u16EleCount+MSG_DATA_OFFSET]);
		 DIA_TR_INF("dia_SrvHandler_VinCurrentWrite::vinData[%d] = 0x%02x", u16EleCount, vinData[u16EleCount]);
      }
   }
   
	dia_VINStateMachineHandler* poVINsm = dia_VINStateMachineHandler::getInstance();
	if(poVINsm)
	{			   
		if(DIA_SUCCESS == poVINsm->processVINRequest(vinData))
		{
			DIA_TR_INF("dia_SrvHandler_VinCurrentWrite: SUCCEEDED");
			oDiagMsgBuffer().vSetPosResp();
			oDiagMsgBuffer().vSetDataLength(DIA_U16_REPLY_LENGTH);
			vResReadyAndQuit();
		}
		else
		{
			DIA_TR_INF("dia_SrvHandler_VinCurrentWrite: FAILED (Something Went Wrong in the State Machine) !!");
			vSendNegativeResponse(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
			return;
		}
	}
	else
	{
		DIA_TR_INF("dia_SrvHandler_VinCurrentWrite: FAILED (Could not retrieve state machine instance) !!");
		vSendNegativeResponse(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
		return;
	}

}
