/************************************************************************
* FILE:           dia_SrvHandler_GenericVinOdometerWrite.h
* PROJECT:        COACH MEDIA CENTER - DAIMLER EVOBUS
* SW-COMPONENT:   DIAGNOSIS
*----------------------------------------------------------------------
*
* DESCRIPTION:    This file contains the definition of dia_SrvHandler_GenericVinOdometerWrite class,
*				  that provides a service handler which ca nbe used to process  
*                 diagnostic write requests for VIN Odometer Write & VIN Odometer Limit Write.
*
*----------------------------------------------------------------------
* HISTORY:
* Date           | Author                            | Modification
*----------------------------------------------------------------------
* 21.03.2019     | Arjun Manjunath Sanu (RBEI/ECA2)  | Initial
************************************************************************/

#ifndef __INCLUDED_SERVICE_HANDLER_VIN_ODOMETER_GENERIC_WRITE__
#define __INCLUDED_SERVICE_HANDLER_VIN_ODOMETER_GENERIC_WRITE__

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif

#ifndef __INCLUDED_DIA_SERVICE_HANDLER_UDS__
#include "common/framework/protocols/uds/dia_ServiceHandlerUDS.h"
#endif

/**
 * \class   dia_SrvHandler_GenericVinOdometerWrite
 *
 * \brief   service handler to process Vin Current write request
 *
 * \ingroup diaServicesproj
 */

class dia_SrvHandler_GenericVinOdometerWrite
    : public dia_ServiceHandlerUDS
{
   DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(dia_SrvHandler_GenericVinOdometerWrite);

public:
   /**
    *
    * \brief      class constructor
    *
    *             class constructor with name, service identifier and 1 byte
    *             data identifier
    *
    * \param[in]  name     name used to distinguish between multiple instances
    * \param[in]  sid      diagnostic service identifier (e.g. 0x22)
    * \param[in]  did      diagnostic data identifier (1 byte)
	*
    * \return     none
    */
   dia_SrvHandler_GenericVinOdometerWrite ( tCString name, tU8 sid, tU16 did );

   /**
    *
    * \brief      class destructor
    *
    *             class destructor
    */
   virtual ~dia_SrvHandler_GenericVinOdometerWrite ( void );

   /**
    *
    * \brief      method called to start service processing
    *
    *             This method is used to start processing of a received diagnosis
    *             request. The additional parameters are parameters provided by
    *             the service handler itself during creation of its lookup key. The
    *             lookup key and up to two parameters are stored in the lookup table
    *             of a service dispatcher that dispatches incoming message to the
    *             associated service handler.
    *
    * \param[in]  sid      diagnostic service identifier (e.g. 0x22)
    *
    * \return     none
    */
   virtual void vProcessRequest ( const std::vector<tArgsType>& vecArgs );

};

#endif /* __INCLUDED_SERVICE_HANDLER_VIN_ODOMETER_GENERIC_WRITE__ */
