/************************************************************************
* FILE:           dia_RtCtrl_VinReset.h
* PROJECT:        COACH MEDIA CENTER - DAIMLER EVOBUS
* SW-COMPONENT:   DIAGNOSIS
*----------------------------------------------------------------------
*
* DESCRIPTION:    This file contains the definition of dia_RtCtrl_VinReset class,
*				  that provides a service handler which can be used to process  
*                 diagnostic reset request for all VIN parameters.
*
*----------------------------------------------------------------------
* HISTORY:
* Date           | Author                            | Modification
*----------------------------------------------------------------------
* 14.03.2019     | Arjun Manjunath Sanu (RBEI/ECA2)  | Initial
************************************************************************/

#ifndef __INCLUDED_RTCTRL_RESET_VIN__
#define __INCLUDED_RTCTRL_RESET_VIN__

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif

#ifndef __INCLUDED_DIA_ROUTINE__
#include "common/framework/protocols/uds/rtctrl/dia_Routine.h"
#endif

namespace dia
{

class dia_RtCtrl_VinReset 
	: public dia_Routine
{
   DECL_DEFAULT_CONSTRUCTOR_AND_DESTRUCTOR(dia_RtCtrl_VinReset);
   DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(dia_RtCtrl_VinReset);

   public:

   //! start the specified routine
   virtual tDiaResult start ( std::vector<tU8>& params, tU8 timerValue=DIA_C_U8_UDS_RTCTRL_TIMER_VALUE_INFINITE ); //lint !e1735 Info: verified that same default parameter is used as in base class
   virtual tDiaResult requestResult  ( std::vector<tU8>& results );
   protected:
   // virtual tDiaResult reset( const tU32 /*u32Property*/, const tU8 /*u8DefaultValue*/ );
};

}













#endif /* __INCLUDED_RTCTRL_RESET_VIN__ */