/************************************************************************
* FILE:           dia_RtCtrl_VinReset.cpp
* PROJECT:        COACH MEDIA CENTER - DAIMLER EVOBUS
* SW-COMPONENT:   DIAGNOSIS
*----------------------------------------------------------------------
*
* DESCRIPTION:    This file contains the definition of dia_RtCtrl_VinReset class,
*				  that provides a service handler which can be used to process  
*                 diagnostic reset request for all VIN parameters.
*
*----------------------------------------------------------------------
* HISTORY:
* Date           | Author                            | Modification
*----------------------------------------------------------------------
* 14.03.2019     | Arjun Manjunath Sanu (RBEI/ECA2)  | Initial
************************************************************************/

#ifndef __INCLUDED_DIA_COMMON_UDS_RTCTRL__
#include <common/framework/protocols/uds/rtctrl/dia_common_uds_rtctrl.h>
#endif

#ifndef __INCLUDED_DIA_DEFINES_UDS__
#include <common/framework/protocols/uds/dia_defsUds.h>
#endif

#ifndef __INCLUDED_DIA_ROUTINE_CONTROL_MANAGER__
#include "common/framework/protocols/uds/rtctrl/dia_RoutineCtrlManager.h"
#endif

#ifndef __INCLUDED_DIA_UTILITIES__
#include "common/framework/utils/dia_utilities.h"
#endif

#ifndef __INCLUDED_RTCTRL_RESET_VIN__
#include "project/services/customer/vin/dia_RtCtrl_VinReset.h"                                                                 
#endif

#ifndef __INCLUDED_DIA_DEFS_CONFIG_PROJECT__
#include "project/framework/config/dia_defsProjectConfig.h"
#endif

#ifndef __INCLUDED_DIA_CONFIG_MANAGER__
#include "common/framework/config/dia_ConfigManager.h"
#endif

#ifndef __INCLUDED_DIA_DEFS_CONFIG_VIN__
#include "project/framework/vin/dia_defsVinConfig.h"
#endif

#ifndef __INCLUDED_DIA_VIN_STATE_MACHINE_HANDLER__
#include "project/framework/vin/dia_VINStateMachineHandler.h"
#endif 

//------------------------------------------------------------------------------

namespace dia
{


dia_RtCtrl_VinReset::dia_RtCtrl_VinReset( void )
      : dia_Routine("dia_RtCtrl_VinReset", DIA_C_U16_DID_CENTER_CMC_19_VIN_RESET, DIA_EN_RTCTRL_TYPE_SHORT_TERM)
{
    dia_tclFnctTrace oTrace("dia_RtCtrl_VinReset::dia_RtCtrl_VinReset");
}

//------------------------------------------------------------------------------

dia_RtCtrl_VinReset::~dia_RtCtrl_VinReset( void )
{
	("dia_RtCtrl_VinReset::~dia_RtCtrl_VinReset");
}

//------------------------------------------------------------------------------

tDiaResult
dia_RtCtrl_VinReset::start ( std::vector<tU8>& params, tU8 /*timerValue*/ )
{
   dia_tclFnctTrace oTrace("dia_RtCtrl_VinReset::start");
   tDiaResult  retCode         = DIA_FAILED;
   
   // prepare processing of the routine
   vInitialize();
   
   //reset Vin Original, Vin Current, Vin Odometer, Vin Odometer Limit
    dia_VINStateMachineHandler* poVINsm = dia_VINStateMachineHandler::getInstance();
	if(poVINsm != NULL)
	{			   
		if(DIA_SUCCESS == poVINsm->resetAllVINParameters())
		{
			DIA_TR_INF("dia_RtCtrl_VinReset::start - All VIN parameters were reset to default !!!");
			eSetStatus(DIA_EN_RTCTRL_STATUS_COMPLETED_AND_OK);
			retCode = DIA_SUCCESS;
		}
		else
		{
			DIA_TR_ERR("dia_RtCtrl_VinReset::start - Failed to reset VIN parameters  !!!");
			eSetStatus(DIA_EN_RTCTRL_STATUS_COMPLETED_AND_NOK);
		}
	}
	else
	{
		DIA_TR_ERR("dia_RtCtrl_VinReset::start - Failed to reset VIN parameters !!!");
		eSetStatus(DIA_EN_RTCTRL_STATUS_COMPLETED_AND_NOK);
	}
	
   /*
   //!--------------------------------------------------------------------------------------------
   
   //! RESET VIN ORIGINAL
   if(DIA_SUCCESS == reset(DIA_PROP_CENTER_CMC_19_VIN_ORIGINAL, VIN_DEFAULT_VALUE))
   {
	   DIA_TR_INF("dia_RtCtrl_VinReset::start - VIN ORIGINAL RESET SUCCESS !!");
   }
   else
   {
	   DIA_TR_INF("dia_RtCtrl_VinReset::start - VIN ORIGINAL RESET FAILED !!");
	   //eSetStatus(DIA_EN_RTCTRL_STATUS_COMPLETED_AND_NOK);
	   return DIA_FAILED;
   }
   
   //!--------------------------------------------------------------------------------------------
   
   //! RESET VIN CURRENT
   if(DIA_SUCCESS == reset(DIA_PROP_CENTER_CMC_19_VIN_CURRENT, VIN_DEFAULT_VALUE))
   {
	   DIA_TR_INF("dia_RtCtrl_VinReset::start - VIN CURRENT RESET SUCCESS !!");
   }
   else
   {
	   DIA_TR_INF("dia_RtCtrl_VinReset::start - VIN CURRENT RESET FAILED !!");
	   //eSetStatus(DIA_EN_RTCTRL_STATUS_COMPLETED_AND_NOK);
	   return DIA_FAILED;
   }
   
   //!--------------------------------------------------------------------------------------------
   
   //! RESET VIN ODOMETER
   if(DIA_SUCCESS == reset(DIA_PROP_CENTER_CMC_19_VIN_ODOMETER_COUNTER, VIN_ODOMETER_DEFAULT))
   {
	   DIA_TR_INF("dia_RtCtrl_VinReset::start - VIN ODOMETER RESET SUCCESS !!");
   }
   else
   {
	   DIA_TR_INF("dia_RtCtrl_VinReset::start - VIN ODOMETER RESET FAILED !!");
	   //eSetStatus(DIA_EN_RTCTRL_STATUS_COMPLETED_AND_NOK);
	   return DIA_FAILED;
   }
   
   //!--------------------------------------------------------------------------------------------
   
   //! RESET VIN ODOMETER LIMIT
   if(DIA_SUCCESS == reset(DIA_PROP_CENTER_CMC_19_VIN_ODOMETER_COUNTER_LIMIT, VIN_ODOMETER_LIMIT_DEFAULT))
   {
	   DIA_TR_INF("dia_RtCtrl_VinReset::start - VIN ODOMETER LIMIT RESET SUCCESS !!");
   }
   else
   {
	   DIA_TR_INF("dia_RtCtrl_VinReset::start - VIN ODOMETER LIMIT RESET FAILED !!");
	   //eSetStatus(DIA_EN_RTCTRL_STATUS_COMPLETED_AND_NOK);
	   return DIA_FAILED;
   }
   */
   
   //!--------------------------------------------------------------------------------------------
   
   // Variable for Service Handler Framework that this job is done //! indicate that we are done
   mIsResultReady = TRUE;
   return retCode;
}

/*
tDiaResult 
dia_RtCtrl_VinReset::reset( const tU32 u32Property, const tU8 u8DefaultValue )
{
   dia_tclFnctTrace oTrace("dia_RtCtrl_VinReset::reset(...)");
   
   tDiaResult retCode = DIA_SUCCESS;
   tU16 propLength = dia_getPropertySize(u32Property);
   tU8 u8propData[propLength] = {0};
   (void) ::memset(u8propData,0,propLength);
   
   for( tU8 index = 0; index < propLength; ++index)
   {
		u8propData[index] = (tU8)u8DefaultValue;
   }
   
   if(DIA_SUCCESS == dia_setProperty ( u32Property, u8propData, propLength ))
   {
   	    DIA_TR_INF("dia_RtCtrl_VinReset::reset - SUCCESS !!");	
   }
   else
   {
   	   DIA_TR_ERR("dia_RtCtrl_VinReset::reset - FAILED !!");
	   return DIA_FAILED;
   }
   
   return retCode;
}
*/

tDiaResult
dia_RtCtrl_VinReset::requestResult ( std::vector<tU8>& results )
{
   dia_tclFnctTrace oTrace("dia_RtCtrl_VinReset::requestResult()");

   results.push_back(mapStatus2UDSResult());
   results.insert(results.end(), mResults.begin(), mResults.end());

   return DIA_SUCCESS;
}

} //namespace dia