/************************************************************************
* FILE:         dia_tclUDS_BD_CustBTMacAddress.h
* PROJECT:      DIAG Core
* SW-COMPONENT: Diagnostic application
*
*  Created on: 14.01.2016
*      Author: nce5kor
*------------------------------------------------------------------------
* Date 	    | Author	          | Modification
*************************************************************************/

#ifndef dia_tclUDS_BD_CustBTMacAddress_H
#define dia_tclUDS_BD_CustBTMacAddress_H

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include <common/framework/sysadapters/dia_SystemAdapterFacade.h>
#endif

#ifndef __INCLUDED_DIA_SERVICE_HANDLER_UDS__
#include "common/framework/protocols/uds/dia_ServiceHandlerUDS.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_BLUETOOTH_LISTENER__
#include <project/interfaces/dia_IBluetoothListener.h>
#endif

class dia_tclUDS_BD_CustBTMacAddress : public dia_ServiceHandlerUDS,
                                    public dia_IBluetoothListenerImpl
{
   DECL_DEPRECATED_DEFAULT_CONSTRUCTOR(dia_tclUDS_BD_CustBTMacAddress);
   DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(dia_tclUDS_BD_CustBTMacAddress);

 public:
   //! class constructor
   dia_tclUDS_BD_CustBTMacAddress ( tCString name, tU8 sid, tU16 did );

   //! class destructor
   virtual ~dia_tclUDS_BD_CustBTMacAddress(void);

   //! method called to start service processing
   virtual void vProcessRequest ( const std::vector<void*>& vecArgs );

   //! Request Handler Function
   virtual void vOnReadCustBTMacAddressResult( const tU8* const pu8Result );

   //! Response Handler Function Error
   virtual void vOnReadCustBTMacAddressError(const tU32 errCode );
};


#endif

