/*
 * dia_tclUDS_BD_CustBTLinkQuality.cpp
 *
 *  Created on: 23.12.2015
 *      Author: gpu2kor
 *--------------------------------------------------------
 * Date 	    | Author	          | Modification
 * 30-12-2015   | nce5kor			  | Code changes to support the new interface for BTSignalQuality
 *************************************************************************/

#ifndef __INCLUDED_DIA_COMMON_SYSTEM_ADAPTERS__
#include "common/framework/sysadapters/dia_common_system_adapters.h"
#endif

#include "dia_tclUDS_BD_CustBTLinkQuality.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_DIAGNOSTICS_PROD
#include "trcGenProj/Header/dia_tclUDS_BD_CustBTLinkQuality.cpp.trc.h"
#endif

#include "project/framework/sysadapters/dia_SAFeatureBluetooth.h"
#define DATA_START 3
#define DATA_LENGTH 2

#define RESPONSE_BYTE_1 0
#define RESPONSE_BYTE_2 1

/******************************************************************************
* FUNCTION:    dia_tclUDS_BD_CustBTLinkQuality
*
* DESCRIPTION: Constructor
*
******************************************************************************/

dia_tclUDS_BD_CustBTLinkQuality::dia_tclUDS_BD_CustBTLinkQuality(tCString name, tU8 sid, tU16 did):
      dia_ServiceHandlerUDS(name,sid,(tU16) did)
{
    DIA_TR_INF("--> dia_tclUDS_BD_CustBTLinkQuality::dia_tclUDS_BD_CustBTLinkQuality");

    DIA_TR_INF("<-- dia_tclUDS_BD_CustBTLinkQuality::dia_tclUDS_BD_CustBTLinkQuality");
}

/******************************************************************************
* FUNCTION:    ~dia_tclUDS_BD_CustBTLinkQuality
*
* DESCRIPTION: Destructor
*
******************************************************************************/

dia_tclUDS_BD_CustBTLinkQuality::~dia_tclUDS_BD_CustBTLinkQuality()
{
    DIA_TR_INF("--> dia_tclUDS_BD_CustBTLinkQuality::~dia_tclUDS_BD_CustBTLinkQuality");

    _BP_TRY_BEGIN
    {
        (tVoid) unsetSysAdapterListener<dia_IBluetoothMostListener>(this);
    }
    _BP_CATCH_ALL
    {
        DIA_TR_ERR("dia_tclUDS_BD_CustBTLinkQuality::~dia_tclUDS_BD_CustBTLinkQuality - Exception caught!");
        DIA_ASSERT_ALWAYS();
    }
    _BP_CATCH_END

    DIA_TR_INF("<-- dia_tclUDS_BD_CustBTLinkQuality::~dia_tclUDS_BD_CustBTLinkQuality");
}

/******************************************************************************
* FUNCTION:    vProcessRequest
*
* DESCRIPTION: This function receives request from tester.
			   Data is analyzed and prepared for diagnosis-internal communication
*
* PARAMETER:   const std::vector<void*> - list of input params
*
* RETURNVALUE: void
*
******************************************************************************/

void
dia_tclUDS_BD_CustBTLinkQuality::vProcessRequest ( const std::vector<void*>& /*vecArgs*/ )
{
   DIA_TR_INF("--> dia_tclUDS_BD_CustBTLinkQuality::vProcessRequest");

   tBool errorDetected = TRUE;

   dia_IBluetoothMost* pIBluetooth = 0;
   if ((querySysAdapterInterface<dia_IBluetoothMost>(&pIBluetooth) == DIA_SUCCESS) && pIBluetooth)
   {
	  (tVoid) setSysAdapterListener<dia_IBluetoothMostListener>(this); 
	  if ( pIBluetooth->getBTSignalQuality() != DIA_SUCCESS )
      {
         DIA_TR_ERR("!!! dia_tclUDS_BD_CustBTLinkQuality::vProcessRequest => ERROR: vGetBluetoothLinkQuality != DIA_SUCCESS");
      }
      else
      {
         errorDetected = FALSE;
         DIA_TR_INF("--- dia_tclUDS_BD_CustBTLinkQuality::vProcessRequest => Send Successfully to Server");
      }
   }
   else
   {
      DIA_TR_ERR("!!! dia_tclUDS_BD_CustBTLinkQuality::vProcessRequest => ERROR: pIBluetooth == NULL");
   }

   if ( errorDetected )
   {
      (tVoid) unsetSysAdapterListener<dia_IBluetoothMostListener>(this);
      oDiagMsgBuffer().vSetNegResp(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
      vResReadyAndQuit();
   }

   DIA_TR_INF("<-- dia_tclUDS_BD_CustBTLinkQuality::vProcessRequest");
}
/******************************************************************************************
* FUNCTION:    vOnCustBTLinkQualityResult
*
* DESCRIPTION: Response Handling Function to deliver BT signal quality.
*
* PARAMETER: 
* tU8 - RSSI
* tU8 - Link Quality
*
* RETURNVALUE: void
*
******************************************************************************************/
void dia_tclUDS_BD_CustBTLinkQuality::vOnCustBTLinkQualityResult( tU8 u8RSSI, tU8 u8LinkQuality )
{
   DIA_TR_INF( "--> dia_tclUDS_BD_CustBTLinkQuality::vOnCustBTLinkQualityResult");

   (tVoid) unsetSysAdapterListener<dia_IBluetoothMostListener>(this);
   
   DIA_TR_INF( "--- dia_tclUDS_BD_CustBTLinkQuality::vOnCustBTLinkQualityResult => RSSI:%x; u8LinkQuality:%x",u8RSSI, u8LinkQuality);

   oDiagMsgBuffer().vSetPosResp();
   oDiagMsgBuffer().vSetDataLength(DATA_START + DATA_LENGTH);
   oDiagMsgBuffer().vSetDataU8(DATA_START+RESPONSE_BYTE_1, u8RSSI);
   oDiagMsgBuffer().vSetDataU8(DATA_START+RESPONSE_BYTE_2, u8LinkQuality);

   vResReadyAndQuit();
   DIA_TR_INF( "<-- dia_tclUDS_BD_CustBTLinkQuality::vOnCustBTLinkQualityResult");
}
/******************************************************************************************
* FUNCTION:    vOnCustBTLinkQualityError
*
* DESCRIPTION: Error Handling function. This will be called in case of CCA communication failed with BT component.
*
* PARAMETER: 
* tU32 - errCode
*
* RETURNVALUE: void
*
******************************************************************************************/
void dia_tclUDS_BD_CustBTLinkQuality::vOnCustBTLinkQualityError(const tU32 errCode )
{
   DIA_TR_INF( "--> dia_tclUDS_BD_CustBTLinkQuality::vOnCustBTLinkQualityError");

   (tVoid) unsetSysAdapterListener<dia_IBluetoothMostListener>(this);

   DIA_TR_INF( "--- dia_tclUDS_BD_CustBTLinkQuality::vOnCustBTLinkQualityError=> errCode=%x",errCode);
   oDiagMsgBuffer().vSetNegResp(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
   vResReadyAndQuit();

   DIA_TR_INF( "<-- dia_tclUDS_BD_CustBTLinkQuality::vOnCustBTLinkQualityError");
}


