/*!
 * \file       dia_SrvHandler_WriteFactoryMode.cpp
 *
 * \brief      Service Handler for Factory Mode Writing
 *
 * \details
 *
 * \component  Diagnosis
 *
 * \ingroup
 *
 * \copyright  (c) 2016 Robert Bosch GmbH
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */


#include "project/services/customer/dia_SrvHandler_WriteFactoryMode.h"

#ifndef __INCLUDED_DIA_MESSAGE_BUFFER__
#include "common/framework/engine/dia_MessageBuffer.h"
#endif

#ifndef __INCLUDED_DIA_DEFINES_UDS__
#include <common/framework/protocols/uds/dia_defsUds.h>
#endif

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#ifndef __INCLUDED_DIA_CONFIG_MANAGER__
#include "common/framework/config/dia_ConfigManager.h"
#endif

#ifndef __INCLUDED_DIA_COMMON_TEST__
#include "common/framework/test/dia_common_test.h"
#endif

#ifndef __INCLUDED_DIA_DEFS_CONFIG_PROJECT__
#include "project/framework/config/dia_defsProjectConfig.h"
#endif

#ifndef __INCLUDED_DIA_FACTORY__
#include "common/framework/application/dia_Factory.h"
#endif

#ifndef __INCLUDED_DIA_FACTORY_METHODS_PROJECT__
#include "project/framework/factory/dia_factoryMethodsProject.h"
#endif

#define VD_DIAGLOG_S_IMPORT_INTERFACE_MSG
#include "vd_diaglog_if.h"


//-----------------------------------------------------------------------------
dia_SrvHandler_WriteFactoryMode::dia_SrvHandler_WriteFactoryMode(tCString name, tU8 sid, tU16 did, tU32 PropID)
   : dia_SrvHandlerGenericIdentWrite(name, sid, did)
{
   dia_tclFnctTrace trc("dia_SrvHandler_WriteFactoryMode::dia_SrvHandler_WriteFactoryMode()");
}

//-----------------------------------------------------------------------------
dia_SrvHandler_WriteFactoryMode::~dia_SrvHandler_WriteFactoryMode( void )
{
   _BP_TRY_BEGIN
   {
      (void) unsetSysAdapterListener<dia_IErrorLogListener>(this);
   }
   _BP_CATCH_ALL
   {
       DIA_TR_ERR("EXCEPTION CAUGHT: dia_SrvHandler_WriteFactoryMode::~dia_SrvHandler_WriteFactoryMode !!!");
       NORMAL_M_ASSERT_ALWAYS();
   }
   _BP_CATCH_END
}

//-------------------------------------------------------------------------------

void
dia_SrvHandler_WriteFactoryMode::vProcessRequest( const std::vector<void*>& vecArgs )
{
   dia_tclFnctTrace oTrace("dia_SrvHandler_WriteFactoryMode::vProcessRequest()");

   //Write to property - Run base class functionality.
   dia_SrvHandlerGenericIdentWrite::vProcessRequest( vecArgs );

   //Trigger test for DTC set or clear (dia_TestFactoryMode)
   dia_TestController* pTestCtrl = getInstanceOfTestController();
   if ( pTestCtrl )
   {
      std::list<dia_Test*> testRep;
      if (DIA_SUCCESS==pTestCtrl->queryTests(DIA_EN_TESTCONDITION_FACTORY_MODE, testRep))
      {
         tU32 numTests = testRep.size();
         tU32 expectedUID = dia_getHashCodeFromString("dia_TestFactoryMode");

         DIA_TR_INF("dia_SrvHandler_WriteFactoryMode::vProcessRequest: Size of mTestRep = %d", numTests);

         for (tU32 i = 0; i < numTests; i++)
         {
            dia_Test* pCurrentTest = testRep.front();
            testRep.pop_front();

            if (pCurrentTest && (pCurrentTest->getTestType() == DIA_EN_TEST_TYPE_SERVICE))
            {
               if (pCurrentTest->getTestUID()==expectedUID)
               {
                  std::vector<void*> NullArgs;
                  dia_TestService* pTestService = static_cast<dia_TestService*>(pCurrentTest);

                  DIA_TR_INF("Executing TestService (Name = '%s')", pTestService->getName());

                  pTestService->setEmbeddedMode(TRUE);
                  pTestService->vProcessRequest(NullArgs);
               }
               else
               {
                  DIA_TR_INF("UID: act 0x%08X != exp 0x%08X. Skip (\"%s\")", pCurrentTest->getTestUID(), expectedUID, pCurrentTest->getTestName());
               }
            }
            else
            {
               if (pCurrentTest==NULL)
               {
                  DIA_TR_ERR("dia_SrvHandler_WriteFactoryMode::vProcessRequest: NULL ptr in test repository");
               }
               else
               {
                  DIA_TR_INF("dia_SrvHandler_WriteFactoryMode::vProcessRequest: Type different than DIA_EN_TEST_TYPE_SERVICE");
               }
            }
         }
      }
      else
      {
         DIA_TR_ERR("dia_SrvHandler_WriteFactoryMode::vProcessRequest: FactoryMode condition not found.");
      }
   }
}

void
dia_SrvHandler_WriteFactoryMode::vOnClearResult ( )
{
   dia_tclFnctTrace trc("dia_SrvHandler_WriteFactoryMode::vOnClearResult");

   unsetSysAdapterListener<dia_IErrorLogListener>(this);
   // do nothing here
}

void
dia_SrvHandler_WriteFactoryMode::vOnClearError(tU32 u32Error)
{
   dia_tclFnctTrace trc("dia_SrvHandler_WriteFactoryMode::vOnClearError");

   unsetSysAdapterListener<dia_IErrorLogListener>(this);
   DIA_TR_ERR( "### vOnClearError => ERROR: 0x%02X",u32Error);

   //do not send any NRC here, because it is not expected (writing to property is here more important)
}

