

/*!
 * \file       dia_SrvHandler_WifiMonitoring.h
 *
 * \brief      Service Handler for Wifi Monitoring
 *
 *
 * \component  Diagnosis
 *
 * \ingroup
 *
 * \copyright  (c) 2017 Robert Bosch GmbH
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */


#ifndef __INCLUDED_SERVICE_HANDLER_WIFI_MONITORING__
#define __INCLUDED_SERVICE_HANDLER_WIFI_MONITORING__

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_SERVICE_HANDLER_UDS__
#include "common/framework/protocols/uds/dia_ServiceHandlerUDS.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_WIFISETUPS_LISTENER__
#include <common/interfaces/dia_IWifiSetupsListener.h>
#endif

#ifndef __INCLUDED_DIA_INTERFACE_WIFI_CONNMAN_LISTENER__
#include <common/interfaces/dia_IWifiConnmanListener.h>
#endif


class dia_SrvHandler_WifiMonitoring
   : public dia_ServiceHandlerUDS,
     public dia_IWifiSetupsListenerImpl,
     public dia_IWifiConnmanListenerImpl
{
   DECL_DEPRECATED_DEFAULT_CONSTRUCTOR(dia_SrvHandler_WifiMonitoring);
   DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(dia_SrvHandler_WifiMonitoring);

public:
   //! class constructor
   dia_SrvHandler_WifiMonitoring(tCString name, tU8 sid, tU16 did);

   //! class destructor
   virtual ~dia_SrvHandler_WifiMonitoring();

   virtual void vProcessRequest ( const std::vector<tArgsType>& vecArgs );

   //Error handling
   virtual void vOnTimeout ( void );

   //-------------------------------------------------------------------------
   //
   // Overloaded dia_IWifiSetupsListenerImpl methods
   //
   //-------------------------------------------------------------------------

   //! positive response on getting the active WIFI Setups
   virtual void OnActiveSetups ( const std::vector<dia_stWifiSetup>& setupList );

   //-------------------------------------------------------------------------
   //
   // Overloaded dia_IWifiConnmanListenerImpl methods
   //
   //-------------------------------------------------------------------------
   virtual void OnWifiStations ( const std::vector<dia_stWifiStation>& stationList );

protected:
   //set response buffer to given SSID.
   virtual void setSSID ( const std::string& ssid );
};

#endif /* __INCLUDED_SERVICE_HANDLER_WIFI_MONITORING__ */
