 /*
 * \file        dia_SrvHandler_VehicleManufacurerSparePartNumber.cpp
 *
 * \brief       {insert brief description here}
 *
 * \details    1. Read 10 bytes ECU Part Number .
 *                1a. if nok, NRC 0x22.
 *                1b. if ok, go to next point.
 *             2. Vehicle Manufacurer Spare Part Number N (0xF1A1) shall return these number (CustomerECUPartNumber)
 *                if the OEM type of the actual device is Nissan.
 *             3. Vehicle Manufacurer Spare Part Number R (0xF187) shall return these number (CustomerECUPartNumber)
 *                if the OEM type of the actual device is Renault.
 *
 * \author      nbs3kor
 * \date        July 16, 2015
 *
 * \copyright   Robert Bosch Car Multimedia 2015
 */


#include "project/services/customer/dia_SrvHandler_VehicleManufacurerSparePartNumber.h"

#ifndef __INCLUDED_DIA_DEFINES_UDS__
#include <common/framework/protocols/uds/dia_defsUds.h>
#endif

#ifndef __INCLUDED_DIA_CONFIG_MANAGER__
#include "common/framework/config/dia_ConfigManager.h"
#endif

#ifndef __INCLUDED_DIA_MESSAGE_BUFFER__
#include "common/framework/engine/dia_MessageBuffer.h"
#endif

#ifndef __INCLUDED_DIA_FACTORY__
#include "common/framework/application/dia_Factory.h"
#endif

#define DIA_U16_READDATA_BY_ID_REQUEST_LENGTH    ((tU16) (1 + mDIDLen))
#define DIA_U8_VEH_MANUFACTURER_PART_NUMBER_SIZE (tU8) 10

#define DIA_U8_OEM_TYPE_NISSAN                   (tU8) 0x06
#define DIA_U8_OEM_TYPE_RENAULT                  (tU8) 0x08
#define DIA_U8_OEM_TYPE_INFINITI                 (tU8) 0x16



//-----------------------------------------------------------------------------

dia_SrvHandler_VehicleManufacurerSparePartNumber::dia_SrvHandler_VehicleManufacurerSparePartNumber ( tCString name, tU8 sid, tU16 did )
   : dia_ServiceHandlerUDS(name,sid,did)
{
   dia_tclFnctTrace trc("dia_SrvHandler_VehicleManufacurerSparePartNumber::dia_SrvHandler_VehicleManufacurerSparePartNumber(tCString,tU8,tU16)");
}

//-----------------------------------------------------------------------------

dia_SrvHandler_VehicleManufacurerSparePartNumber::~dia_SrvHandler_VehicleManufacurerSparePartNumber ( void )
{}

//-----------------------------------------------------------------------------

void
dia_SrvHandler_VehicleManufacurerSparePartNumber::vProcessRequest ( const std::vector<void*>& vecArgs )
{
   dia_tclFnctTrace trc("dia_SrvHandler_VehicleManufacurerSparePartNumber::vOnProcessRequest");

   // data length contains at least sid, ctrl byte and DID --> 4 bytes minimum
   tU16 dataLength = oDiagMsgBuffer().u16GetDataLength();
   if ( dataLength !=  (DIA_U16_READDATA_BY_ID_REQUEST_LENGTH + 1) ) // one additional byte contains the message length
   {
      DIA_TR_INF("INVALID DATA LENGTH. EXPECTED %d BYTES BUT RECEIVED %d BYTES !!", (DIA_U16_READDATA_BY_ID_REQUEST_LENGTH+1),dataLength);
      vSendNegativeResponse(getInstanceOfFactory()->makeNRC(DIA_E_INVALID_MESSAGE_LENGHT_OR_INVALID_FORMAT));
      return;
   }

   if ( vecArgs.size() )
   {
      tU32 propID = (tU32) vecArgs[0];
      tU8  oem_type = 0xFF;

      // data memory
      std::vector<tU8> veh_manufacturepartno;

      // retrieve size of property
      tU16 length = dia_getPropertySize(propID); //DIA_PROP_LENGTH_MAX;
      veh_manufacturepartno.reserve(length);
      veh_manufacturepartno.resize(length);

      DIA_TR_INF("0---- length %d, veh_manufacturepartno.size() %d", length, veh_manufacturepartno.size());

      tDiaResult retCode = dia_getProperty(propID,veh_manufacturepartno);

      if ( retCode == DIA_SUCCESS )
      {
         DIA_TR_INF("Reading vehicle manufacturer part number is successful");

         // data memory
         std::vector<tU8> CMvariantCoding;

         // retrieve size of property
         length = dia_getPropertySize(DIA_PROP_CM_VARIANT_CODING); //DIA_PROP_LENGTH_MAX;
         CMvariantCoding.reserve(length);

         retCode = dia_getProperty(DIA_PROP_CM_VARIANT_CODING,CMvariantCoding);

         if ( retCode == DIA_SUCCESS )
         {
        	 DIA_TR_INF("Reading CMVariant coding is successful");

        	 if(length == CMvariantCoding.size())
        	 {
        		 oem_type = CMvariantCoding[3];
        		 DIA_TR_INF("CMVariant coding OEm Type is %d", oem_type);
        	 }
        	 else
        	 {
        		 DIA_TR_INF("CMVariant coding length is not same as configured %d", length);
        		 retCode = DIA_FAILED;
        	 }
         }
         else
         {
       	    DIA_TR_INF("UNABLE TO READ ITEM (CMVariant coding) !!");
         }
      }
      else
      {
    	  DIA_TR_INF("UNABLE TO READ ITEM (vehicle manufacturer part number) !!");
      }

      bool oem_did_compare_status = false;

      if( (DIA_SUCCESS == retCode ) && (0xFF != oem_type) )
      {
    	  /* check OEM type and DID */
    	  switch(oem_type)
    	  {
    	     case DIA_U8_OEM_TYPE_NISSAN:
			 case DIA_U8_OEM_TYPE_INFINITI:

    	    	 DIA_TR_INF("OEM type is Nissan/Infiniti");
    	    	 if(DIA_C_U16_DID_AIVI_VEH_MANUFACTURER_SPARE_PART_N_NR == getDID())
    	    	 {
    	    		 DIA_TR_INF("OEM type and DID matches for Nissan/Infiniti");
    	    		 oem_did_compare_status = true;
    	    	 }
    	    	 break;

    	     case DIA_U8_OEM_TYPE_RENAULT:

    	    	 DIA_TR_INF("OEM type is Renault");

    	    	 if(DIA_C_U16_DID_AIVI_VEH_MANUFACTURER_SPARE_PART_R_NR == getDID())
    	    	 {
    	    		 DIA_TR_INF("OEM type and DID matches for Renault");
    	    		 oem_did_compare_status = true;
    	    	 }
    	    	 break;
    	     default:
    	    	 DIA_TR_INF("OEM type is unknown %d", oem_type);
    	    	 break;
    	  }
			 // Sending back the positive answer
		  oDiagMsgBuffer().vSetPosResp();
		  oDiagMsgBuffer().vSetDataLength(DIA_U16_READDATA_BY_ID_REQUEST_LENGTH + DIA_U8_VEH_MANUFACTURER_PART_NUMBER_SIZE);

    	  if(oem_did_compare_status)
    	  {
			 for (tU16 i = 0; i < veh_manufacturepartno.size(); ++i)
			 {
				(void) oDiagMsgBuffer().vSetDataU8(DIA_U16_READDATA_BY_ID_REQUEST_LENGTH+i, veh_manufacturepartno[i]);
			 }
    	  }
    	  else
    	  {
 			 for (tU16 i = 0; i < DIA_U8_VEH_MANUFACTURER_PART_NUMBER_SIZE; ++i)
 			 {
 				(void) oDiagMsgBuffer().vSetDataU8(DIA_U16_READDATA_BY_ID_REQUEST_LENGTH+i, 0x30);
 			 }
    	  }

    	  vResReadyAndQuit();
      }
      else
      {
         DIA_TR_INF("UNABLE TO READ OEM Type or unknown OEM type (READ OPERATION FAILED) !!");
         vSendNegativeResponse(getInstanceOfFactory()->makeNRC(DIA_E_CONDITIONS_NOT_CORRECT));
      }
   }
   else
   {
      DIA_TR_INF("UNABLE TO READ ITEM (PROPERTY NOT PASSED AS PARAMETER");
      vSendNegativeResponse(getInstanceOfFactory()->makeNRC(DIA_E_CONDITIONS_NOT_CORRECT));
   }
}

