 /*
 * \file        dia_SrvHandler_VDiag.cpp
 *
 * \brief       {insert brief description here}
 *
 * \details
 *
 * \author      kaa1hi
 * \date        September 20, 2016
 *
 * \copyright   Robert Bosch Car Multimedia 2016
 */


#include "project/services/customer/dia_SrvHandler_VDiag.h"

#ifndef __INCLUDED_DIA_MESSAGE_BUFFER__
#include "common/framework/engine/dia_MessageBuffer.h"
#endif

#ifndef __INCLUDED_DIA_DEFINES_UDS__
#include <common/framework/protocols/uds/dia_defsUds.h>
#endif

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#ifndef __INCLUDED_DIA_TEST_CONTROLLER__
#include "common/framework/test/dia_TestController.h"
#endif

#ifndef __INCLUDED_DIA_TEST__
#include "common/framework/test/dia_Test.h"
#endif

#ifndef __INCLUDED_DIA_TEST_SERVICE__
#include "common/framework/test/dia_TestService.h"
#endif

#ifndef __INCLUDED_DIA_CONFIG_MANAGER__
#include "common/framework/config/dia_ConfigManager.h"
#endif

#ifndef __INCLUDED_DIA_DEFS_CONFIG_PROJECT__
#include "project/framework/config/dia_defsProjectConfig.h"
#endif

#ifndef __INCLUDED_DIA_TEST_CONFIG_HASH_H_
#include "common/framework/test/dia_TestConfigHash.h"
#endif

#ifndef __INCLUDED_DIA_UTILITIES__
#include "common/framework/utils/dia_utilities.h"
#endif

#define DIA_AIVI_VARIANT_CODING_VDIAG_OFFSET  8

#define DIA_U16_READDATA_BY_ID_REQUEST_LENGTH                     ((tU16) (1 + mDIDLen))
#define DIA_VDIAG_STATUS_SIZE                                     0x01U
#define DIA_VDIAG_DEFAULT_STATUS                                  0x20U

//-----------------------------------------------------------------------------
dia_SrvHandler_VDiag::dia_SrvHandler_VDiag()
   : dia_ServiceHandlerUDS("dia_SrvHandler_VDiag", DIA_C_U8_UDS_SID_READ_DATA_BY_IDENTIFIER, DIA_C_U16_DID_AIVI_VDIAG)
{
   dia_tclFnctTrace trc("dia_SrvHandler_VDiag::dia_SrvHandler_VDiag()");
}

//-----------------------------------------------------------------------------
dia_SrvHandler_VDiag::~dia_SrvHandler_VDiag( void )
{
}

//-------------------------------------------------------------------------------

void
dia_SrvHandler_VDiag::vProcessRequest ( const std::vector<void*>& /*vecArgs*/ )
{
   dia_tclFnctTrace trc("dia_SrvHandler_VDiag::vProcessRequest");

   tU8 VDiagValue = DIA_VDIAG_DEFAULT_STATUS;

   //Below code is active for Scope2 only, because VDIAG is set to 0x20 by default and VDIAG shall be always set to 0x20 for Scope1.
#ifdef VARIANT_S_FTR_ENABLE_RNAIVI
   DIA_TR_INF("dia_SrvHandler_VDiag::vProcessRequest: Scope2 and above");
   tU32 propSize = dia_getPropertySize(DIA_PROP_AIVI_VARIANT_CODING);
   if (DIA_AIVI_VARIANT_CODING_LENGTH==propSize)
   {
      tU8 aiviVariantCodingParam[DIA_AIVI_VARIANT_CODING_LENGTH] = { 0 };
      tDiaResult getPropRes = dia_getProperty(DIA_PROP_AIVI_VARIANT_CODING, aiviVariantCodingParam, DIA_AIVI_VARIANT_CODING_LENGTH);
      if (getPropRes == DIA_SUCCESS)
      {
         VDiagValue = aiviVariantCodingParam[DIA_AIVI_VARIANT_CODING_VDIAG_OFFSET];

         DIA_TR_INF("dia_SrvHandler_VDiag::vProcessRequest: VDiagValue = 0x%02X (offset %d in DIA_PROP_AIVI_VARIANT_CODING)", VDiagValue, DIA_AIVI_VARIANT_CODING_VDIAG_OFFSET);
      }
      else
      {
         DIA_TR_ERR("dia_SrvHandler_VDiag::vProcessRequest: FAILED vehicle info not available");
      }
   }
   else
   {
      DIA_TR_ERR("dia_SrvHandler_VDiag::vProcessRequest: FAILED wrong prop size %d, exp %d", propSize, DIA_AIVI_VARIANT_CODING_LENGTH);
   }
#else
   DIA_TR_INF("dia_SrvHandler_VDiag::vProcessRequest: Scope1");
#endif

   // Sending back the positive answer
   oDiagMsgBuffer().vSetPosResp();
   oDiagMsgBuffer().vSetDataLength(DIA_U16_READDATA_BY_ID_REQUEST_LENGTH + DIA_VDIAG_STATUS_SIZE);
   (void) oDiagMsgBuffer().vSetDataU8(DIA_U16_READDATA_BY_ID_REQUEST_LENGTH + 0, VDiagValue);
   vResReadyAndQuit();
}

