/*
 * dia_SrvHandler_TotalNumberOfReprogramming.cpp
 *
 *  Created on: 09.11.2015
 *      Author: stc2hi
 *  ---------------------------------------------------------------------------------------------------
 *  Date 			Author			Modification
 *  07.04.2016		bsu9kor			Added function vOnNoOfSwReUpdate(NCG3D-11736)
 *  ---------------------------------------------------------------------------------------------------
 */
// TTFis:\> DIA_REQ UDS 03 22 11 00

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#ifndef DIA_SRVHANDLER_TOTAL_NUMBER_OF_REPROGRAMMING_H_
#include "dia_SrvHandler_TotalNumberOfReprogramming.h"
#endif

#ifndef __INCLUDED_DIA_MESSAGE_BUFFER__
#include "common/framework/engine/dia_MessageBuffer.h"
#endif

#ifndef __INCLUDED_DIA_UTILITIES__
#include "common/framework/utils/dia_utilities.h"
#endif

#define DATA_START 3
#define DATA_LENGTH 2
#define ZERO 0
#define ONE 1

//-----------------------------------------------------------------------------

dia_SrvHandler_TotalNumberOfReprogramming::dia_SrvHandler_TotalNumberOfReprogramming ( void )
    : dia_ServiceHandlerUDS("dia_SrvHandler_TotalNumberOfReprogramming",
    DIA_C_U8_UDS_SID_READ_DATA_BY_IDENTIFIER,
    (tU16) DIA_C_U16_DID_AIVI_TOTAL_NUMBER_OF_REPROGRAMMING /*DID*/ )
{
   dia_tclFnctTrace trc("dia_SrvHandler_TotalNumberOfReprogramming::dia_SrvHandler_TotalNumberOfReprogramming(void)");
}

//-----------------------------------------------------------------------------

dia_SrvHandler_TotalNumberOfReprogramming::~dia_SrvHandler_TotalNumberOfReprogramming ( void )
{
    _BP_TRY_BEGIN
    {
        (void) unsetSysAdapterListener<dia_ISwUpdateListener>(this);
    }
    _BP_CATCH_ALL
    {
        DIA_TR_ERR("EXCEPTION CAUGHT: dia_SrvHandler_TotalNumberOfReprogramming::~dia_SrvHandler_TotalNumberOfReprogramming !!!");
        DIA_ASSERT_ALWAYS();
    }
    _BP_CATCH_END
}

//-------------------------------------------------------------------------------

void
dia_SrvHandler_TotalNumberOfReprogramming::vProcessRequest ( const std::vector<void*>& /*vecArgs*/ )
{
   dia_tclFnctTrace trc("dia_SrvHandler_TotalNumberOfReprogramming::vProcessRequest");

   tBool errorDetected = TRUE;

   dia_ISwUpdate* pInterface = 0;
   if ( querySysAdapterInterface<dia_ISwUpdate>(&pInterface) == DIA_SUCCESS )
   {
       DIA_TR_INF("dia_SrvHandler_TotalNumberOfReprogramming::vProcessRequest - querySysAdapterInterface OK");
      if ( pInterface )
      {
         (void) setSysAdapterListener<dia_ISwUpdateListener>(this);
         dia_tHistoryScope historyScope(DIA_EN_UPDATE_HISTORY_SCOPE_ALL, 0, 100);
         if ( pInterface->getSwUpdateInfo (historyScope) == DIA_SUCCESS )
         {
            errorDetected = FALSE;
         }
         else
         {
           DIA_TR_INF("dia_SrvHandler_TotalNumberOfReprogramming::vProcessRequest - getSwUpdateInfo() failed.");
         }
      }
   }
   else
   {
       DIA_TR_INF("dia_SrvHandler_TotalNumberOfReprogramming::vProcessRequest - querySysAdapterInterface NOK !");
   }

   if ( errorDetected )
   {
      (void) unsetSysAdapterListener<dia_ISwUpdateListener>(this);
      DIA_TR_ERR(" ---  SEND TO DOWNLOAD SERVER FAILED!!!!");
      vSendNegativeResponse(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
   }
}

//-----------------------------------------------------------------------------
#if 0
void
dia_SrvHandler_TotalNumberOfReprogramming::vOnNoOfReProgrammingInfo ( tU16 noOfReprogramming )
{
   dia_tclFnctTrace trc("dia_SrvHandler_TotalNumberOfReprogramming:vOnNoOfReProgrammingInfo");

   (void) unsetSysAdapterListener<dia_ISwUpdateListener>(this);

   // Sending back the positive answer
   oDiagMsgBuffer().vSetPosResp();
   oDiagMsgBuffer().vSetDataLength(DATA_START + DATA_LENGTH);

   (void) oDiagMsgBuffer().vSetDataU8((tU8) (DATA_START+0),U16_BYTE1(noOfReprogramming));
   (void) oDiagMsgBuffer().vSetDataU8((tU8) (DATA_START+1),U16_BYTE2(noOfReprogramming));

   vResReadyAndQuit();
}
#endif
//-----------------------------------------------------------------------------------
/******************************************************************************
* FUNCTION:    vOnNoOfSwReUpdate
*
* DESCRIPTION: notify the number of reprogramming info
*
* PARAMETER:  tU16 noOfReprogramming - number of reprogramming
*
* RETURNVALUE: void
*
******************************************************************************/
void
dia_SrvHandler_TotalNumberOfReprogramming::vOnNoOfSwReUpdate ( tU16 noOfReprogramming )
{
   dia_tclFnctTrace trc("dia_SrvHandler_TotalNumberOfReprogramming:vOnNoOfSwReUpdate");

   (void) unsetSysAdapterListener<dia_ISwUpdateListener>(this);

   // Sending back the positive answer
   oDiagMsgBuffer().vSetPosResp();
   oDiagMsgBuffer().vSetDataLength(DATA_START + DATA_LENGTH);

   (void) oDiagMsgBuffer().vSetDataU8((tU8) (DATA_START+ZERO),U16_BYTE1(noOfReprogramming));
   (void) oDiagMsgBuffer().vSetDataU8((tU8) (DATA_START+ONE),U16_BYTE2(noOfReprogramming));

   vResReadyAndQuit();
}
