/*
 * dia_SrvHandler_SupportedIdentifiers.cpp
 *
 *  Created on: 12.01.2016
 *      Author: shw2abt
 */
// TTFis: DIA_REQ UDS 04 22 DF DF

#ifndef __INCLUDED_DIA_UTILITIES__
#include "common/framework/utils/dia_utilities.h"
#endif

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#ifndef __INCLUDED_DIA_COMMON_PROTOCOLS_UDS__
#include "common/framework/protocols/uds/dia_common_uds.h"
#endif

#ifndef DIA_SRVHANDLER_READ_BATTERYLEVEL_H_
#include "project/services/customer/dia_SrvHandler_SupportedIdentifiers.h"
#endif

#ifndef __INCLUDED_DIA_ENGINE_MANAGER__
#include <common/framework/engine/dia_EngineManager.h>
#endif

#ifndef __INCLUDED_DIA_ENGINE_SERVER__
#include <common/framework/engine/dia_EngineServer.h>
#endif

#ifndef __INCLUDED_DIA_SESSION__
#include <common/framework/engine/dia_Session.h>
#endif

#ifndef __INCLUDED_DIA_SECURITY__
#include <common/framework/security/dia_security.h>
#endif

#define DATA_START 3
#define DATA_LENGTH 32

/* Services which are handled by V850 but must be mentioned here */
static dia_EngineServerConfiguration::ServiceDataItem serviceV850InfoRep[] = {
      { 0x22, 0xF186, 0x01, DIA_C_U8_RUNLEVEL_1, {0x01, 0x03, 0x60, 0x61,0x40}, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} } //lint !e785: Too few initializers for sessions array - fine for this case
};

//-----------------------------------------------------------------------------

dia_SrvHandler_SupportedIdentifiers::dia_SrvHandler_SupportedIdentifiers( tCString name, tU8 sid ) :
      dia_ServiceHandlerUDS(name,sid,DIA_C_U16_DID_AIVI_SUPPORTED_IDENTIFIER_BASE)
{
   dia_tclFnctTrace trc("dia_SrvHandler_SupportedIdentifiers::dia_SrvHandler_SupportedIdentifiers(tCString, tU8, tU16)");
}

//-----------------------------------------------------------------------------

dia_SrvHandler_SupportedIdentifiers::~dia_SrvHandler_SupportedIdentifiers(void)
{

}

//-------------------------------------------------------------------------------

void
dia_SrvHandler_SupportedIdentifiers::vProcessRequest(const std::vector<void*>& /*vecArgs*/)
{
   dia_tclFnctTrace trc("dia_SrvHandler_SupportedIdentifiers::vProcessRequest");
   tBool errorDetected = FALSE;

   dia_EngineServer* pEngineCustomer = 0;
   if ( getInstanceOfEngineManager()->queryEngineServer(DIA_UID_ENGINE_CUSTOMER_UDS,&pEngineCustomer) != DIA_SUCCESS )
   {
      DIA_TR_ERR("##### UNABLE TO RETRIEVE POINTER TO CUSTOMER DIAGNOSIS ENGINE #####");
      return;
   }

   // Get SID from SH object
   tU16 subID = oDiagMsgBuffer().u16GetSubServiceId();
   if(this->mSID==DIA_C_U8_UDS_SID_ROUTINE_CONTROL){
      // Rework for DID necessary because position in request is different to other services
      DIA_TR_INF("dia_SrvHandler_SupportedIdentifiers::vProcessRequest BUFFER [3] = 0x%02x .", oDiagMsgBuffer().u8GetData(3));
      DIA_TR_INF("dia_SrvHandler_SupportedIdentifiers::vProcessRequest BUFFER [4] = 0x%02x .", oDiagMsgBuffer().u8GetData(4));
      subID = ((tU16)oDiagMsgBuffer().u8GetData(3)<<8) | oDiagMsgBuffer().u8GetData(4);
   }

   DIA_TR_INF("dia_SrvHandler_SupportedIdentifiers::vProcessRequest SID of object = 0x%02x .", this->mSID);
   DIA_TR_INF("dia_SrvHandler_SupportedIdentifiers::vProcessRequest DID of object = 0x%02x .", subID);

   // READ SPECIFIC DID LIST FROM FRAMEWORK
   std::vector<tU8> availableDIDs;
   tDiaResult retEngineiMx6 = DIA_FAILED;
   tDiaResult retEngineV850 = DIA_FAILED;
   tU16 hb = subID & 0x00FF;
   if(this->mDID == DIA_C_U16_DID_AIVI_SUPPORTED_IDENTIFIER){
      // 1.) Read iMx Services according constrains
      retEngineiMx6 = pEngineCustomer->getServerConfiguration().querySubFuncIDs(pEngineCustomer->getActiveSession(), this->mSID, availableDIDs);  //lint !e864: Expression involving variable possibly depends on order of evaluation
      // 2.) Read V850 Services according constrains
      retEngineV850 = addV850ServicesToSupportedIdentifiers(pEngineCustomer->getActiveSession(), this->mSID, availableDIDs);
   } else {
      DIA_TR_INF("dia_SrvHandler_SupportedIdentifiers::vProcessRequest Extract high byte: 0x%04x .", hb);
      tU16 mask = ((tU16)(hb<<8))|0x00FF;
      DIA_TR_INF("dia_SrvHandler_SupportedIdentifiers::vProcessRequest requested mask (should 0x%02x 0xFF): 0x%04x .", hb, mask);
      // 1.) Read iMx Services according constrains
      retEngineiMx6 = pEngineCustomer->getServerConfiguration().querySubFuncIDs(pEngineCustomer->getActiveSession(), this->mSID, availableDIDs, mask); //lint !e864: Expression involving variable possibly depends on order of evaluation
      // 2.) Read V850 Services according constrains
      retEngineV850 = addV850ServicesToSupportedIdentifiers(pEngineCustomer->getActiveSession(), this->mSID, availableDIDs, mask);
   }

   if(retEngineiMx6==DIA_FAILED || retEngineV850==DIA_FAILED){
      DIA_TR_ERR("##### UNABLE TO READ SUB-FUNCTION-LIST FROM CUSTOMER DIAGNOSIS ENGINE #####");
      DIA_TR_INF("##### retEngineiMx6=%s , retEngineV850=%s .", retEngineiMx6==DIA_FAILED?"DIA_FAILED":"DIA_SUCCESS", retEngineiMx6==DIA_FAILED?"DIA_FAILED":"DIA_SUCCESS");
      return;
   }
   DIA_TR_INF("dia_SrvHandler_SupportedIdentifiers::vProcessRequest Read %d Services for Session 0x%02x and SID 0x%02x .", availableDIDs.size(), pEngineCustomer->getActiveSession()->getID(), this->mSID);

   // MERGE DID TO RESPONSE LIST
   tU8 u8propData[DATA_LENGTH];
   (tVoid) ::memset(u8propData,0,DATA_LENGTH);

   for (std::vector<tU8>::iterator it_did = availableDIDs.begin(); it_did != availableDIDs.end(); ++it_did) {
      //DIA_TR_INF("dia_SrvHandler_SupportedIdentifiers::vProcessRequest Activate DID 0x%02x in response parameter.", *it_did);
      tU8 byteNo = *it_did / 8;
      //DIA_TR_INF("dia_SrvHandler_SupportedIdentifiers::vProcessRequest Determine Byte number: %d.", byteNo);

      tU8 bitPos = *it_did % 8;
      //DIA_TR_INF("dia_SrvHandler_SupportedIdentifiers::vProcessRequest Determine bit position in Byte[%d]: %d.", byteNo, bitPos + 1);

      switch (bitPos) {
         case 0x00:
            u8propData[byteNo] = u8propData[byteNo] | 0x80; // first bit (from left)
            DIA_TR_INF("dia_SrvHandler_SupportedIdentifiers::vProcessRequest set 1st bit in Byte[%d] (from DID 0x%02x%02x).", byteNo, hb, *it_did);
            break;
         case 0x01:
            u8propData[byteNo] = u8propData[byteNo] | 0x40; // second bit (from left)
            DIA_TR_INF("dia_SrvHandler_SupportedIdentifiers::vProcessRequest set 2nd bit in Byte[%d] (from DID 0x%02x%02x).", byteNo, hb, *it_did);
            break;
         case 0x02:
            u8propData[byteNo] = u8propData[byteNo] | 0x20; // third bit (from left)
            DIA_TR_INF("dia_SrvHandler_SupportedIdentifiers::vProcessRequest set 3rd bit in Byte[%d] (from DID 0x%02x%02x).", byteNo, hb, *it_did);
            break;
         case 0x03:
            u8propData[byteNo] = u8propData[byteNo] | 0x10; // fourth bit (from left)
            DIA_TR_INF("dia_SrvHandler_SupportedIdentifiers::vProcessRequest set 4th bit in Byte[%d] (from DID 0x%02x%02x).", byteNo, hb, *it_did);
            break;
         case 0x04:
            u8propData[byteNo] = u8propData[byteNo] | 0x08; // fifth bit (from left)
            DIA_TR_INF("dia_SrvHandler_SupportedIdentifiers::vProcessRequest set 5th bit in Byte[%d] (from DID 0x%02x%02x).", byteNo, hb, *it_did);
            break;
         case 0x05:
            u8propData[byteNo] = u8propData[byteNo] | 0x04; // sixth bit (from left)
            DIA_TR_INF("dia_SrvHandler_SupportedIdentifiers::vProcessRequest set 6th bit in Byte[%d] (from DID 0x%02x%02x).", byteNo, hb, *it_did);
            break;
         case 0x06:
            u8propData[byteNo] = u8propData[byteNo] | 0x02; // seventh bit (from left)
            DIA_TR_INF("dia_SrvHandler_SupportedIdentifiers::vProcessRequest set 7th bit in Byte[%d] (from DID 0x%02x%02x).", byteNo, hb, *it_did);
            break;
         case 0x07:
            u8propData[byteNo] = u8propData[byteNo] | 0x01; // eighth bit (from left)
            DIA_TR_INF("dia_SrvHandler_SupportedIdentifiers::vProcessRequest set 8th bit in Byte[%d] (from DID 0x%02x%02x).", byteNo, hb, *it_did);
            break;
         default:
            DIA_TR_ERR("dia_SrvHandler_SupportedIdentifiers::vProcessRequest UNKNOWN bit position %d (DID=0x%02x%02x; byteNo=%d).", bitPos, hb, *it_did, byteNo);
            errorDetected = TRUE;
            break;
      }
   }

   // CREATE RESPONSE
   if (!errorDetected) {
      oDiagMsgBuffer().vSetPosResp();

      if (this->mSID == DIA_C_U8_UDS_SID_READ_DATA_BY_IDENTIFIER || this->mSID == DIA_C_U8_UDS_SID_WRITE_DATA_BY_IDENTIFIER) {
         oDiagMsgBuffer().vSetDataLength(DATA_START + DATA_LENGTH);
         // Sending back the positive answer
         for (tU8 i = 0; i < DATA_LENGTH; i++) {
            (void) oDiagMsgBuffer().vSetDataU8(DATA_START + i, u8propData[i]);
         }
      } else if (this->mSID == DIA_C_U8_UDS_SID_IOCONTROL_BY_IDENTIFIER) {
         oDiagMsgBuffer().vSetDataLength((DATA_START+1) + DATA_LENGTH); // +1 IOCtrl - Control-Byte
         (void) oDiagMsgBuffer().vSetDataU8(DATA_START, 0x03);
         // Sending back the positive answer
         for (tU8 i = 0; i < DATA_LENGTH; i++) {
            (void) oDiagMsgBuffer().vSetDataU8((DATA_START+1) + i, u8propData[i]);
         }
      } else if (this->mSID == DIA_C_U8_UDS_SID_ROUTINE_CONTROL) {
         oDiagMsgBuffer().vSetDataLength(DATA_START+1 + DATA_LENGTH);
         // Sending back the positive answer
         for (tU8 i = 0; i < DATA_LENGTH; i++) {
            (void) oDiagMsgBuffer().vSetDataU8(DATA_START+1 + i, u8propData[i]);
         }
      } else {
         DIA_TR_ERR("dia_SrvHandler_SupportedIdentifiers::vProcessRequest UNKNOWN SID 0x%02x USED !", this->mSID);
      }
      vResReadyAndQuit();
   } else {
      DIA_TR_ERR("dia_SrvHandler_SupportedIdentifiers::vProcessRequest SH-INTERNAL FAILURE DETECTED !");
      oDiagMsgBuffer().vSetNegResp(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
      vResReadyAndQuit();
   }
}

tDiaResult
dia_SrvHandler_SupportedIdentifiers::addV850ServicesToSupportedIdentifiers(const dia_Session* session, tU8 service, std::vector<tU8>& supportedIdents, tU16 bitMask) const
{
   dia_tclFnctTrace trc("dia_SrvHandler_SupportedIdentifiers::addV850ServicesToSupportedIdentifiers");
   tDiaResult retCode = DIA_FAILED;

#ifdef __DIA_UNIT_TESTING__
   DIA_TR_INF("dia_SrvHandler_SupportedIdentifiers::addV850... session = 0x%02x .", session->getID());
   DIA_TR_INF("dia_SrvHandler_SupportedIdentifiers::addV850... service = 0x%02x .", service);
   if(bitMask!=0xFFFF)
   {
      DIA_TR_INF("dia_SrvHandler_SupportedIdentifiers::addV850... bitMask = 0x%04x .", bitMask);
   }
   else
   {
      DIA_TR_INF("dia_SrvHandler_SupportedIdentifiers::addV850... Read High Bytes .");
   }
#endif

   tU8 entiresV850 = sizeof(serviceV850InfoRep) / sizeof(serviceV850InfoRep[0]);
   for(tU8 i=0; i<entiresV850; i++)
   {
#ifdef __DIA_UNIT_TESTING__
      DIA_TR_INF("dia_SrvHandler_SupportedIdentifiers::addV850... Entry[%d] SID=0x%02x DID=0x%04x.", i, serviceV850InfoRep[i].mSID, serviceV850InfoRep[i].mDID);
      DIA_TR_INF("dia_SrvHandler_SupportedIdentifiers::addV850... Session List: 0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x ...", serviceV850InfoRep[i].mSupportedSessions[0], serviceV850InfoRep[i].mSupportedSessions[1], serviceV850InfoRep[i].mSupportedSessions[2], serviceV850InfoRep[i].mSupportedSessions[3], serviceV850InfoRep[i].mSupportedSessions[4]);
#endif

      // SESSION
      tBool sessionFound = FALSE;
      tU8 entiresSession = sizeof(serviceV850InfoRep[i].mSupportedSessions) / sizeof(serviceV850InfoRep[i].mSupportedSessions[0]);
      //DIA_TR_INF("dia_SrvHandler_SupportedIdentifiers::addV850... No entiresSession=%d .", entiresSession);
      for(tU8 x=0; x<entiresSession; x++){
         //DIA_TR_INF("dia_SrvHandler_SupportedIdentifiers::addV850... Compare mSession=0x%02x == getSession=0x%02x .", serviceV850InfoRep[i].mSupportedSessions[x], session->getID());
         if(serviceV850InfoRep[i].mSupportedSessions[x] == session->getID()){
            DIA_TR_INF("dia_SrvHandler_SupportedIdentifiers::addV850... Session 0x%02x found.", session->getID());
            sessionFound = TRUE;
            break;
         } /* else {
            covered in sessionFound==TRUE block below.
         } */
      }

      // SERVICE
      if(sessionFound==TRUE)
      {
         if(serviceV850InfoRep[i].mSID == service)
         {
#ifdef __DIA_UNIT_TESTING__
            DIA_TR_INF("dia_SrvHandler_SupportedIdentifiers::addV850... service 0x%02x found.", service);
#endif
         }
         else
         {
#ifdef __DIA_UNIT_TESTING__
            DIA_TR_INF("dia_SrvHandler_SupportedIdentifiers::addV850... no service 0x%02x available.", service);
#endif
            return DIA_SUCCESS;
         }
      }
      else
      {
         // check for session at this position because sessions search is in for-loop and first session which doesn't match cause a return and not all sessions are checked.
#ifdef __DIA_UNIT_TESTING__
         DIA_TR_INF("dia_SrvHandler_SupportedIdentifiers::addV850... No Elements available for Session 0x%02x .", session->getID());
#endif
         return DIA_SUCCESS;
      }

      // DID according bitMask
      if(bitMask==0xFFFF /* Default */ || bitMask==0xDFFF /* Generated Mask for High Bytes */)
      {
         // write high Byte
         tU8 hb = serviceV850InfoRep[i].mDID>>8;
         // 1.) check if high byte is already included in list
         if ( std::find(supportedIdents.begin(), supportedIdents.end(), hb) == supportedIdents.end() ) //lint !e864: lint claims evaluation order, but this doesn't have any effect here.
         {
            // 2.) if not, add it.
            DIA_TR_INF("dia_SrvHandler_SupportedIdentifiers::addV850... add HB (0x%02x) of DID 0x%04x to response .", hb, serviceV850InfoRep[i].mDID);
            supportedIdents.push_back(hb);
         }
         else
         {
            DIA_TR_INF("dia_SrvHandler_SupportedIdentifiers::addV850... HB (0x%02x) of DID 0x%04x already in response .", hb, serviceV850InfoRep[i].mDID);
         }
      }
      else
      {
         // check if the bitmask matches the high byte of the configrued DID
		 if (bitMask == (serviceV850InfoRep[i].mDID | 0x00FF))
		 {
			// write low Byte
            tU8 lb = (tU8)serviceV850InfoRep[i].mDID;
            DIA_TR_INF("dia_SrvHandler_SupportedIdentifiers::addV850... add LB (0x%02x) of DID 0x%04x to response .", lb, serviceV850InfoRep[i].mDID);
            supportedIdents.push_back(lb);
		 }
		 else
		 {
			//do nothing
		 }
      }

      retCode = DIA_SUCCESS;
   }

   return retCode;
}


//-------------------------------------------------------------------------------

tDiaResult
dia_SrvHandler_SupportedIdentifiers::makeLookupKeys ( std::vector<dia_LookupKey*>& keys )
{
#ifdef __DIA_UNIT_TESTING__
   dia_tclFnctTrace trc("dia_SrvHandler_SupportedIdentifiers::makeLookupKeys");
#endif

   // create key entries for all 256 DIDs of this specific SID
   keys.reserve(256);
   for (tU16 i=0x0000 ; i<=0x00FF; i++ ) {
      tU16 did = DIA_C_U16_DID_AIVI_SUPPORTED_IDENTIFIER_BASE | i;
      keys.push_back( OSAL_NEW dia_LookupKey( this->getSID(), (tU16) did, DIA_C_U16_SRVDISPATCHER_KEY_LENGTH_NOT_USED) );
   }

   return DIA_SUCCESS;
}
