 /*
 * \file        dia_SrvHandler_SecondaryOperationalReference.cpp
 *
 * \brief       {insert brief description here}
 *
 * \details     Since there is no secondary software the service shall return a fixed record of 10 ASCII characters '0' (0x30) i.e. "0000000000".
 *
 *
 * \author      nbs3kor
 * \date        July 16, 2015
 *
 * \copyright   Robert Bosch Car Multimedia 2015
 */


#include "project/services/customer/dia_SrvHandler_SecondaryOperationalReference.h"

#ifndef __INCLUDED_DIA_DEFINES_UDS__
#include <common/framework/protocols/uds/dia_defsUds.h>
#endif

//#ifndef __INCLUDED_DIA_CONFIG_MANAGER__
//#include "common/framework/config/dia_ConfigManager.h"
//#endif

#ifndef __INCLUDED_DIA_MESSAGE_BUFFER__
#include "common/framework/engine/dia_MessageBuffer.h"
#endif

#ifndef __INCLUDED_DIA_FACTORY__
#include "common/framework/application/dia_Factory.h"
#endif

#define DIA_U16_READDATA_BY_ID_REQUEST_LENGTH       ((tU16) (1 + mDIDLen))
#define DIA_U8_SECONDARY_OPERATIONAL_REFERENCE_SIZE  (tU8 ) 10
#define DATA_START                                   (tU8 )  3

//-----------------------------------------------------------------------------

dia_SrvHandler_SecondaryOperationalReference::dia_SrvHandler_SecondaryOperationalReference ( void )
   : dia_ServiceHandlerUDS("dia_SrvHandler_SecondaryOperationalReference", DIA_C_U8_UDS_SID_READ_DATA_BY_IDENTIFIER, (tU16) DIA_C_U16_DID_AIVI_SECONDARY_OPERATIONAL_REFERENCE)
{
   dia_tclFnctTrace trc("dia_SrvHandler_SecondaryOperationalReference::dia_SrvHandler_SecondaryOperationalReference(void)");
}

//-----------------------------------------------------------------------------

dia_SrvHandler_SecondaryOperationalReference::~dia_SrvHandler_SecondaryOperationalReference ( void )
{}

//-----------------------------------------------------------------------------

void
dia_SrvHandler_SecondaryOperationalReference::vProcessRequest ( const std::vector<void*>& /*vecArgs */ )
{
   dia_tclFnctTrace trc("dia_SrvHandler_SecondaryOperationalReference::vOnProcessRequest");

   // data length contains at least sid, ctrl byte and DID --> 4 bytes minimum
   tU16 dataLength = oDiagMsgBuffer().u16GetDataLength();
   if ( dataLength !=  (DIA_U16_READDATA_BY_ID_REQUEST_LENGTH + 1) ) // one additional byte contains the message length
   {
      DIA_TR_INF("INVALID DATA LENGTH. EXPECTED %d BYTES BUT RECEIVED %d BYTES !!", (DIA_U16_READDATA_BY_ID_REQUEST_LENGTH+1),dataLength);
      vSendNegativeResponse(getInstanceOfFactory()->makeNRC(DIA_E_INVALID_MESSAGE_LENGHT_OR_INVALID_FORMAT));
      return;
   }

   oDiagMsgBuffer().vSetPosResp();
   // Sending back the positive answer
   oDiagMsgBuffer().vSetDataLength(DATA_START + DIA_U8_SECONDARY_OPERATIONAL_REFERENCE_SIZE);

   for (tU16 i = 0; i < DIA_U8_SECONDARY_OPERATIONAL_REFERENCE_SIZE; ++i)
   {
	 (void) oDiagMsgBuffer().vSetDataU8(DIA_U16_READDATA_BY_ID_REQUEST_LENGTH+i, '0');
   }

   vResReadyAndQuit();
}

