 /*
 * \file        dia_SrvHandler_ReadVehicleSnapShotData.cpp
 *
 * \brief       {insert brief description here}
 *
 * \details    
 *
 * \copyright   Robert Bosch Car Multimedia 2015
 */


#include "project/services/customer/dia_SrvHandler_ReadVehicleSnapShotData.h"

#ifndef __INCLUDED_DIA_MESSAGE_BUFFER__
#include "common/framework/engine/dia_MessageBuffer.h"
#endif

#ifndef __INCLUDED_DIA_DEFINES_UDS__
#include <common/framework/protocols/uds/dia_defsUds.h>
#endif

#ifndef __INCLUDED_DIA_LOOKUPKEY__
#include "common/framework/engine/dia_LookupKey.h"
#endif

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#ifndef __INCLUDED_DIA_SIGMA__
#include <project/framework/sigma/dia_Sigma.h>
#endif

//-----------------------------------------------------------------------------
dia_SrvHandler_ReadVehicleSnapShotData::dia_SrvHandler_ReadVehicleSnapShotData()
   : dia_ServiceHandlerUDS("dia_SrvHandler_ReadVehicleSnapShotData")
{
   dia_tclFnctTrace trc("dia_SrvHandler_ReadVehicleSnapShotData::dia_SrvHandler_ReadVehicleSnapShotData()");
}

//-----------------------------------------------------------------------------
dia_SrvHandler_ReadVehicleSnapShotData::~dia_SrvHandler_ReadVehicleSnapShotData( void )
{
}

//-------------------------------------------------------------------------------

void
dia_SrvHandler_ReadVehicleSnapShotData::vProcessRequest ( const std::vector<void*>&  )
{
   dia_tclFnctTrace trc("dia_SrvHandler_ReadVehicleSnapShotData::vProcessRequest");
   const tU16 DATA_START = 3;

   // get DID
   tU16 did = oDiagMsgBuffer().u16GetSubServiceId();
   DIA_TR_INF("dia_SrvHandler_ReadVehicleSnapShotData::did: 0x%02x", did);
   dia_Sigma const* pSigma = dia_Sigma::getInstance();

   std::vector<tU8> sigmaData;
   if(pSigma && pSigma->getData(did, sigmaData))
   {
      oDiagMsgBuffer().vSetPosResp();
      oDiagMsgBuffer().vSetDataLength(static_cast<tU16>((DATA_START + sigmaData.size()) & 0xffff));
      for (std::vector<tU8>::size_type i = 0; i < sigmaData.size(); ++i) 
      {
         (void) oDiagMsgBuffer().vSetDataU8(static_cast<tU16>((DATA_START+i) & 0xffff), sigmaData[i]);
      }
      vResReadyAndQuit();

   }
   else
   { // Sending back the Negative answer
      DIA_TR_INF("dia_SrvHandler_ReadCustomerSWVersion::ReadDataByIdentifier FAIL <--------------");
      vSendNegativeResponse(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
   }
   
   return;
}

tDiaResult
dia_SrvHandler_ReadVehicleSnapShotData::makeLookupKeys ( std::vector<dia_LookupKey*>& keys )
{
#ifdef __DIA_UNIT_TESTING__
   dia_tclFnctTrace trc("dia_SrvHandler_ReadVehicleSnapShotData::makeLookupKeys");
#endif

   keys.push_back( OSAL_NEW dia_LookupKey( DIA_C_U8_UDS_SID_READ_DATA_BY_IDENTIFIER, (tU16) DIA_C_U16_DID_AIVI_VEHICLE_SNAPSHOT_DATA_FRAMES_00, DIA_C_U16_SRVDISPATCHER_KEY_LENGTH_NOT_USED) ); // ReadDataByIdentifier - vehicle snapshot data dataset 00
   keys.push_back( OSAL_NEW dia_LookupKey( DIA_C_U8_UDS_SID_READ_DATA_BY_IDENTIFIER, (tU16) DIA_C_U16_DID_AIVI_VEHICLE_SNAPSHOT_DATA_FRAMES_01, DIA_C_U16_SRVDISPATCHER_KEY_LENGTH_NOT_USED) ); // ReadDataByIdentifier - vehicle snapshot data dataset 01
   keys.push_back( OSAL_NEW dia_LookupKey( DIA_C_U8_UDS_SID_READ_DATA_BY_IDENTIFIER, (tU16) DIA_C_U16_DID_AIVI_VEHICLE_SNAPSHOT_DATA_FRAMES_02, DIA_C_U16_SRVDISPATCHER_KEY_LENGTH_NOT_USED) ); // ReadDataByIdentifier - vehicle snapshot data dataset 02
   return DIA_SUCCESS;
}

